<?php

return [
    'title' => 'Ajustes',
    'general_setting' => 'Configuración general',
    'menu' => 'Todos los ajustes',
    'email_setting_title' => 'Ajustes de correo electrónico',
    'email_setting_description' => 'Configurar los ajustes de correo electrónico',
    'general' => [
        'theme' => 'Tema',
        'title' => 'General',
        'description' => 'Configuración de la información del sitio',
        'rich_editor' => 'Editor rico',
        'site_title' => 'Título del sitio',
        'admin_email' => 'Correo electrónico de administrador',
        'seo_block' => 'Configuración SEO',
        'seo_title' => 'Título SEO',
        'seo_description' => 'Descripción SEO',
        'webmaster_tools_block' => 'Herramientas para webmasters de Google',
        'placeholder' => [
            'site_title' => 'Título del sitio (máximo 120 caracteres)',
            'admin_email' => 'Correo electrónico de administrador',
            'seo_title' => 'Título SEO (máximo 120 caracteres)',
            'seo_description' => 'Descripción SEO (máximo 120 caracteres)',
            'google_analytics' => 'Google analitico',
        ],
        'enable_send_error_reporting_via_email' => '¿Activar el envío de informes de errores por correo electrónico?',
        'enable_send_error_reporting_via_email_helper' => 'Cuando esté habilitado, se enviarán informes detallados de errores a las direcciones de correo electrónico de administrador cuando ocurran errores críticos en el sitio',
        'time_zone' => 'Zona horaria',
        'time_zone_helper' => 'Seleccione la zona horaria para su sitio web. Esto se utilizará para todas las visualizaciones de fecha y hora en todo el sistema',
        'enable' => 'Permitir',
        'disable' => 'Desactivar',
        'disabled_helper' => '¡No se puede desactivar esta plantilla de correo electrónico!',
        'enable_cache_site_map' => '¿Habilitar el mapa del sitio en caché?',
        'cache_time_site_map' => 'Cache Time Site map',
        'admin_logo' => 'Logotipo de administrador',
        'admin_favicon' => 'favicon de administrador',
        'admin_title' => 'Título de administrador',
        'admin_title_placeholder' => 'Título mostrado en la pestaña del navegador.',
        'admin_appearance_title' => 'Apariencia de administrador',
        'admin_appearance_description' => 'Configuración de la apariencia del administrador, como editor, idioma...',
        'seo_block_description' => 'Configuración del título del sitio, la meta descripción del sitio y la palabra clave del sitio para optimizar el SEO',
        'webmaster_tools_description' => 'Google Webmaster Tools (GWT) es un software gratuito que le ayuda a gestionar la parte técnica de su sitio web.',
        'yes' => 'Sí',
        'no' => 'No',
        'show_on_front' => 'Se muestra tu página de inicio',
        'select' => '- Seleccionar -',
        'show_site_name' => '¿Mostrar el nombre del sitio después del título de la página, separarlo con "-"?',
        'locale' => 'Idioma del sitio',
        'locale_direction' => 'Dirección del idioma',
        'minutes' => 'minutos',
        'redirect_404_to_homepage' => '¿Redirigir todas las solicitudes no encontradas a la página de inicio?',
    ],
    'admin_appearance' => [
        'title' => 'Apariencia del administrador',
        'description' => 'Ver y actualizar el logotipo, favicon, diseño,...',
        'layout' => 'Disposición',
        'layout_helper' => 'Choose between horizontal menu (top navigation bar) or vertical menu (side navigation bar)',
        'horizontal' => 'Horizontal',
        'vertical' => 'Vertical',
        'show_menu_item_icon' => '¿Mostrar icono de elemento de menú?',
        'language' => 'Idioma en el panel de administración',
        'theme_mode' => 'Modo tema',
        'dark' => 'Oscuro',
        'light' => 'Luz',
        'container_width' => [
            'title' => 'Ancho del contenedor',
            'title_helper' => 'Set the maximum width for content containers in the admin panel',
            'default' => 'Por defecto',
            'large' => 'Grande',
            'full' => 'Lleno',
        ],
        'form' => [
            'admin_logo' => 'Logotipo de administrador',
            'admin_logo_helper' => 'Upload a custom logo to display in the admin panel header. Recommended size: 150x50px',
            'admin_logo_max_height' => 'Logo height (px)',
            'admin_logo_max_height_helper' => 'Set the height of the logo in pixels. The default value is :default.',
            'admin_favicon' => 'favicon de administrador',
            'admin_favicon_helper' => 'Upload a favicon for the admin panel. This icon appears in browser tabs and bookmarks',
            'admin_favicon_type' => 'Admin favicon type',
            'admin_favicon_type_helper' => 'Select the image format of your favicon. ICO format is recommended for best browser compatibility',
            'admin_title' => 'Título de administrador',
            'admin_title_helper' => 'Set the title that appears in the browser tab when viewing admin pages',
            'admin_title_placeholder' => 'Título mostrado en la pestaña del navegador.',
            'admin_login_screen_backgrounds' => 'Fondos de pantalla de inicio de sesión (~1366x768)',
            'admin_login_screen_backgrounds_helper' => 'Upload one or more background images for the login screen. Images will rotate randomly. Recommended size: 1366x768px',
            'admin_locale' => 'Idioma del administrador',
            'admin_locale_helper' => 'Choose the language for the admin panel interface',
            'admin_locale_direction' => 'Dirección del idioma del administrador',
            'admin_locale_direction_helper' => 'Set text direction for the admin panel. Choose RTL for languages like Arabic or Hebrew',
            'rich_editor' => 'Editor rico',
            'rich_editor_helper' => 'Select the default rich text editor for content creation throughout the admin panel',
            'primary_font' => 'fuente principal',
            'primary_font_helper' => 'Choose the primary font family for the admin panel. This font will be used for most text',
            'primary_color' => 'Color primario',
            'primary_color_helper' => 'Set the primary theme color used for buttons, links, and highlights. Default: #206bc4',
            'secondary_color' => 'Color secundario',
            'secondary_color_helper' => 'Set the secondary theme color used for less prominent UI elements. Default: #6c7a91',
            'heading_color' => 'color del encabezado',
            'heading_color_helper' => 'Set the color for headings throughout the admin panel. Use "inherit" to use the default text color',
            'text_color' => 'Color de texto',
            'text_color_helper' => 'Set the default text color for the admin panel. Default: #182433',
            'link_color' => 'Color de enlace',
            'link_color_helper' => 'Set the color for links in the admin panel. Default: #206bc4',
            'link_hover_color' => 'Color al pasar el cursor sobre el enlace',
            'link_hover_color_helper' => 'Set the color for links when hovering over them. Default: #1a569d',
            'show_menu_item_icon' => '¿Mostrar icono de elemento de menú?',
            'show_menu_item_icon_helper' => 'Display icons next to menu items in the admin navigation for better visual recognition',
            'custom_css' => 'CSS personalizado',
            'custom_css_helper' => 'Add custom CSS styles to override or extend the default admin panel styling',
            'custom_js' => 'JS personalizado',
            'custom_header_js' => 'Encabezado JS',
            'custom_header_js_placeholder' => 'JS en el encabezado de la página, envuélvalo dentro de <script></script>',
            'custom_body_js' => 'Cuerpo JS',
            'custom_body_js_placeholder' => 'JS en el cuerpo de la página, envuélvalo dentro de <script></script>',
            'custom_footer_js' => 'Pie de página JS',
            'custom_footer_js_placeholder' => 'JS en el pie de página de la página, envuélvalo dentro de <script></script>',
        ],
    ],
    'datatable' => [
        'title' => 'Tablas de datos',
        'description' => 'Ajustes para tablas de datos',
        'form' => [
            'show_column_visibility' => '¿Mostrar visibilidad de columna predeterminada?',
            'show_column_visibility_helper' => 'Enable the column visibility toggle button in data tables to allow users to show/hide columns',
            'show_export_button' => '¿Mostrar botón de exportación predeterminado?',
            'show_export_button_helper' => 'Display export options (CSV, Excel, PDF) in data tables for downloading table data',
            'pagination_type' => 'Tipo de paginación',
            'pagination_type_helper' => 'Choose how pagination controls are displayed: Default shows page numbers, Dropdown shows a compact dropdown selector',
            'default' => 'Por defecto',
            'dropdown' => 'Desplegable',
            'enable_responsive' => 'Enable table responsive',
            'enable_responsive_helper' => 'Automatically adjust table columns to fit different screen sizes for better mobile experience',
        ],
    ],
    'email' => [
        'subject' => 'Sujeto',
        'content' => 'Contenido',
        'title' => 'Configuración de plantilla de correo electrónico',
        'description' => 'Plantilla de correo electrónico utilizando HTML y variables del sistema.',
        'reset_to_default' => 'Restablecen a los predeterminados',
        'back' => 'Volver a la configuración',
        'reset_success' => 'Restablecer los valores predeterminados con éxito',
        'confirm_reset' => '¿Confirmar restablecer plantilla de correo electrónico?',
        'confirm_message' => '¿Realmente deseas restablecer esta plantilla de correo electrónico a sus valores predeterminados?',
        'continue' => 'Continuar',
        'sender_name' => 'Nombre del remitente',
        'sender_name_placeholder' => 'Nombre',
        'sender_name_helper' => 'The name that will appear in the From field of emails sent by the system',
        'sender_email' => 'Correo electrónico del remitente',
        'sender_email_placeholder' => 'Email address (e.g. :default)',
        'sender_email_helper' => 'The email address that will be used as the sender for all emails sent by the system',
        'mailer' => 'Remitente',
        'port' => 'Puerto',
        'port_placeholder' => 'Ej: 587',
        'port_helper' => 'The port used by your mail server (common ports: 25, 465, 587)',
        'host' => 'Anfitrión',
        'host_placeholder' => 'Ej: smtp.gmail.com',
        'host_helper' => 'SMTP host address',
        'username' => 'Nombre de usuario',
        'username_placeholder' => 'Nombre de usuario para iniciar sesión en el servidor de correo',
        'username_helper' => 'Your mail server login username',
        'password' => 'Contraseña',
        'password_placeholder' => 'Contraseña para iniciar sesión en el servidor de correo',
        'password_helper' => 'Your mail server login password',
        'encryption' => 'Cifrado',
        'encryption_placeholder' => 'Cifrado: ssl o tls',
        'encryption_helper' => 'Choose the encryption method for secure email transmission',
        'encryption_none' => 'None',
        'encryption_tls' => 'TLS',
        'encryption_ssl' => 'SSL',
        'setup_tips_title' => 'Email Setup Tips',
        'setup_tip_gmail' => 'For Gmail: Use smtp.gmail.com as host, port 587 with TLS or port 465 with SSL. Enable "Less secure app access" or use an App Password.',
        'setup_tip_port' => 'Common ports: 25 (unencrypted), 587 (TLS/STARTTLS), 465 (SSL/TLS), 2525 (alternative).',
        'setup_tip_encryption' => 'Use TLS for port 587 (recommended), SSL for port 465, or None for port 25 (not recommended for production).',
        'setup_tip_test' => 'Always use "Send Test Email" button to verify your configuration before saving.',
        'setup_tip_mailgun' => 'For better deliverability, consider using email services like Mailgun, SendGrid, or Amazon SES instead of SMTP.',
        'queue_warning_title' => 'Configuración de Cola Requerida',
        'queue_warning_description' => 'Su cola de correo electrónico está actualmente configurada para usar el controlador ":default", pero su trabajador de cola podría no estar funcionando. Esto significa que los correos electrónicos no se enviarán hasta que configure un trabajador de cola.',
        'queue_warning_action' => 'Para enviar correos electrónicos inmediatamente sin un trabajador de cola, establezca QUEUE_CONNECTION=sync en su archivo .env. De lo contrario, asegúrese de que su trabajador de cola esté funcionando con "php artisan queue:work". <a href="https://laravel.com/docs/12.x/queues" target="_blank" rel="noopener">Obtenga más información sobre Laravel Queues</a>.',
        'mail_gun_domain' => 'Dominio',
        'mail_gun_domain_placeholder' => 'Dominio',
        'mail_gun_domain_helper' => 'The domain name you registered with Mailgun',
        'mail_gun_secret' => 'Secreto',
        'mail_gun_secret_placeholder' => 'Secreto',
        'mail_gun_secret_helper' => 'Your Mailgun API key',
        'mail_gun_endpoint' => 'Punto final',
        'mail_gun_endpoint_placeholder' => 'Punto final',
        'mail_gun_endpoint_helper' => 'Mailgun API endpoint (api.mailgun.net for US, api.eu.mailgun.net for EU)',
        'log_channel' => 'Canal de registro',
        'log_channel_helper' => 'Select which logging channel to use for email logs',
        'sendmail_path' => 'Ruta de envío de correo',
        'local_domain' => 'Dominio local',
        'local_domain_placeholder' => 'Puede estar vacío. Debe configurarse en su dominio cuando se utiliza SMTP Relay. P.ej. tu-dominio.com',
        'local_domain_helper' => 'The domain that will be used to identify the server when communicating with remote SMTP servers',
        'ses_key' => 'Llave',
        'ses_key_placeholder' => 'Llave',
        'ses_key_helper' => 'Your AWS access key ID',
        'ses_secret' => 'Secreto',
        'ses_secret_placeholder' => 'Secreto',
        'ses_secret_helper' => 'Your AWS secret access key',
        'ses_region' => 'Región',
        'ses_region_placeholder' => 'Región',
        'ses_region_helper' => 'The AWS region where your SES service is configured',
        'postmark_token' => 'Simbólico',
        'postmark_token_placeholder' => 'Simbólico',
        'postmark_token_helper' => 'Your Postmark server token',
        'resend_key' => 'API Key',
        'resend_key_placeholder' => 'Ex: re_123456789012345678901234567890',
        'resend_key_helper' => 'Your Resend API key',
        'email_templates' => 'Plantillas de correo electrónico',
        'email_templates_description' => 'Plantilla de correo electrónico utilizando HTML y variables del sistema.',
        'email_template_settings' => 'Ajustes de plantillas de correo electrónico',
        'email_template_settings_description' => 'Ver y actualizar la configuración de sus plantillas de correo electrónico',
        'email_rules' => 'Reglas de correo electrónico',
        'email_rules_description' => 'Configurar reglas de correo electrónico para validación.',
        'base_template' => 'Plantilla base',
        'base_template_description' => 'Plantilla base para todos los correos electrónicos',
        'template_header' => 'Encabezado de la plantilla de correo electrónico',
        'template_header_description' => 'Plantilla para encabezado de correos electrónicos',
        'template_footer' => 'Pie de página de la plantilla de correo electrónico',
        'template_footer_description' => 'Plantilla para pie de página de correos electrónicos',
        'default' => 'Por defecto',
        'template_off_status_helper' => 'Esta plantilla de correo electrónico está desactivada.',
        'blacklist_email_domains' => 'Dominios de correo electrónico en lista negra',
        'blacklist_email_domains_helper' => 'Ingresa una lista de dominios de correo electrónico para ser incluidos en la lista negra. Por ejemplo, gmail.com, yahoo.com.',
        'blacklist_specified_emails' => 'Direcciones de correo electrónico en lista negra',
        'blacklist_specified_emails_helper' => 'Ingrese una lista de direcciones de correo electrónico específicas para ser incluidas en la lista negra. Por ejemplo, mail@example.com.',
        'exception_emails' => 'Correos electrónicos de excepción',
        'exception_emails_helper' => 'Estos correos electrónicos serán excluidos de las reglas de validación.',
        'email_rules_strict' => 'Validación estricta de correos electrónicos',
        'email_rules_strict_helper' => 'Realizar una validación de correo electrónico similar a RFC con reglas estrictas.',
        'email_rules_dns' => 'Validación de comprobación DNS',
        'email_rules_dns_helper' => 'Comprobar si existen registros DNS que indiquen que el servidor acepta correos electrónicos.',
        'email_rules_spoof' => 'Detección de suplantación',
        'email_rules_spoof_helper' => 'Detectar posibles intentos de suplantación de correo electrónico.',
        'template_turn_off' => 'Haga clic para desactivar esta plantilla de correo electrónico',
        'template_turn_on' => 'Haga clic para activar esta plantilla de correo electrónico',
        'turn_on_success_message' => '¡Active la plantilla de correo electrónico correctamente!',
        'turn_off_success_message' => '¡Desactive la plantilla de correo electrónico correctamente!',
        'email_template_status' => 'Estatus de la plantilla de correo electrónico',
        'email_template_status_description' => 'Activar/desactivar la plantilla de correo electrónico',
        'email_template_logo' => 'Logo',
        'email_template_logo_helper_text' => 'Si no lo configura, obtendrá el logotipo de administrador en Administrador -> Configuración -> Apariencia de administrador -> Logotipo.',
        'email_template_copyright_text_helper_text' => 'Si no lo configura, obtendrá los derechos de autor de las opciones del tema en Administrador -> Apariencia -> Opciones del tema -> General -> Copyright.',
        'email_template_email_contact' => 'Correo electrónico de contacto',
        'email_template_email_contact_helper_text' => 'Si no se establece, se obtendrá del correo electrónico del remitente en Administrador -> Configuración -> Correo electrónico.',
        'email_template_social_links' => 'vínculos sociales',
        'email_template_copyright_text' => 'Derechos de autor',
        'image_upload_supported' => 'Solo admite formatos PNG, JPG, JPEG y GIF.',
        'email_template_custom_css' => 'CSS personalizado de la plantilla de correo electrónico',
        'social_links' => [
            'name' => 'Nombre',
            'icon' => 'Icono',
            'icon_image' => 'Imagen de icono (solo admite formatos PNG, JPG, JPEG y GIF).',
            'url' => 'URL',
            'image' => 'Imagen',
        ],
        'logo_height' => 'Logo height (px)',
        'logo_height_helper' => 'Set the height of the logo in pixels. The default value is :default.',
    ],
    'license_title' => 'Licencia',
    'setup_license' => 'Setup license code',
    'close' => 'Close',
    'media' => [
        'title' => 'Medios de comunicación',
        'driver' => 'Conductor',
        'description' => 'Configuraciones para medios',
        'local_disk' => 'Local disk',
        'aws_access_key_id' => 'ID de clave de acceso de AWS',
        'aws_secret_key' => 'Clave secreta de AWS',
        'aws_default_region' => 'Región predeterminada de AWS',
        'aws_bucket' => 'Cubo de AWS',
        'aws_url' => 'URL de AWS',
        'aws_endpoint' => 'Punto final de AWS (opcional)',
        'use_path_style_endpoint' => '¿Usar punto final de estilo de ruta?',
        'r2_access_key_id' => 'ID de clave de acceso R2',
        'r2_secret_key' => 'Clave secreta R2',
        'r2_bucket' => 'Cuchara R2',
        'r2_url' => 'URL R2',
        'r2_endpoint' => 'Punto final R2',
        'do_spaces_access_key_id' => 'ID de clave de acceso a espacios DO',
        'do_spaces_secret_key' => 'Clave secreta de DO Spaces',
        'do_spaces_default_region' => 'Región predeterminada de espacios DO',
        'do_spaces_bucket' => 'Cubo de espacios DO',
        'do_spaces_endpoint' => 'Punto final de espacios DO',
        'do_spaces_cdn_enabled' => '¿Está habilitada la CDN de DO Spaces?',
        'do_spaces_cdn_enabled_helper' => 'Cuando esté habilitado, los archivos multimedia se entregarán a través de la CDN de DigitalOcean Spaces para una entrega de contenido global más rápida. Opcionalmente, puede configurar un dominio CDN personalizado a continuación.',
        'media_do_spaces_cdn_custom_domain' => 'Dominio personalizado de Spaces CDN',
        'media_do_spaces_cdn_custom_domain_placeholder' => 'https://tu-dominio-personalizado.com',
        'wasabi_access_key_id' => 'ID de clave de acceso a Wasabi',
        'wasabi_secret_key' => 'Clave secreta de wasabi',
        'wasabi_default_region' => 'Región predeterminada de Wasabi',
        'wasabi_bucket' => 'Cubo de wasabi',
        'wasabi_root' => 'Raíz de Wasabi',
        'wasabi_root_helper' => 'Para reutilizar imágenes existentes, simplemente designe la raíz de Wasabi como "/", luego cargue todos los archivos actuales desde public/storage a su directorio raíz de Wasabi.',
        'backblaze_access_key_id' => 'ID de clave de acceso a Backblaze',
        'backblaze_secret_key' => 'Clave secreta de Backblaze',
        'backblaze_bucket' => 'Cubo de retroceso',
        'backblaze_default_region' => 'Región predeterminada de Backblaze',
        'backblaze_url' => 'URL de retroceso',
        'backblaze_endpoint' => 'Punto final de Backblaze',
        'backblaze_cdn_enabled' => '¿Está habilitado Backblaze CDN?',
        'backblaze_cdn_enabled_helper' => 'Cuando esté habilitado, los archivos multimedia se entregarán a través de una CDN para una entrega de contenido global más rápida. Debe configurar un dominio CDN personalizado a continuación (por ejemplo, Cloudflare CDN o Backblaze CDN).',
        'media_backblaze_cdn_custom_domain' => 'Dominio personalizado de Backblaze CDN',
        'media_backblaze_cdn_custom_domain_placeholder' => 'https://tu-dominio-personalizado.com',
        'default_placeholder_image' => 'Imagen de marcador de posición predeterminada',
        'enable_chunk' => '¿Habilitar la carga de tamaño de fragmento?',
        'chunk_size' => 'Tamaño del fragmento (Bytes)',
        'chunk_size_placeholder' => 'Predeterminado: 1048576 ~ 1 MB',
        'max_file_size' => 'Tamaño máximo de fragmento de archivo (MB)',
        'max_file_size_placeholder' => 'Valor predeterminado: 1048576 ~ 1 GB',
        'enable_watermark' => '¿Habilitar marca de agua?',
        'enable_watermark_helper' => 'Cuando está habilitado, se agregará automáticamente una marca de agua a las imágenes recién cargadas en las carpetas seleccionadas. Esto no afecta las imágenes existentes.',
        'watermark_source' => 'Imagen de marca de agua',
        'watermark_source_helper' => 'Supports only PNG, JPG, and JPEG formats. You should use image less than 200x200px and size smaller than 50KB.',
        'watermark_size' => 'Tamaño de la marca de agua (%)',
        'watermark_size_placeholder' => 'Predeterminado: 10 (%)',
        'watermark_opacity' => 'Opacidad de la marca de agua (%)',
        'watermark_opacity_placeholder' => 'Predeterminado: 70 (%)',
        'watermark_position' => 'Posición de la marca de agua',
        'watermark_position_x' => 'Posición de la marca de agua X',
        'watermark_position_y' => 'Posición de la marca de agua Y',
        'watermark_position_top_left' => 'Arriba a la izquierda',
        'watermark_position_top_right' => 'Parte superior derecha',
        'watermark_position_bottom_left' => 'Abajo a la izquierda',
        'watermark_position_bottom_right' => 'Abajo a la derecha',
        'watermark_position_center' => 'Centro',
        'turn_off_automatic_url_translation_into_latin' => 'Desactivar la traducción automática de URL al latín',
        'turn_off_automatic_url_translation_into_latin_helper' => 'Cuando está habilitado, las URL de los archivos no se transliterarán automáticamente a caracteres latinos, lo que conservará los caracteres originales de alfabetos no latinos.',
        'bunnycdn_hostname' => 'Nombre de host',
        'bunnycdn_zone' => 'Nombre de zona (el nombre de su zona de almacenamiento)',
        'bunnycdn_key' => 'Contraseña de acceso a FTP y API (la contraseña de acceso a API de la zona de almacenamiento)',
        'bunnycdn_region' => 'Región (La región de la zona de almacenamiento)',
        'optional' => 'Opcional',
        'sizes' => 'Tamaños de miniaturas de medios',
        'media_sizes_helper' => 'Establezca el ancho o el alto en 0 si solo desea recortar por ancho o alto.',
        'width' => 'Ancho',
        'height' => 'Altura',
        'default_size_value' => 'Default: :size',
        'all' => 'Todo',
        'all_helper_text' => 'Si desmarca todas las carpetas, se aplicará a todas las carpetas.',
        'media_folders_can_add_watermark' => 'Agregue marca de agua para imágenes en carpetas:',
        'max_upload_filesize' => 'Tamaño máximo de carga (MB)',
        'max_upload_filesize_placeholder' => 'Default: :size, must less than :size.',
        'max_upload_filesize_helper' => 'Your server allows to upload files maximum :size, you can change this value to limit upload filesize.',
        'image_processing_library' => 'Biblioteca de procesamiento de imágenes',
        'use_original_name_for_file_path' => 'Utilice el nombre original para la ruta del archivo',
        'use_original_name_for_file_path_helper' => 'Cuando está habilitado, los archivos cargados mantendrán sus nombres originales. Cuando está deshabilitado, los nombres de los archivos se convertirán en slugs compatibles con URL (por ejemplo, "Mi foto.jpg" se convierte en "mi-foto.jpg").',
        'keep_original_file_size_and_quality' => 'Mantenga el tamaño y la calidad del archivo original',
        'keep_original_file_size_and_quality_helper' => 'Cuando está habilitado, las imágenes cargadas no cambiarán de tamaño ni se optimizarán, preservando su calidad y tamaño de archivo originales. Cuando está deshabilitado, las imágenes se pueden comprimir y cambiar de tamaño según su configuración.',
        'update_thumbnail_sizes_warning' => 'Después de ajustar los tamaños de las miniaturas, debe hacer clic en el botón ":button_text" para actualizarlas.',
        'thumbnail_crop_position' => 'Posición de recorte de miniaturas',
        'thumbnail_crop_position_left' => 'Izquierda',
        'thumbnail_crop_position_center' => 'Centro',
        'thumbnail_crop_position_right' => 'Bien',
        'thumbnail_crop_position_top' => 'Arriba',
        'thumbnail_crop_position_bottom' => 'Abajo',
        'thumbnail_crop_position_helper' => 'Esta configuración se utiliza para recortar la imagen al generar miniaturas. Se recortará desde esta posición hasta que se llene la imagen.',
        'user_can_only_view_own_media' => 'Los usuarios solo pueden ver sus propios medios.',
        'user_can_only_view_own_media_helper' => 'Cuando está habilitado, los usuarios solo pueden ver sus propios medios, mientras que los superadministradores pueden ver todos los medios.',
        'enable_thumbnail_sizes' => 'Enable thumbnail sizes',
        'enable_thumbnail_sizes_helper' => 'Enable this option to generate thumbnails for images. If it is disabled, the system will not generate thumbnails for images and always use full size image.',
        'convert_image_to_webp' => 'Convert JPG, JPEG, PNG image to WebP',
        'convert_image_to_webp_helper' => 'WebP is a modern image format that provides superior lossless and lossy compression for images on the web. It is supported in Chrome, Firefox, Edge, and Opera. Image will be converted to WebP format when uploading. It is just applied for JPG, JPEG, PNG images.',
        'reduce_large_image_size' => 'Reduce large image size when uploading',
        'reduce_large_image_size_helper' => 'When enabled, the system will reduce the size of large images when uploading, applied for JPG, JPEG, PNG, WebP image. The maximum width and height of the image will be resized to the values you set below.',
        'image_max_width' => 'Image max width (px)',
        'image_max_height' => 'Image max height (px)',
        'image_max_width_placeholder' => 'Leave blank to keep original width',
        'image_max_height_placeholder' => 'Leave blank to keep original height',
        'image_max_width_helper' => 'Set the maximum width of the image in pixels. The original width will be kept if this field is empty.',
        'image_max_height_helper' => 'Set the maximum height of the image in pixels. The original height will be kept if this field is empty.',
        'customize_upload_path' => 'Customize upload path',
        'customize_upload_path_helper' => 'Customize the upload path for media files. By default, the system will upload files to the ":path" folder.',
        'upload_path' => 'Upload path',
        'upload_path_placeholder' => 'Example: uploads',
        'upload_path_helper' => 'That folder will be created in /public. The default folder is ":folder". Then it will be uploaded into "/public/:folder".',
        'upload_path_warning' => 'The system won\'t move existing files to the new folder. If you want to move existing files to the new folder, you need to do it manually.',
        'convert_file_name_to_uuid' => 'Convert file name to UUID',
        'convert_file_name_to_uuid_helper' => 'When enabled, the system will convert the file name to UUID when uploading. It is useful to prevent duplicate file names and better security.',
        's3_path' => 'Custom S3 Path (Optional)',
        's3_path_placeholder' => 'Optional custom path in S3 bucket (e.g., uploads/media)',
    ],
    'field_type_not_exists' => 'This field type does not exist',
    'save_settings' => 'Guardar ajustes',
    'template' => 'Plantilla',
    'description' => 'Descripción',
    'enable' => 'Permitir',
    'send' => 'Enviar',
    'test_email_description' => 'Para enviar un correo electrónico de prueba, asegúrese de tener la configuración actualizada para enviar correo.',
    'test_email_input_placeholder' => 'Ingrese el correo electrónico que desea enviar el correo electrónico de prueba.',
    'test_email_modal_title' => 'Enviar un correo electrónico de prueba',
    'test_send_mail' => 'Enviar correo de prueba',
    'test_email_send_success' => '¡Correo electrónico enviado correctamente!',
    'locale_direction_ltr' => 'De izquierda a derecha',
    'locale_direction_rtl' => 'De derecha a izquierda',
    'emails_warning' => 'Puedes agregar un máximo de :count correos electrónicos.',
    'email_add_more' => 'Añadir más',
    'generate' => 'Generar',
    'generate_thumbnails' => 'Generar miniaturas',
    'generate_thumbnails_success' => 'Generate thumbnails successfully. :count files are generated!',
    'generate_thumbnails_error' => 'We are unable to regenerate thumbnail for these files :count files!',
    'generate_thumbnails_description' => '¿Está seguro de que desea volver a generar miniaturas para todas las imágenes? Tomará tiempo, así que NO abandone esta página, espere hasta que esté terminada.',
    'enable_chunk_description' => 'La carga de tamaño fragmentado se utiliza para cargar archivos de gran tamaño.',
    'watermark_description' => 'ADVERTENCIA: La marca de agua se acaba de agregar a las nuevas imágenes cargadas, no se agregará a las imágenes existentes. Deshabilitar la marca de agua no eliminará la marca de agua de las imágenes existentes.',
    'submit' => 'Entregar',
    'back' => 'Atrás',
    'enter_sample_value' => 'Introduzca valores de muestra para realizar pruebas',
    'preview' => 'Avance',
    'media_size_width' => ':size size width must be greater than 0',
    'media_size_height' => ':size size height must be greater than 0',
    'security' => [
        'title' => 'Configuración de seguridad',
        'description' => 'Verifique y configure los ajustes de seguridad para su sitio web.',
        'menu_description' => 'Gestionar la seguridad de cookies y encabezados HTTP',
        'status_secure' => '¡Todos los ajustes de seguridad están configurados correctamente!',
        'status_insecure' => '¡Algunos ajustes de seguridad necesitan atención!',
        'current_settings' => 'Configuración de seguridad actual',
        'status' => 'Estado',
        'setting' => 'Configuración',
        'current_value' => 'Valor actual',
        'recommended_value' => 'Recomendado',
        'session_http_only' => 'Bandera HttpOnly Cookie',
        'session_http_only_description' => 'Evita que JavaScript acceda a las cookies de sesión (protege contra ataques XSS)',
        'session_secure_cookie' => 'Bandera Secure Cookie',
        'session_secure_cookie_description' => 'Garantiza que las cookies solo se envíen a través de conexiones HTTPS',
        'session_same_site' => 'Bandera SameSite Cookie',
        'session_same_site_description' => 'Previene ataques CSRF al restringir cuándo se envían las cookies',
        'http_security_headers' => 'Encabezados de seguridad HTTP',
        'http_security_headers_description' => 'Agrega encabezados de seguridad para proteger contra vulnerabilidades web comunes',
        'https_warning' => 'Su sitio no está usando HTTPS',
        'https_warning_description' => 'Algunas características de seguridad como las cookies seguras requieren HTTPS. Considere habilitar SSL para su sitio web.',
        'how_to_fix' => 'Cómo solucionar problemas de seguridad',
        'env_file_location' => 'Edite su archivo .env ubicado en:',
        'add_to_env' => 'Configuraciones para agregar',
        'required_settings' => 'Configuraciones de seguridad requeridas',
        'for_https_sites' => 'Solo para sitios HTTPS',
        'copy' => 'Copiar',
        'copy_settings' => 'Copiar todas las configuraciones',
        'copied' => '¡Copiado!',
        'steps' => 'Pasos para aplicar configuraciones',
        'step_1' => 'Abra su archivo .env en un editor de texto',
        'step_2' => 'Agregue o actualice las configuraciones de seguridad mostradas arriba',
        'step_3' => 'Guarde el archivo .env',
        'step_4' => 'Limpie el caché usando Panel de administración → Administración de plataforma → Gestión de caché',
        'security_headers_info' => 'Información de encabezados de seguridad',
        'security_headers_list' => 'Cuando están habilitados, los siguientes encabezados se agregan a todas las respuestas:',
        'header_nosniff' => 'Evita que los navegadores adivinen los tipos de contenido',
        'header_frame' => 'Protege contra ataques de clickjacking',
        'header_xss' => 'Habilita la protección XSS del navegador',
        'header_referrer' => 'Controla cuánta información de referencia se envía',
        'learn_more' => 'Para información más detallada, consulte la :documentation',
        'documentation' => 'documentación de seguridad',
    ],
    'cache' => [
        'title' => 'Cache',
        'description' => 'Configurar la caché del sistema para optimizar la velocidad.',
        'form' => [
            'cache_admin_menu' => '¿Menú de administración de caché?',
            'cache_admin_menu_helper' => 'Cache admin menu for optimized speed. This option should be disabled if you are developing or customizing the admin menu.',
            'enable_cache_site_map' => '¿Habilitar el mapa del sitio en caché?',
            'enable_cache_site_map_helper' => 'Sitemap :url should be cached due to the large number of pages. If you have a small number of pages, you can disable this option.',
            'cache_time_site_map' => 'Tiempo de caché Mapa del sitio (minutos)',
            'cache_front_menu' => 'Cache front menu',
            'cache_front_menu_helper' => 'Cache front menu for optimized speed',
            'cache_user_avatar' => 'Cache user avatar',
            'cache_user_avatar_helper' => 'For users without avatar, the system will generate avatars from their usernames. The avatars will be cached for optimized speed and will not be regenerated.',
            'shortcode_cache_enabled' => 'Cache shortcodes (UI blocks)',
            'shortcode_cache_enabled_helper' => 'Enable caching for shortcodes to improve performance. When enabled, shortcodes will be cached to reduce rendering time.',
            'shortcode_cache_warning' => '<strong>⚠️ Important Notice:</strong><br>• Shortcodes containing forms (contact forms, newsletter subscriptions, etc.) will automatically bypass caching to preserve functionality.<br>• Shortcodes with dynamic JavaScript content should have caching disabled manually.<br>• To disable caching for specific shortcodes, add <code>Enable caching: No</code> to the shortcode configuration.<br>• Forms with CSRF tokens, reCAPTCHA, or other dynamic elements are automatically detected and excluded from caching.',
            'shortcode_cache_ttl' => 'Cache duration (seconds)',
            'shortcode_cache_ttl_helper' => 'The duration to cache all shortcodes. Default is 1800 seconds (30 minutes).',
            'widget_cache_enabled' => 'Cache widgets',
            'widget_cache_enabled_helper' => 'Enable caching for widgets to improve performance. When enabled, widgets will be cached to reduce rendering time.',
            'widget_cache_warning' => '<strong>⚠️ Important Notice:</strong><br>• Widgets containing forms (contact forms, newsletter subscriptions, etc.) will automatically bypass caching to preserve functionality.<br>• Widgets with dynamic JavaScript content should have caching disabled manually.<br>• To disable caching for specific widgets, set <code>Enable caching: No</code> in the widget configuration.<br>• Forms with CSRF tokens, reCAPTCHA, or other dynamic elements are automatically detected and excluded from caching.',
            'widget_cache_ttl' => 'Cache duration (seconds)',
            'widget_cache_ttl_helper' => 'The duration to cache all widgets. Default is 1800 seconds (30 minutes).',
            'plugin_cache_enabled' => 'Cache installed plugins',
            'plugin_cache_enabled_helper' => 'Cache the list of installed plugins for improved performance. When enabled, the system will cache the plugin list for 30 minutes to reduce file system scans.',
        ],
    ],
    'appearance' => [
        'title' => 'Apariencia',
    ],
    'panel' => [
        'common' => 'Común',
        'general' => 'General',
        'general_description' => 'Ver y actualizar tus ajustes generales y activar la licencia.',
        'email' => 'Correo electrónico',
        'email_description' => 'Ver y actualizar tus ajustes de correo electrónico y plantillas de correo electrónico.',
        'media' => 'Medios de comunicación',
        'media_description' => 'Ver y actualizar tus ajustes de medios.',
        'system' => 'Sistema',
        'system_updater' => 'Actualizador del sistema',
        'system_updater_description' => 'Actualice su sistema a la última versión',
        'others' => 'Otros',
    ],
    'saving' => 'Guardando...',
    'generating_media_thumbnails' => 'Generando miniaturas de medios...',
    'test_email_template' => 'Plantilla de correo electrónico de prueba',
    'select_email_template' => 'Seleccionar plantilla de correo electrónico',
    'enums' => [
        'data_retention_period' => [
            'Never',
            '1 Day',
            3 => '3 Days',
            7 => '1 Week',
            30 => '1 Month',
            90 => '3 Months',
            180 => '6 Months',
            365 => '1 Year',
        ],
    ],
    'validation' => [
        'aws_region_invalid' => 'The :attribute must be a valid AWS region (e.g., us-east-1, eu-west-1).',
    ],
    'website_tracking' => [],
    'phone_number' => [
        'title' => 'Número de teléfono',
        'description' => 'Configurar ajustes del campo de número de teléfono',
        'enable_country_code' => 'Habilitar selección de código de país',
        'enable_country_code_helper' => 'Cuando está habilitado, los campos de número de teléfono mostrarán un selector de código de país con detección automática del país.',
        'available_countries' => 'Países disponibles',
        'all' => 'Todos',
        'all_helper_text' => 'Seleccione todos los países para que estén disponibles en el selector de código de país del teléfono.',
        'min_length' => 'Longitud mínima',
        'min_length_helper' => 'Número mínimo de caracteres requeridos para números de teléfono.',
        'max_length' => 'Longitud máxima',
        'max_length_helper' => 'Número máximo de caracteres permitidos para números de teléfono.',        'note_content' => '<p class="mb-1"><strong>Para formato local (sin código de país):</strong> Establezca mín/máx según la longitud del número de teléfono de su país (p. ej., 8-15 para la mayoría de los países).</p><p class="mb-0"><strong>Para formato internacional (con código de país habilitado):</strong> Recomendado mín: 7, máx: 20. Esto incluye códigos de país (1-4 dígitos) + números de teléfono (normalmente 6-15 dígitos).</p>',
    ],
];
