<?php

return [
    'title' => 'Налаштування',
    'general_setting' => 'Загальні налаштування',
    'menu' => 'Усі налаштування',
    'email_setting_title' => 'Налаштування електронної пошти',
    'email_setting_description' => 'Налаштуйте параметри електронної пошти',
    'general' => [
        'theme' => 'Тема',
        'title' => 'Загальна інформація',
        'description' => 'Перегляд та оновлення інформації про сайт',
        'rich_editor' => 'Розширений редактор',
        'site_title' => 'Заголовок сайту',
        'admin_email' => 'Електронна пошта адміністратора',
        'seo_block' => 'Конфігурація SEO',
        'seo_title' => 'SEO-заголовок',
        'seo_description' => 'SEO-опис',
        'webmaster_tools_block' => 'Інструменти вебмайстра Google',
        'placeholder' => [
            'site_title' => 'Заголовок сайту (максимум 120 символів)',
            'admin_email' => 'Електронна пошта адміністратора',
            'seo_title' => 'SEO-заголовок (максимум 120 символів)',
            'seo_description' => 'SEO-опис (максимум 120 символів)',
            'google_analytics' => 'Google Analytics',
        ],
        'enable_send_error_reporting_via_email' => 'Увімкнути надсилання звітів про помилки електронною поштою?',
        'enable_send_error_reporting_via_email_helper' => 'Коли ввімкнено, детальні звіти про помилки надсилатимуться на адреси електронної пошти адміністратора при виникненні критичних помилок на сайті',
        'time_zone' => 'Часовий пояс',
        'time_zone_helper' => 'Виберіть часовий пояс для вашого веб-сайту. Це буде використовуватися для всіх відображень дати та часу в усій системі',
        'enable' => 'Увімкнути',
        'disable' => 'Вимкнути',
        'disabled_helper' => 'Цей шаблон електронної пошти не можна вимкнути!',
        'enable_cache_site_map' => 'Увімкнути кеш-карту сайту?',
        'cache_time_site_map' => 'Час кешування карти сайту (хвилини)',
        'admin_logo' => 'Логотип адміністратора',
        'admin_favicon' => 'Фавікон адміністратора',
        'admin_title' => 'Заголовок адміністратора',
        'admin_title_placeholder' => 'Заголовок, який відображається на вкладці браузера',
        'admin_appearance_title' => 'Зовнішній вигляд адміністратора',
        'admin_appearance_description' => 'Налаштування зовнішнього вигляду адміністратора, такі як редактор, мова...',
        'seo_block_description' => 'Налаштування заголовку сайту, метаопису сайту, ключових слів для оптимізації SEO',
        'webmaster_tools_description' => 'Інструменти вебмайстра Google (GWT) — безкоштовне програмне забезпечення, яке допомагає керувати технічними аспектами вашого веб-сайту',
        'yes' => 'Так',
        'no' => 'Ні',
        'show_on_front' => 'Ваш головний сторінка відображає',
        'select' => '— Вибрати —',
        'show_site_name' => 'Показувати назву сайту після заголовку сторінки, розділеного знаком "-"?',
        'locale' => 'Мова сайту',
        'locale_direction' => 'Напрямок мови сайту',
        'minutes' => 'хвилини',
        'redirect_404_to_homepage' => 'Перенаправляти всі запити, які не знайдено, на головну сторінку?',
    ],
    'admin_appearance' => [
        'title' => 'Зовнішній вигляд адміністратора',
        'description' => 'Перегляд та оновлення логотипу, фавікону, макету,...',
        'layout' => 'Макет',
        'layout_helper' => 'Choose between horizontal menu (top navigation bar) or vertical menu (side navigation bar)',
        'horizontal' => 'Горизонтальний',
        'vertical' => 'Вертикальний',
        'show_menu_item_icon' => 'Показувати іконку елемента меню?',
        'language' => 'Мова в адміністративній панелі',
        'theme_mode' => 'Режим теми',
        'dark' => 'Темний',
        'light' => 'Світлий',
        'container_width' => [
            'title' => 'Ширина контейнера',
            'title_helper' => 'Set the maximum width for content containers in the admin panel',
            'default' => 'За замовчуванням',
            'large' => 'Великий',
            'full' => 'Повний',
        ],
        'form' => [
            'admin_logo' => 'Логотип адміністратора',
            'admin_logo_helper' => 'Upload a custom logo to display in the admin panel header. Recommended size: 150x50px',
            'admin_logo_max_height' => 'Logo height (px)',
            'admin_logo_max_height_helper' => 'Set the height of the logo in pixels. The default value is :default.',
            'admin_favicon' => 'Фавікон адміністратора',
            'admin_favicon_helper' => 'Upload a favicon for the admin panel. This icon appears in browser tabs and bookmarks',
            'admin_favicon_type' => 'Admin favicon type',
            'admin_favicon_type_helper' => 'Select the image format of your favicon. ICO format is recommended for best browser compatibility',
            'admin_title' => 'Заголовок адміністратора',
            'admin_title_helper' => 'Set the title that appears in the browser tab when viewing admin pages',
            'admin_title_placeholder' => 'Заголовок, який відображається на вкладці браузера',
            'admin_login_screen_backgrounds' => 'Фони екрану входу (~1366x768)',
            'admin_login_screen_backgrounds_helper' => 'Upload one or more background images for the login screen. Images will rotate randomly. Recommended size: 1366x768px',
            'admin_locale' => 'Мова адміністратора',
            'admin_locale_helper' => 'Choose the language for the admin panel interface',
            'admin_locale_direction' => 'Напрямок мови адміністратора',
            'admin_locale_direction_helper' => 'Set text direction for the admin panel. Choose RTL for languages like Arabic or Hebrew',
            'rich_editor' => 'Розширений редактор',
            'rich_editor_helper' => 'Select the default rich text editor for content creation throughout the admin panel',
            'primary_font' => 'Основний шрифт',
            'primary_font_helper' => 'Choose the primary font family for the admin panel. This font will be used for most text',
            'primary_color' => 'Основний колір',
            'primary_color_helper' => 'Set the primary theme color used for buttons, links, and highlights. Default: #206bc4',
            'secondary_color' => 'Вторинний колір',
            'secondary_color_helper' => 'Set the secondary theme color used for less prominent UI elements. Default: #6c7a91',
            'heading_color' => 'Колір заголовку',
            'heading_color_helper' => 'Set the color for headings throughout the admin panel. Use "inherit" to use the default text color',
            'text_color' => 'Колір тексту',
            'text_color_helper' => 'Set the default text color for the admin panel. Default: #182433',
            'link_color' => 'Колір посилання',
            'link_color_helper' => 'Set the color for links in the admin panel. Default: #206bc4',
            'link_hover_color' => 'Колір посилання при наведенні',
            'link_hover_color_helper' => 'Set the color for links when hovering over them. Default: #1a569d',
            'show_menu_item_icon' => 'Показувати іконку елемента меню?',
            'show_menu_item_icon_helper' => 'Display icons next to menu items in the admin navigation for better visual recognition',
            'custom_css' => 'Користувацький CSS',
            'custom_css_helper' => 'Add custom CSS styles to override or extend the default admin panel styling',
            'custom_js' => 'Користувацький JS',
            'custom_header_js' => 'JS заголовку',
            'custom_header_js_placeholder' => 'JS у заголовку сторінки, оберніть його всередині &#x3C;script&#x3E;&#x3C;/script&#x3E;',
            'custom_body_js' => 'JS тіла',
            'custom_body_js_placeholder' => 'JS у тілі сторінки, оберніть його всередині &#x3C;script&#x3E;&#x3C;/script&#x3E;',
            'custom_footer_js' => 'JS футера',
            'custom_footer_js_placeholder' => 'JS у футері сторінки, оберніть його всередині &#x3C;script&#x3E;&#x3C;/script&#x3E;',
        ],
    ],
    'datatable' => [
        'title' => 'Таблиці даних',
        'description' => 'Налаштування для datatables',
        'form' => [
            'show_column_visibility' => 'Показувати видимість стовпця за замовчуванням?',
            'show_column_visibility_helper' => 'Enable the column visibility toggle button in data tables to allow users to show/hide columns',
            'show_export_button' => 'Показувати кнопку експорту за замовчуванням?',
            'show_export_button_helper' => 'Display export options (CSV, Excel, PDF) in data tables for downloading table data',
            'pagination_type' => 'Тип пагінації',
            'pagination_type_helper' => 'Choose how pagination controls are displayed: Default shows page numbers, Dropdown shows a compact dropdown selector',
            'default' => 'За замовчуванням',
            'dropdown' => 'Випадаюче меню',
            'enable_responsive' => 'Enable table responsive',
            'enable_responsive_helper' => 'Automatically adjust table columns to fit different screen sizes for better mobile experience',
        ],
    ],
    'email' => [
        'subject' => 'Тема',
        'content' => 'Зміст',
        'title' => 'Налаштування шаблону електронної пошти',
        'description' => 'Шаблон електронної пошти з використанням HTML та системних змінних.',
        'reset_to_default' => 'Скинути до стандартних налаштувань',
        'back' => 'Повернутися до налаштувань',
        'reset_success' => 'Успішно скинуто до стандартних налаштувань',
        'confirm_reset' => 'Підтвердити скидання шаблону електронної пошти?',
        'confirm_message' => 'Ви дійсно хочете скинути цей шаблон електронної пошти до стандартних налаштувань?',
        'continue' => 'Продовжити',
        'sender_name' => 'Ім\'я відправника',
        'sender_name_placeholder' => 'Ім\'я',
        'sender_name_helper' => 'The name that will appear in the From field of emails sent by the system',
        'sender_email' => 'Електронна пошта відправника',
        'sender_email_placeholder' => 'Email address (e.g. :default)',
        'sender_email_helper' => 'The email address that will be used as the sender for all emails sent by the system',
        'mailer' => 'Поштовий клієнт',
        'port' => 'Порт',
        'port_placeholder' => 'Наприклад: 587',
        'port_helper' => 'The port used by your mail server (common ports: 25, 465, 587)',
        'host' => 'Хост',
        'host_placeholder' => 'Наприклад: smtp.gmail.com',
        'host_helper' => 'SMTP host address',
        'username' => 'Ім\'я користувача',
        'username_placeholder' => 'Ім\'я користувача для входу на поштовий сервер',
        'username_helper' => 'Your mail server login username',
        'password' => 'Пароль',
        'password_placeholder' => 'Пароль для входу на поштовий сервер',
        'password_helper' => 'Your mail server login password',
        'encryption' => 'Шифрування',
        'encryption_placeholder' => 'Шифрування: ssl або tls',
        'encryption_helper' => 'Choose the encryption method for secure email transmission',
        'encryption_none' => 'None',
        'encryption_tls' => 'TLS',
        'encryption_ssl' => 'SSL',
        'setup_tips_title' => 'Email Setup Tips',
        'setup_tip_gmail' => 'For Gmail: Use smtp.gmail.com as host, port 587 with TLS or port 465 with SSL. Enable "Less secure app access" or use an App Password.',
        'setup_tip_port' => 'Common ports: 25 (unencrypted), 587 (TLS/STARTTLS), 465 (SSL/TLS), 2525 (alternative).',
        'setup_tip_encryption' => 'Use TLS for port 587 (recommended), SSL for port 465, or None for port 25 (not recommended for production).',
        'setup_tip_test' => 'Always use "Send Test Email" button to verify your configuration before saving.',
        'setup_tip_mailgun' => 'For better deliverability, consider using email services like Mailgun, SendGrid, or Amazon SES instead of SMTP.',
        'queue_warning_title' => 'Потрібне Налаштування Черги',
        'queue_warning_description' => 'Ваша черга електронної пошти наразі налаштована для використання драйвера ":default", але ваш воркер черги може не працювати. Це означає, що електронні листи не будуть відправлятися, доки ви не налаштуєте воркер черги.',
        'queue_warning_action' => 'Для негайного відправлення електронних листів без воркера черги, встановіть QUEUE_CONNECTION=sync у вашому файлі .env. В іншому випадку переконайтеся, що ваш воркер черги працює з "php artisan queue:work". <a href="https://laravel.com/docs/12.x/queues" target="_blank" rel="noopener">Дізнайтеся більше про Laravel Queues</a>.',
        'mail_gun_domain' => 'Домен',
        'mail_gun_domain_placeholder' => 'Домен',
        'mail_gun_domain_helper' => 'The domain name you registered with Mailgun',
        'mail_gun_secret' => 'Секрет',
        'mail_gun_secret_placeholder' => 'Секрет',
        'mail_gun_secret_helper' => 'Your Mailgun API key',
        'mail_gun_endpoint' => 'Кінцева точка',
        'mail_gun_endpoint_placeholder' => 'Кінцева точка',
        'mail_gun_endpoint_helper' => 'Mailgun API endpoint (api.mailgun.net for US, api.eu.mailgun.net for EU)',
        'log_channel' => 'Канал журналу',
        'log_channel_helper' => 'Select which logging channel to use for email logs',
        'sendmail_path' => 'Шлях Sendmail',
        'local_domain' => 'Локальний домен',
        'local_domain_placeholder' => 'Може бути порожнім. Потрібно встановити на ваш домен при використанні SMTP Relay. Наприклад: your-domain.com',
        'local_domain_helper' => 'The domain that will be used to identify the server when communicating with remote SMTP servers',
        'ses_key' => 'Ключ',
        'ses_key_placeholder' => 'Ключ',
        'ses_key_helper' => 'Your AWS access key ID',
        'ses_secret' => 'Секрет',
        'ses_secret_placeholder' => 'Секрет',
        'ses_secret_helper' => 'Your AWS secret access key',
        'ses_region' => 'Регіон',
        'ses_region_placeholder' => 'Регіон',
        'ses_region_helper' => 'The AWS region where your SES service is configured',
        'postmark_token' => 'Токен',
        'postmark_token_placeholder' => 'Токен',
        'postmark_token_helper' => 'Your Postmark server token',
        'resend_key' => 'API Key',
        'resend_key_placeholder' => 'Ex: re_123456789012345678901234567890',
        'resend_key_helper' => 'Your Resend API key',
        'email_templates' => 'Шаблони електронної пошти',
        'email_templates_description' => 'Шаблони електронної пошти з використанням HTML та системних змінних.',
        'email_template_settings' => 'Налаштування шаблону електронної пошти',
        'email_template_settings_description' => 'Перегляд та оновлення налаштувань шаблонів електронної пошти',
        'email_rules' => 'Правила електронної пошти',
        'email_rules_description' => 'Налаштуйте правила електронної пошти для валідації',
        'base_template' => 'Базовий шаблон',
        'base_template_description' => 'Базовий шаблон для всіх електронних листів',
        'template_header' => 'Заголовок шаблону електронної пошти',
        'template_header_description' => 'Шаблон для заголовка електронних листів',
        'template_footer' => 'Футер шаблону електронної пошти',
        'template_footer_description' => 'Шаблон для футера електронних листів',
        'default' => 'За замовчуванням',
        'template_off_status_helper' => 'Цей шаблон електронної пошти вимкнено.',
        'blacklist_email_domains' => 'Заблоковані домени електронної пошти',
        'blacklist_email_domains_helper' => 'Введіть список доменів електронної пошти, які будуть заблоковані. Наприклад: gmail.com, yahoo.com.',
        'blacklist_specified_emails' => 'Заблоковані адреси електронної пошти',
        'blacklist_specified_emails_helper' => 'Введіть список конкретних адрес електронної пошти, які будуть заблоковані. Наприклад: mail@example.com.',
        'exception_emails' => 'Електронні листи-виключення',
        'exception_emails_helper' => 'Ці електронні листи будуть виключені з правил валідації.',
        'email_rules_strict' => 'Строга валідація електронної пошти',
        'email_rules_strict_helper' => 'Виконуйте валідацію електронної пошти подібну до RFC з суворими правилами.',
        'email_rules_dns' => 'Валідація перевірки DNS',
        'email_rules_dns_helper' => 'Перевірте, чи є DNS-записи, які вказують на те, що сервер приймає електронні листи.',
        'email_rules_spoof' => 'Виявлення підробки',
        'email_rules_spoof_helper' => 'Виявляйте можливі спроби підробки електронної пошти.',
        'template_turn_off' => 'Натисніть, щоб вимкнути цей шаблон електронної пошти',
        'template_turn_on' => 'Натисніть, щоб увімкнути цей шаблон електронної пошти',
        'turn_on_success_message' => 'Шаблон електронної пошти успішно увімкнено!',
        'turn_off_success_message' => 'Шаблон електронної пошти успішно вимкнено!',
        'email_template_status' => 'Статус шаблону електронної пошти',
        'email_template_status_description' => 'Увімкнути/вимкнути шаблон електронної пошти',
        'email_template_logo' => 'Логотип',
        'email_template_logo_helper_text' => 'Якщо не встановлено, він буде взятий з логотипу адміністратора в Адміністратор -> Налаштування -> Зовнішній вигляд адміністратора -> Логотип.',
        'email_template_copyright_text_helper_text' => 'Якщо не встановлено, він буде взятий з опцій теми авторського права в Адміністратор -> Зовнішній вигляд -> Опції теми -> Загальне -> Авторське право.',
        'email_template_email_contact' => 'Контактна адреса електронної пошти',
        'email_template_email_contact_helper_text' => 'Якщо не встановлено, він буде взятий з електронної пошти відправника в Адміністратор -> Налаштування -> Електронна пошта',
        'email_template_social_links' => 'Посилання на соціальні мережі',
        'email_template_copyright_text' => 'Авторське право',
        'image_upload_supported' => 'Підтримуються лише формати PNG, JPG, JPEG та GIF.',
        'email_template_custom_css' => 'Користувацький CSS шаблону електронної пошти',
        'social_links' => [
            'name' => 'Назва',
            'icon' => 'Іконка',
            'icon_image' => 'Зображення іконки (Підтримуються лише формати PNG, JPG, JPEG та GIF.)',
            'url' => 'URL',
            'image' => 'Зображення',
        ],
        'logo_height' => 'Logo height (px)',
        'logo_height_helper' => 'Set the height of the logo in pixels. The default value is :default.',
    ],
    'license_title' => 'Ліцензія',
    'setup_license' => 'Setup license code',
    'close' => 'Close',
    'media' => [
        'title' => 'Медіа',
        'driver' => 'Драйвер',
        'description' => 'Налаштування для медіа',
        'local_disk' => 'Local disk',
        'aws_access_key_id' => 'ID ключа доступу AWS',
        'aws_secret_key' => 'Секретний ключ AWS',
        'aws_default_region' => 'Регіон за замовчуванням AWS',
        'aws_bucket' => 'Кошик AWS',
        'aws_url' => 'URL AWS',
        'aws_endpoint' => 'Кінцева точка AWS (Необов\'язково)',
        'use_path_style_endpoint' => 'Використовувати кінцеву точку стилю шляху?',
        'r2_access_key_id' => 'ID ключа доступу R2',
        'r2_secret_key' => 'Секретний ключ R2',
        'r2_bucket' => 'Кошик R2',
        'r2_url' => 'URL R2',
        'r2_endpoint' => 'Кінцева точка R2',
        'do_spaces_access_key_id' => 'ID ключа доступу DO Spaces',
        'do_spaces_secret_key' => 'Секретний ключ DO Spaces',
        'do_spaces_default_region' => 'Регіон за замовчуванням DO Spaces',
        'do_spaces_bucket' => 'Кошик DO Spaces',
        'do_spaces_endpoint' => 'Кінцева точка DO Spaces',
        'do_spaces_cdn_enabled' => 'Чи увімкнено CDN DO Spaces?',
        'do_spaces_cdn_enabled_helper' => 'Якщо ввімкнено, медіафайли обслуговуватимуться через CDN DigitalOcean Spaces для швидшої глобальної доставки вмісту. Нижче ви можете додатково налаштувати власний домен CDN.',
        'media_do_spaces_cdn_custom_domain' => 'Користувацький домен CDN DO Spaces',
        'media_do_spaces_cdn_custom_domain_placeholder' => 'https://your-custom-domain.com',
        'wasabi_access_key_id' => 'ID ключа доступу Wasabi',
        'wasabi_secret_key' => 'Секретний ключ Wasabi',
        'wasabi_default_region' => 'Регіон за замовчуванням Wasabi',
        'wasabi_bucket' => 'Кошик Wasabi',
        'wasabi_root' => 'Корінь Wasabi',
        'wasabi_root_helper' => 'Щоб повторно використовувати існуючі зображення, просто призначте корінь Wasabi як "/", а потім завантажте всі поточні файли з public/storage у корінцеву директорію Wasabi.',
        'backblaze_access_key_id' => 'ID ключа доступу Backblaze',
        'backblaze_secret_key' => 'Секретний ключ Backblaze',
        'backblaze_bucket' => 'Backblaze Bucket',
        'backblaze_default_region' => 'Регіон за замовчуванням Backblaze',
        'backblaze_url' => 'URL-адреса Backblaze',
        'backblaze_endpoint' => 'Кінцева точка Backblaze',
        'backblaze_cdn_enabled' => 'Чи ввімкнено Backblaze CDN?',
        'backblaze_cdn_enabled_helper' => 'Якщо ввімкнено, медіафайли обслуговуватимуться через CDN для швидшої глобальної доставки вмісту. Ви повинні налаштувати спеціальний домен CDN нижче (наприклад, Cloudflare CDN або Backblaze CDN).',
        'media_backblaze_cdn_custom_domain' => 'Спеціальний домен Backblaze CDN',
        'media_backblaze_cdn_custom_domain_placeholder' => 'https://your-custom-domain.com',
        'default_placeholder_image' => 'Зображення за замовчуванням',
        'enable_chunk' => 'Увімкнути завантаження за частинами?',
        'chunk_size' => 'Розмір частини (Байти)',
        'chunk_size_placeholder' => 'За замовчуванням: 1048576 ~ 1МБ',
        'max_file_size' => 'Максимальний розмір файлу частини (МБ)',
        'max_file_size_placeholder' => 'За замовчуванням: 1048576 ~ 1ГБ',
        'enable_watermark' => 'Увімкнути водяний знак?',
        'enable_watermark_helper' => 'Якщо ввімкнено, водяний знак буде автоматично додано до щойно завантажених зображень у вибраних папках. Це не впливає на наявні зображення.',
        'watermark_source' => 'Зображення водяного знака',
        'watermark_source_helper' => 'Supports only PNG, JPG, and JPEG formats. You should use image less than 200x200px and size smaller than 50KB.',
        'watermark_size' => 'Розмір водяного знака (%)',
        'watermark_size_placeholder' => 'За замовчуванням: 10 (%)',
        'watermark_opacity' => 'Прозорість водяного знака (%)',
        'watermark_opacity_placeholder' => 'За замовчуванням: 70 (%)',
        'watermark_position' => 'Позиція водяного знака',
        'watermark_position_x' => 'Позиція X водяного знака',
        'watermark_position_y' => 'Позиція Y водяного знака',
        'watermark_position_top_left' => 'Зверху ліворуч',
        'watermark_position_top_right' => 'Зверху праворуч',
        'watermark_position_bottom_left' => 'Знизу ліворуч',
        'watermark_position_bottom_right' => 'Знизу праворуч',
        'watermark_position_center' => 'Центр',
        'turn_off_automatic_url_translation_into_latin' => 'Вимкнути автоматичний переклад URL на латиницю',
        'turn_off_automatic_url_translation_into_latin_helper' => 'Якщо ввімкнено, URL-адреси файлів не будуть автоматично транслітеровані латинськими символами, зберігаючи оригінальні символи з нелатинських алфавітів.',
        'bunnycdn_hostname' => 'Ім\'я хоста',
        'bunnycdn_zone' => 'Назва зони (Назва вашої зони зберігання)',
        'bunnycdn_key' => 'Пароль доступу через FTP та API (Пароль доступу до зони зберігання)',
        'bunnycdn_region' => 'Регіон (Регіон зони зберігання)',
        'optional' => 'Необов\'язково',
        'sizes' => 'Розміри медіа-мініатюр',
        'media_sizes_helper' => 'Встановіть ширину або висоту на 0, якщо ви хочете обрізати лише за шириною або висотою.',
        'width' => 'Ширина',
        'height' => 'Висота',
        'default_size_value' => 'За замовчуванням: :size',
        'all' => 'Усі',
        'all_helper_text' => 'Якщо ви знімаєте всі папки, це буде застосовано до всіх папок.',
        'media_folders_can_add_watermark' => 'Додати водяний знак до зображень у папках:',
        'max_upload_filesize' => 'Максимальний розмір файлу для завантаження (МБ)',
        'max_upload_filesize_placeholder' => 'За замовчуванням: :size, має бути менше ніж :size.',
        'max_upload_filesize_helper' => 'Ваш сервер дозволяє завантажувати файли максимум :size, ви можете змінити це значення, щоб обмежити розмір файлу для завантаження.',
        'image_processing_library' => 'Бібліотека обробки зображень',
        'use_original_name_for_file_path' => 'Використовувати оригінальну назву для шляху до файлу',
        'use_original_name_for_file_path_helper' => 'Якщо ввімкнено, завантажені файли збережуть свої оригінальні назви. Якщо вимкнено, назви файлів буде перетворено на зручні URL-слаги (наприклад, «My Photo.jpg» стане «my-photo.jpg»).',
        'keep_original_file_size_and_quality' => 'Зберігайте оригінальний розмір і якість файлу',
        'keep_original_file_size_and_quality_helper' => 'Якщо ввімкнено, розмір завантажених зображень не буде змінено чи оптимізовано, зберігаючи їх оригінальну якість і розмір файлу. Якщо вимкнено, зображення можуть стискатися та змінюватися відповідно до ваших налаштувань.',
        'update_thumbnail_sizes_warning' => 'Після налаштування розмірів мініатюр потрібно натиснути кнопку ":button_text", щоб оновити їх.',
        'thumbnail_crop_position' => 'Позиція кадрування мініатюри',
        'thumbnail_crop_position_left' => 'Ліворуч',
        'thumbnail_crop_position_center' => 'центр',
        'thumbnail_crop_position_right' => 'правильно',
        'thumbnail_crop_position_top' => 'Топ',
        'thumbnail_crop_position_bottom' => 'Дно',
        'thumbnail_crop_position_helper' => 'Цей параметр використовується для обрізання зображення під час створення мініатюр. Воно буде обрізано з цієї позиції, доки зображення не буде заповнене.',
        'user_can_only_view_own_media' => 'Користувачі можуть переглядати лише власні медіафайли',
        'user_can_only_view_own_media_helper' => 'Якщо ввімкнено, користувачі можуть переглядати лише власні медіафайли, тоді як суперадміністратори можуть переглядати всі медіафайли.',
        'enable_thumbnail_sizes' => 'Enable thumbnail sizes',
        'enable_thumbnail_sizes_helper' => 'Enable this option to generate thumbnails for images. If it is disabled, the system will not generate thumbnails for images and always use full size image.',
        'convert_image_to_webp' => 'Convert JPG, JPEG, PNG image to WebP',
        'convert_image_to_webp_helper' => 'WebP is a modern image format that provides superior lossless and lossy compression for images on the web. It is supported in Chrome, Firefox, Edge, and Opera. Image will be converted to WebP format when uploading. It is just applied for JPG, JPEG, PNG images.',
        'reduce_large_image_size' => 'Reduce large image size when uploading',
        'reduce_large_image_size_helper' => 'When enabled, the system will reduce the size of large images when uploading, applied for JPG, JPEG, PNG, WebP image. The maximum width and height of the image will be resized to the values you set below.',
        'image_max_width' => 'Image max width (px)',
        'image_max_height' => 'Image max height (px)',
        'image_max_width_placeholder' => 'Leave blank to keep original width',
        'image_max_height_placeholder' => 'Leave blank to keep original height',
        'image_max_width_helper' => 'Set the maximum width of the image in pixels. The original width will be kept if this field is empty.',
        'image_max_height_helper' => 'Set the maximum height of the image in pixels. The original height will be kept if this field is empty.',
        'customize_upload_path' => 'Customize upload path',
        'customize_upload_path_helper' => 'Customize the upload path for media files. By default, the system will upload files to the ":path" folder.',
        'upload_path' => 'Upload path',
        'upload_path_placeholder' => 'Example: uploads',
        'upload_path_helper' => 'That folder will be created in /public. The default folder is ":folder". Then it will be uploaded into "/public/:folder".',
        'upload_path_warning' => 'The system won\'t move existing files to the new folder. If you want to move existing files to the new folder, you need to do it manually.',
        'convert_file_name_to_uuid' => 'Convert file name to UUID',
        'convert_file_name_to_uuid_helper' => 'When enabled, the system will convert the file name to UUID when uploading. It is useful to prevent duplicate file names and better security.',
        's3_path' => 'Custom S3 Path (Optional)',
        's3_path_placeholder' => 'Optional custom path in S3 bucket (e.g., uploads/media)',
    ],
    'field_type_not_exists' => 'This field type does not exist',
    'save_settings' => 'Зберегти налаштування',
    'template' => 'Шаблон',
    'description' => 'Опис',
    'enable' => 'Увімкнути',
    'send' => 'Надіслати',
    'test_email_description' => 'Щоб надіслати тестовий електронний лист, переконайтеся, що ви оновили конфігурацію для надсилання пошти!',
    'test_email_input_placeholder' => 'Введіть електронну адресу, на яку ви хочете надіслати тестовий електронний лист.',
    'test_email_modal_title' => 'Надіслати тестовий електронний лист',
    'test_send_mail' => 'Надіслати тестовий лист',
    'test_email_send_success' => 'Електронний лист успішно надіслано!',
    'locale_direction_ltr' => 'Зліва направо',
    'locale_direction_rtl' => 'Справа наліво',
    'emails_warning' => 'Ви можете додати максимум :count електронних листів',
    'email_add_more' => 'Додати більше',
    'generate' => 'Генерувати',
    'generate_thumbnails' => 'Генерувати мініатюри',
    'generate_thumbnails_success' => 'Мініатюри успішно згенеровані. :count файлів згенеровано!',
    'generate_thumbnails_error' => 'Нам не вдалося відновити мініатюри для цих файлів :count файлів!',
    'generate_thumbnails_description' => 'Ви впевнені, що хочете повторно згенерувати мініатюри для всіх зображень? Це займе час, тому, будь ласка, НЕ залишайте цю сторінку, дочекайтеся завершення.',
    'enable_chunk_description' => 'Завантаження за частинами використовується для завантаження великих файлів.',
    'watermark_description' => 'ПОПЕРЕДЖЕННЯ: Водяний знак додається лише до нових завантажених зображень, він не буде доданий до існуючих зображень. Вимкнення водяного знака не видалить водяний знак з існуючих зображень.',
    'submit' => 'Відправити',
    'back' => 'Назад',
    'enter_sample_value' => 'Введіть зразкові значення для тестування',
    'preview' => 'Попередній перегляд',
    'media_size_width' => 'Ширина розміру :size має бути більше 0',
    'media_size_height' => 'Висота розміру :size має бути більше 0',
    'security' => [
        'title' => 'Налаштування безпеки',
        'description' => 'Перевірте та налаштуйте параметри безпеки для вашого сайту.',
        'menu_description' => 'Керування безпекою cookie та HTTP-заголовками',
        'status_secure' => 'Усі налаштування безпеки правильно налаштовані!',
        'status_insecure' => 'Деякі налаштування безпеки потребують уваги!',
        'current_settings' => 'Поточні налаштування безпеки',
        'status' => 'Статус',
        'setting' => 'Налаштування',
        'current_value' => 'Поточне значення',
        'recommended_value' => 'Рекомендовано',
        'session_http_only' => 'Прапор HttpOnly Cookie',
        'session_http_only_description' => 'Запобігає доступу JavaScript до сесійних cookie (захист від XSS-атак)',
        'session_secure_cookie' => 'Прапор Secure Cookie',
        'session_secure_cookie_description' => 'Гарантує відправку cookie лише через HTTPS-з\'єднання',
        'session_same_site' => 'Прапор SameSite Cookie',
        'session_same_site_description' => 'Запобігає CSRF-атакам, обмежуючи відправку cookie',
        'http_security_headers' => 'Заголовки безпеки HTTP',
        'http_security_headers_description' => 'Додає заголовки безпеки для захисту від поширених веб-вразливостей',
        'https_warning' => 'Ваш сайт не використовує HTTPS',
        'https_warning_description' => 'Деякі функції безпеки, такі як захищені cookie, вимагають HTTPS. Розгляньте можливість увімкнення SSL для вашого сайту.',
        'how_to_fix' => 'Як виправити проблеми безпеки',
        'env_file_location' => 'Відредагуйте файл .env, розташований за адресою:',
        'add_to_env' => 'Налаштування для додавання',
        'required_settings' => 'Обов\'язкові налаштування безпеки',
        'for_https_sites' => 'Лише для сайтів HTTPS',
        'copy' => 'Копіювати',
        'copy_settings' => 'Копіювати всі налаштування',
        'copied' => 'Скопійовано!',
        'steps' => 'Кроки для застосування налаштувань',
        'step_1' => 'Відкрийте файл .env у текстовому редакторі',
        'step_2' => 'Додайте або оновіть налаштування безпеки, показані вище',
        'step_3' => 'Збережіть файл .env',
        'step_4' => 'Очистіть кеш через Панель адміністратора → Управління платформою → Управління кешем',
        'security_headers_info' => 'Інформація про заголовки безпеки',
        'security_headers_list' => 'При увімкненні до всіх відповідей додаються наступні заголовки:',
        'header_nosniff' => 'Запобігає вгадуванню типів вмісту браузерами',
        'header_frame' => 'Захищає від clickjacking-атак',
        'header_xss' => 'Вмикає захист XSS браузера',
        'header_referrer' => 'Контролює обсяг реферальної інформації, що відправляється',
        'learn_more' => 'Для отримання більш детальної інформації див. :documentation',
        'documentation' => 'документацію з безпеки',
    ],
    'cache' => [
        'title' => 'Кеш',
        'description' => 'Налаштування кешу для системи для оптимізації швидкості',
        'form' => [
            'cache_admin_menu' => 'Кешувати меню адміністратора?',
            'cache_admin_menu_helper' => 'Cache admin menu for optimized speed. This option should be disabled if you are developing or customizing the admin menu.',
            'enable_cache_site_map' => 'Увімкнути кеш-карту сайту?',
            'enable_cache_site_map_helper' => 'Sitemap :url should be cached due to the large number of pages. If you have a small number of pages, you can disable this option.',
            'cache_time_site_map' => 'Час кешування карти сайту (хвилини)',
            'cache_front_menu' => 'Cache front menu',
            'cache_front_menu_helper' => 'Cache front menu for optimized speed',
            'cache_user_avatar' => 'Cache user avatar',
            'cache_user_avatar_helper' => 'For users without avatar, the system will generate avatars from their usernames. The avatars will be cached for optimized speed and will not be regenerated.',
            'shortcode_cache_enabled' => 'Cache shortcodes (UI blocks)',
            'shortcode_cache_enabled_helper' => 'Enable caching for shortcodes to improve performance. When enabled, shortcodes will be cached to reduce rendering time.',
            'shortcode_cache_warning' => '<strong>⚠️ Important Notice:</strong><br>• Shortcodes containing forms (contact forms, newsletter subscriptions, etc.) will automatically bypass caching to preserve functionality.<br>• Shortcodes with dynamic JavaScript content should have caching disabled manually.<br>• To disable caching for specific shortcodes, add <code>Enable caching: No</code> to the shortcode configuration.<br>• Forms with CSRF tokens, reCAPTCHA, or other dynamic elements are automatically detected and excluded from caching.',
            'shortcode_cache_ttl' => 'Cache duration (seconds)',
            'shortcode_cache_ttl_helper' => 'The duration to cache all shortcodes. Default is 1800 seconds (30 minutes).',
            'widget_cache_enabled' => 'Cache widgets',
            'widget_cache_enabled_helper' => 'Enable caching for widgets to improve performance. When enabled, widgets will be cached to reduce rendering time.',
            'widget_cache_warning' => '<strong>⚠️ Important Notice:</strong><br>• Widgets containing forms (contact forms, newsletter subscriptions, etc.) will automatically bypass caching to preserve functionality.<br>• Widgets with dynamic JavaScript content should have caching disabled manually.<br>• To disable caching for specific widgets, set <code>Enable caching: No</code> in the widget configuration.<br>• Forms with CSRF tokens, reCAPTCHA, or other dynamic elements are automatically detected and excluded from caching.',
            'widget_cache_ttl' => 'Cache duration (seconds)',
            'widget_cache_ttl_helper' => 'The duration to cache all widgets. Default is 1800 seconds (30 minutes).',
            'plugin_cache_enabled' => 'Cache installed plugins',
            'plugin_cache_enabled_helper' => 'Cache the list of installed plugins for improved performance. When enabled, the system will cache the plugin list for 30 minutes to reduce file system scans.',
        ],
    ],
    'appearance' => [
        'title' => 'Зовнішній вигляд',
    ],
    'panel' => [
        'common' => 'Загальні',
        'general' => 'Загальні',
        'general_description' => 'Перегляд та оновлення загальних налаштувань та активація ліцензії',
        'email' => 'Електронна пошта',
        'email_description' => 'Перегляд та оновлення налаштувань електронної пошти та шаблонів електронної пошти',
        'media' => 'Медіа',
        'media_description' => 'Перегляд та оновлення налаштувань медіа',
        'system' => 'Система',
        'system_updater' => 'Оновлювач системи',
        'system_updater_description' => 'Оновіть свою систему до останньої версії',
        'others' => 'Інші',
    ],
    'saving' => 'Збереження...',
    'generating_media_thumbnails' => 'Генерування мініатюр медіа...',
    'test_email_template' => 'Тестовий шаблон електронної пошти',
    'select_email_template' => 'Виберіть шаблон електронної пошти',
    'enums' => [
        'data_retention_period' => [
            'Never',
            '1 Day',
            3 => '3 Days',
            7 => '1 Week',
            30 => '1 Month',
            90 => '3 Months',
            180 => '6 Months',
            365 => '1 Рік',
        ],
    ],
    'validation' => [
        'aws_region_invalid' => 'The :attribute must be a valid AWS region (e.g., us-east-1, eu-west-1).',
    ],
    'website_tracking' => [],
    'phone_number' => [
        'title' => 'Phone Number',
        'description' => 'Configure phone number field settings',
        'enable_country_code' => 'Enable Country Code Selection',
        'enable_country_code_helper' => 'When enabled, phone number fields will display a country code selector with automatic country detection.',
        'available_countries' => 'Available Countries',
        'all' => 'All',
        'all_helper_text' => 'Select all countries to be available in the phone country code selector.',
        'min_length' => 'Minimum Length',
        'min_length_helper' => 'Minimum number of characters required for phone numbers.',
        'max_length' => 'Maximum Length',
        'max_length_helper' => 'Maximum number of characters allowed for phone numbers.',        'note_content' => '<p class="mb-1"><strong>Для локального формату (без коду країни):</strong> Встановіть мін/макс на основі довжини телефонного номера вашої країни (наприклад, 8-15 для більшості країн).</p><p class="mb-0"><strong>Для міжнародного формату (з увімкненим кодом країни):</strong> Рекомендовано мін: 7, макс: 20. Це включає коди країн (1-4 цифри) + телефонні номери (зазвичай 6-15 цифр).</p>',
    ],
];
