<?php

return [
    'save_settings' => 'Salva impostazioni',
    'ecommerce' => 'Ecommerce',
    'general' => [
        'name' => 'Generale',
        'description' => 'Nome negozio, info azienda, contatti e email notifiche amministratore',
    ],
    'currency' => [
        'name' => 'Valute',
        'description' => 'Formati valuta, tassi di cambio, rilevamento automatico e separatori decimali/migliaia',
        'currency_setting_description' => 'Visualizza e aggiorna le valute utilizzate nel sito web',
        'form' => [
            'enable_auto_detect_visitor_currency' => 'Abilita rilevamento automatico valuta visitatore',
            'enable_auto_detect_visitor_currency_helper' => 'Rileva automaticamente e mostra i prezzi nella valuta locale del visitatore in base alla sua posizione. Questo offre un\'esperienza di acquisto più personalizzata.',
            'add_space_between_price_and_currency' => 'Aggiungi uno spazio tra prezzo e valuta',
            'add_space_between_price_and_currency_helper' => 'Quando abilitato, aggiunge uno spazio tra il valore del prezzo e il simbolo della valuta (ad es., \"100 USD\" invece di \"100USD\").',
            'thousands_separator' => 'Separatore migliaia',
            'thousands_separator_helper' => 'Scegli il carattere per separare le migliaia nella visualizzazione del prezzo (ad es., 1.000 o 1,000 o 1 000).',
            'decimal_separator' => 'Separatore decimali',
            'decimal_separator_helper' => 'Scegli il carattere per separare i valori decimali nei prezzi (ad es., 10,99 o 10.99).',
            'separator_period' => 'Punto (.)',
            'separator_comma' => 'Virgola (,)',
            'separator_space' => 'Spazio ( )',
            'api_key' => 'Chiave API tassi di cambio',
            'api_key_helper' => 'Ottieni la chiave API per i tassi di cambio su :link',
            'update_currency_rates' => 'Aggiorna tassi di cambio',
            'use_exchange_rate_from_api' => 'Usa tasso di cambio da API',
            'use_exchange_rate_from_api_helper' => 'Abilita gli aggiornamenti automatici dei tassi di cambio valuta dal provider API configurato. Questo garantisce che i tuoi prezzi siano sempre aggiornati con i tassi di mercato correnti.',
            'clear_cache_rates' => 'Cancella cache tassi',
            'auto_detect_visitor_currency_description' => 'Rileva la valuta del visitatore basata sulla lingua del browser. Sovrascriverà la selezione valuta predefinita.',
            'exchange_rate' => [
                'api_provider' => 'Fornitore API',
                'select' => '-- Seleziona --',
                'none' => 'Nessuno',
                'provider' => [
                    'api_layer' => 'API Layer',
                    'open_exchange_rate' => 'Open Exchange Rates',
                ],
                'open_exchange_app_id' => 'Open Exchange Rates App ID',
            ],
            'default_currency_warning' => 'Per la valuta predefinita, il tasso di cambio deve essere 1.',
        ],
    ],
    'product' => [
        'name' => 'Prodotti',
        'description' => 'Visualizzazione stock, generazione SKU, immagini varianti, prodotti correlati e specifiche',
        'product_settings' => 'Impostazioni prodotto',
        'product_settings_description' => 'Configura regole per i prodotti',
        'form' => [
            'show_number_of_products' => 'Mostra numero di prodotti nella pagina singola prodotto',
            'show_number_of_products_helper' => 'Visualizza il numero totale di prodotti nella pagina dettaglio prodotto.',
            'show_out_of_stock_products' => 'Mostra prodotti esauriti',
            'show_out_of_stock_products_helper' => 'Se abilitato, i prodotti esauriti verranno visualizzati nella pagina elenco prodotti.',
            'how_to_display_product_variation_images' => 'Come visualizzare le immagini delle variazioni prodotto',
            'how_to_display_product_variation_images_helper' => 'Scegli se mostrare solo immagini specifiche della variazione o includere sia immagini della variazione che del prodotto principale.',
            'only_variation_images' => 'Solo immagini variazione',
            'variation_images_and_main_product_images' => 'Immagini variazione e immagini prodotto principale',
            'enable_product_options' => 'Abilita opzioni prodotto',
            'enable_product_options_helper' => 'Permetti ai prodotti di avere opzioni personalizzabili come taglia, colore, ecc.',
            'is_enabled_cross_sale_products' => 'Abilita prodotti cross-sale',
            'is_enabled_cross_sale_products_helper' => 'Visualizza suggerimenti prodotti cross-sale per incoraggiare acquisti aggiuntivi.',
            'is_enabled_related_products' => 'Abilita prodotti correlati',
            'is_enabled_related_products_helper' => 'Mostra prodotti correlati basati sulla categoria, o selezionati dall\'admin nel form prodotto.',
            'related_products_source' => 'Fonte prodotti correlati',
            'related_products_source_helper' => 'Quando l\'admin non seleziona prodotti correlati nel form prodotto, mostra prodotti correlati basati su questa fonte.',
            'related_products_source_category' => 'Stessa categoria',
            'related_products_source_brand' => 'Stesso marchio',
            'trending_products_period' => 'Periodo prodotti di tendenza',
            'trending_products_period_helper' => 'Seleziona il periodo di tempo da considerare per calcolare i prodotti di tendenza basati sul conteggio visualizzazioni.',
            'trending_products_period_1_day' => 'Ultime 24 ore',
            'trending_products_period_3_days' => 'Ultimi 3 giorni',
            'trending_products_period_7_days' => 'Ultimi 7 giorni (1 settimana)',
            'trending_products_period_14_days' => 'Ultimi 14 giorni (2 settimane)',
            'trending_products_period_30_days' => 'Ultimi 30 giorni (1 mese)',
            'trending_products_period_60_days' => 'Ultimi 60 giorni (2 mesi)',
            'trending_products_period_90_days' => 'Ultimi 90 giorni (3 mesi)',
            'auto_generate_product_sku' => 'Genera automaticamente SKU quando si crea un prodotto',
            'auto_generate_product_sku_helper' => 'Genera automaticamente SKU unici per nuovi prodotti basati sul formato sottostante.',
            'product_sku_format' => 'Formato SKU',
            'product_sku_format_helper' => 'Puoi usare %s (1 carattere stringa) o %d (1 cifra) nel formato per generare stringhe casuali. Es: SKU-%s%s%s-HN-%d%d%d',
            'enable_product_specification' => 'Abilita specifiche prodotto',
            'enable_product_specification_help' => 'Se abilitato, la tabella specifiche prodotto verrà visualizzata nella pagina dettaglio prodotto.',
            'make_product_barcode_required' => 'Rendi obbligatorio il codice a barre prodotto',
            'make_product_barcode_required_helper' => 'Se abilitato, il codice a barre prodotto sarà obbligatorio quando si crea un prodotto.',
        ],
    ],
    'product_search' => [
        'name' => 'Ricerca Prodotti',
        'description' => 'Comportamento di ricerca, filtri per categoria/marca/tag/attributi e filtro fascia di prezzo',
        'product_search_settings' => 'Ricerca prodotti',
        'product_search_settings_description' => 'Configura regole per la ricerca prodotti',
        'form' => [
            'search_for_an_exact_phrase' => 'Cerca per una frase esatta',
            'search_products_by' => 'Cerca prodotti per:',
            'enable_filter_products_by_categories' => 'Abilita filtro prodotti per categorie',
            'enable_filter_products_by_brands' => 'Abilita filtro prodotti per marchi',
            'enable_filter_products_by_tags' => 'Abilita filtro prodotti per tag',
            'number_of_popular_tags_for_filter' => 'Numero di tag popolari per filtro',
            'number_of_popular_tags_for_filter_placeholder' => 'Inserisci numero di tag popolari da visualizzare',
            'number_of_popular_tags_for_filter_helper' => 'Imposta il numero massimo di tag popolari da visualizzare nel filtro. Predefinito è 10.',
            'enable_filter_products_by_attributes' => 'Abilita filtro prodotti per attributi',
            'enable_filter_products_by_price' => 'Abilita filtro prodotti per prezzo',
            'max_product_price_for_filter' => 'Prezzo massimo prodotto per filtro',
            'max_product_price_for_filter_placeholder' => 'Se è vuoto o zero, otterrà il prezzo massimo prodotto dai tuoi prodotti esistenti.',
            'max_product_price_for_filter_helper' => 'Puoi impostare un prezzo fisso per questo o otterrà dinamicamente il prezzo massimo prodotto dai tuoi prodotti esistenti. Attualmente è :price.',
        ],
    ],
    'digital_product' => [
        'name' => 'Prodotti Digitali',
        'description' => 'Prodotti scaricabili, codici licenza, checkout ospite per prodotti digitali e completamento automatico',
        'digital_products_settings' => 'Prodotti digitali',
        'digital_products_settings_description' => 'Configura regole per i prodotti digitali',
        'form' => [
            'enable_support_digital_product' => 'È abilitato il supporto per prodotti digitali',
            'enable_support_digital_product_helper' => 'Quando abilitato, il sistema supporterà la vendita di prodotti digitali come software, ebook, musica e altri contenuti scaricabili.',
            'allow_guest_checkout_for_digital_products' => 'Permetti checkout ospite per prodotti digitali',
            'allow_guest_checkout_for_digital_products_helper' => 'Quando abilitato, i clienti possono acquistare prodotti digitali senza creare un account. Riceveranno link di download via email.',
            'disable_physical_product' => 'Disabilita prodotto fisico',
            'disable_physical_product_helper' => 'Quando abilitato, il negozio venderà solo prodotti digitali. Le opzioni prodotto fisico saranno nascoste dai form prodotto e checkout.',
            'enable_license_codes_for_digital_products' => 'Abilita codici licenza per prodotti digitali',
            'auto_complete_digital_orders_after_payment' => 'Completa automaticamente ordini digitali dopo il pagamento',
            'auto_complete_digital_orders_after_payment_helper' => 'Quando abilitato, gli ordini contenenti solo prodotti digitali saranno automaticamente segnati come completati una volta ricevuto il pagamento.',
            'enable_license_codes_for_digital_products_helper' => 'Quando abilitato, puoi aggiungere codici licenza ai prodotti digitali. Quando disabilitato, la funzionalità codici licenza sarà nascosta dai form prodotto.',
            'hide_used_license_codes_in_product_form' => 'Nascondi codici licenza usati nel form prodotto',
            'hide_used_license_codes_in_product_form_helper' => 'Quando abilitato, i codici licenza usati saranno nascosti dalla tabella codici licenza nel form modifica prodotto. Questo aiuta a mantenere l\'interfaccia pulita quando hai molti codici usati.',
        ],
    ],
    'product_review' => [
        'name' => 'Recensioni Prodotti',
        'description' => 'Recensioni clienti, visualizzazione valutazioni, caricamento immagini e requisiti di approvazione',
        'form' => [
            'enable_review' => 'Abilita recensioni prodotti',
            'enable_review_help' => 'Permetti ai clienti di lasciare recensioni e valutazioni sui prodotti. Quando disabilitato, tutte le funzioni di recensione saranno nascoste dal negozio.',
            'allow_customer_upload_image_in_review' => 'Permetti ai clienti di caricare immagini nelle recensioni',
            'allow_customer_upload_image_in_review_help' => 'Quando disabilitato, i clienti non possono caricare immagini quando inviano recensioni',
            'review' => [
                'max_file_size' => 'Dimensione massima file recensione (MB)',
                'max_file_number' => 'Numero massimo file recensione',
            ],
            'only_allow_customers_purchased_to_review' => 'Solo i clienti che hanno acquistato il prodotto possono recensire il prodotto',
            'review_need_to_be_approved' => 'Le recensioni devono essere approvate prima di essere mostrate nella pagina prodotto',
            'show_customer_full_name' => 'Mostra nome completo cliente',
            'show_customer_full_name_help' => 'Se non è selezionato, il nome del cliente che recensisce sarà nascosto e sostituito con asterischi (***)',
            'hide_rating_when_no_reviews' => 'Nascondi valutazione quando non ci sono recensioni',
            'hide_rating_when_no_reviews_help' => 'Quando abilitato, le valutazioni prodotto saranno nascoste negli elenchi prodotti e nelle pagine dettaglio prodotto quando il prodotto non ha recensioni',
            'display_uploaded_customer_review_images_list' => 'Visualizza sezione "Immagini dai clienti"',
            'display_uploaded_customer_review_images_list_help' => 'Quando abilitato, mostra una galleria di tutte le immagini caricate dai clienti in cima alla sezione recensioni',
        ],
    ],
    'shopping' => [
        'name' => 'Shopping',
        'description' => 'Carrello, lista desideri, confronto, tracciamento ordini, pulsante acquisto rapido e upload prova pagamento',
        'general_setting' => 'Impostazioni generali',
        'return_settings' => 'Impostazioni reso',
        'return_settings_description' => 'Configura regole per le impostazioni reso',
        'form' => [
            'enable_cart' => 'Abilita carrello della spesa',
            'enable_cart_helper' => 'Se disabilitato, il pulsante carrello sarà rimosso, trasformando il tuo sito in una visualizzazione solo catalogo.',
            'enable_wishlist' => 'Abilita lista desideri',
            'enable_wishlist_helper' => 'Se disabilitato, il pulsante lista desideri sarà rimosso dal sito.',
            'enable_wishlist_sharing' => 'Abilita condivisione lista desideri',
            'shared_wishlist_lifetime' => 'Durata lista desideri condivisa (giorni)',
            'shared_wishlist_lifetime_helper' => 'La durata della lista desideri condivisa in giorni. Dopo questo tempo, la lista desideri condivisa sarà eliminata.',
            'enable_compare' => 'Abilita confronto',
            'enable_compare_helper' => 'Se disabilitato, il pulsante confronto sarà rimosso dal sito.',
            'enable_order_tracking' => 'Abilita tracking ordine',
            'enable_order_tracking_helper' => 'I clienti possono tracciare i loro ordini inserendo il codice ordine e email/telefono su :url',
            'order_tracking_method' => 'Metodo tracking ordine',
            'order_tracking_method_helper' => 'Scegli come i clienti tracceranno i loro ordini: usando ID Ordine + Email o ID Ordine + Numero di telefono.',
            'order_tracking_method_email' => 'ID Ordine + Email',
            'order_tracking_method_phone' => 'ID Ordine + Numero di telefono',
            'enable_quick_buy_button' => 'Abilita pulsante acquisto rapido',
            'enable_quick_buy_button_helper' => 'Mostrerà un pulsante Compra Ora nella pagina elenco e dettaglio prodotto. Quando i clienti cliccano su questo pulsante, il prodotto sarà aggiunto al carrello e reindirizzato alla pagina carrello/checkout.',
            'enable_order_auto_confirmed' => 'Conferma automatica ordine',
            'enable_order_auto_confirmed_helper' => 'Se abilitato, l\'ordine sarà automaticamente confermato dopo che il cliente effettua un ordine.',
            'quick_buy_target' => 'Pagina target acquisto rapido',
            'checkout_page' => 'Pagina checkout',
            'cart_page' => 'Pagina carrello',
            'cart_destroy_on_logout' => 'Distruggi carrello al logout',
            'cart_destroy_on_logout_helper' => 'Il carrello sarà distrutto quando il cliente si disconnette.',
            'hide_product_price' => 'Nascondi prezzo prodotto',
            'hide_product_price_helper' => 'Questa opzione funziona solo se disabiliti il carrello della spesa, trasformando il tuo sito in una visualizzazione solo catalogo. Se abilitato, il prezzo prodotto sarà nascosto. È utile quando vuoi nascondere il prezzo e richiedere ai clienti di contattarti per il prezzo.',
            'hide_product_price_when_zero' => 'Nascondi prezzo prodotto quando è zero',
            'hide_product_price_when_zero_helper' => 'Se abilitato, i prodotti con prezzo 0 non mostreranno un prezzo sullo store.',
            'enable_payment_proof' => 'Abilita caricamento prova pagamento',
            'enable_payment_proof_helper' => 'Permetti ai clienti di caricare la prova di pagamento per i loro ordini. Questo è utile per metodi di pagamento manuali.',
            'enable_guest_payment_proof' => 'Permetti ai clienti ospiti di caricare prova pagamento',
            'enable_guest_payment_proof_helper' => 'Quando abilitato, i clienti ospiti possono caricare la prova di pagamento usando il loro token ordine senza effettuare l\'accesso. Riceveranno il link di caricamento nella loro email di conferma ordine.',
            'payment_proof_payment_methods' => 'Metodi di pagamento che richiedono la prova di pagamento',
            'payment_proof_payment_methods_helper' => 'Seleziona quali metodi di pagamento devono consentire ai clienti di caricare la prova di pagamento. Tipicamente utilizzato per metodi di pagamento manuali come contrassegno e bonifico bancario.',
        ],
    ],
    'checkout' => [
        'name' => 'Checkout',
        'panel_description' => 'Checkout ospite, campi obbligatori, limiti ordine, accettazione termini e restrizioni paese',
        'description' => 'Configura regole per le impostazioni checkout',
        'form' => [
            'display_bank_info_at_the_checkout_success_page' => 'Visualizza info banca nella pagina successo checkout',
            'mandatory_form_fields_at_checkout' => 'Campi obbligatori nella pagina checkout:',
            'mandatory_form_fields_at_checkout_helper' => 'Seleziona quali campi sono obbligatori durante il checkout. I clienti devono compilare questi campi per completare il loro ordine.',
            'hide_form_fields_at_checkout' => 'Nascondi campi cliente nella pagina checkout:',
            'hide_form_fields_at_checkout_helper' => 'Seleziona quali campi dovrebbero essere nascosti nella pagina checkout. Questi campi non saranno visibili ai clienti.',
            'load_countries_states_cities_from_location_plugin' => 'Carica paesi, stati, città dal plugin posizione',
            'load_countries_states_cities_from_location_plugin_placeholder' => 'Dopo aver cambiato questa opzione, devi aggiornare di nuovo tutti gli indirizzi. Dovresti impostarla una volta.',
            'load_countries_states_cities_from_location_plugin_placeholder_2' => 'Poi devi andare su Strumenti -> Importa/Esporta Dati per importare i dati posizione.',
            'minimum_order_amount' => 'Importo minimo ordine per effettuare un ordine (:currency).',
            'minimum_order_amount_helper' => 'Imposta l\'importo totale minimo richiesto per un ordine da elaborare. Gli ordini sotto questo importo non saranno accettati.',
            'zip_code_enabled' => 'Abilita codice postale',
            'zip_code_enabled_helper' => 'Abilita o disabilita il campo codice postale/CAP nel form indirizzo di spedizione.',
            'billing_address_enabled' => 'Abilita indirizzo fatturazione',
            'billing_address_enabled_helper' => 'Permetti ai clienti di inserire un indirizzo di fatturazione separato che differisce dal loro indirizzo di spedizione.',
            'display_tax_fields_at_checkout_page' => 'Visualizza campi informazioni fiscali nella pagina checkout',
            'display_tax_fields_at_checkout_page_helper' => 'Se abilitato, i campi informazioni fiscali saranno visualizzati per inserire i dettagli fiscali aziendali per ricevere una fattura.',
            'use_city_field_as_field_text' => 'Usa campo città come campo di testo libero',
            'available_countries' => 'Paesi disponibili',
            'all' => 'Tutti',
            'all_helper_text' => 'Se deselezioni tutti i paesi, si applicherà a tutti i paesi.',
            'enable_guest_checkout' => 'Abilita checkout ospite',
            'enable_guest_checkout_helper' => 'Se abilitato, i clienti possono effettuare un ordine senza creare un account.',
            'recently_viewed' => [
                'enable' => 'Abilita prodotti visualizzati di recente dal cliente',
                'enable_helper' => 'Traccia e visualizza i prodotti che i clienti hanno visualizzato di recente. Questo aiuta i clienti a trovare facilmente i prodotti a cui erano interessati.',
                'max' => 'Numero massimo di prodotti visualizzati di recente dal cliente',
                'max_helper_text' => 'Se impostato a 0, non ci sarà limite.',
            ],
            'minimum_order_quantity' => 'Quantità minima ordine',
            'minimum_order_quantity_helper' => 'Quantità minima per effettuare un ordine. Lascialo a 0 se non vuoi impostarlo.',
            'maximum_order_quantity' => 'Quantità massima ordine',
            'maximum_order_quantity_helper' => 'Quantità massima per effettuare un ordine. Lascialo a 0 se non vuoi impostarlo.',
            'default_country_at_checkout_page' => 'Paese predefinito nella pagina checkout',
            'default_country_at_checkout_page_placeholder' => 'Seleziona un paese',
            'default_country_at_checkout_page_help' => 'Se selezioni un paese, il paese sarà selezionato per impostazione predefinita nella pagina checkout.',
            'checkout_product_quantity_editable' => 'Permetti ai clienti di cambiare la quantità prodotto nella pagina checkout',
            'checkout_product_quantity_editable_helper' => 'Quando abilitato, i clienti possono modificare la quantità dei prodotti direttamente nella pagina checkout senza tornare al carrello.',
            'show_terms_and_policy_checkbox' => 'Mostra checkbox termini e politiche',
            'show_terms_and_policy_checkbox_helper' => 'Se abilitato, i clienti devono accettare i termini e le politiche prima di effettuare un ordine. Configura prima l\'URL Termini e Privacy Policy in Aspetto -> Opzioni tema.',
            'terms_and_policy_checkbox_checked_by_default' => 'Checkbox termini e politiche selezionato per impostazione predefinita',
            'terms_and_policy_checkbox_checked_by_default_helper' => 'Se abilitato, il checkbox termini e politiche sarà pre-selezionato quando il form checkout si carica.',
            'checkout_acceptance_message_enabled' => 'Mostra messaggio accettazione checkout',
            'checkout_acceptance_message_enabled_helper' => 'Visualizza un messaggio informativo che informa i clienti sui termini che stanno accettando effettuando un ordine.',
            'hide_customer_info_at_checkout' => 'Nascondi info cliente al checkout',
            'hide_customer_info_at_checkout_helper' => 'Nascondi le informazioni account cliente e il pulsante logout dalla pagina checkout. Quando abilitato, i clienti connessi non vedranno i dettagli del loro account visualizzati.',
        ],
    ],
    'return' => [
        'name' => 'Reso',
        'description' => 'Configura regole per le impostazioni reso',
        'panel_description' => 'Resi ordini, resi parziali e limiti di tempo per i resi',
        'form' => [
            'is_enabled_order_return' => 'È abilitato il reso ordine',
            'allow_partial_return' => 'Permetti reso parziale',
            'allow_partial_return_description' => 'Il cliente può restituire alcuni prodotti, non ha bisogno di restituire tutti i prodotti in un ordine.',
            'returnable_days' => 'Giorni di reso',
            'return_settings_helper' => 'Numero di giorni in cui un cliente può richiedere un reso dopo che l\'ordine è completato.',
        ],
    ],
    'invoice' => [
        'name' => 'Fatture',
        'description' => 'Dettagli azienda su fatture, numerazione fatture, font PDF e impostazioni timbro',
        'company_settings' => 'Impostazioni azienda',
        'company_settings_description' => 'Impostazioni informazioni Azienda per la fatturazione',
        'form' => [
            'company_name' => 'Nome azienda',
            'company_name_helper' => 'Il nome della tua azienda o attività che apparirà su tutte le fatture inviate ai clienti.',
            'company_name_placeholder' => 'Acme S.p.A.',
            'company_address' => 'Indirizzo azienda',
            'company_address_helper' => 'L\'indirizzo completo della tua azienda inclusi via, città, provincia e paese. Questo apparirà sulle fatture.',
            'company_address_placeholder' => 'Via Roma 123, Suite 100, 00100 Roma, Italia',
            'company_zipcode' => 'Codice postale azienda',
            'company_zipcode_helper' => 'Codice postale per l\'indirizzo della tua azienda.',
            'company_zipcode_placeholder' => '00100',
            'company_email' => 'Email azienda',
            'company_email_helper' => 'Indirizzo e-mail per richieste commerciali. I clienti possono usarlo per domande relative alle fatture.',
            'company_email_placeholder' => 'fatturazione@azienda.it',
            'company_phone' => 'Telefono azienda',
            'company_phone_helper' => 'Numero di telefono di contatto che verrà visualizzato sulle fatture per il supporto clienti.',
            'company_phone_placeholder' => '+39 06 12345678',
            'company_logo' => 'Logo azienda',
            'company_logo_helper' => 'Il logo della tua azienda che verrà visualizzato in cima alle fatture. Dimensioni consigliate: 200x60 pixel.',
            'company_tax_id' => 'Codice fiscale azienda',
            'company_tax_id_helper' => 'Il tuo numero di identificazione fiscale aziendale (P.IVA, Codice Fiscale, ecc.) per la conformità fiscale.',
            'company_tax_id_placeholder' => 'P.IVA: IT12345678901',
            'invoice_code_prefix' => 'Prefisso codice fattura',
            'invoice_code_prefix_helper' => 'Prefisso aggiunto prima dei numeri di fattura (es. \"FATT-\" creerà codici fattura come FATT-001, FATT-002).',
            'invoice_code_prefix_placeholder' => 'FATT-',
            'using_custom_font_for_invoice' => 'Usa font personalizzato per fattura',
            'using_custom_font_for_invoice_helper' => 'Abilita per utilizzare un font Google personalizzato per i PDF delle fatture invece del font predefinito.',
            'invoice_font_family' => 'Famiglia font fattura (Funziona solo per lingue latine)',
            'invoice_font_family_helper' => 'Seleziona un font Google da utilizzare nei PDF delle fatture. Funziona solo con set di caratteri latini.',
            'enable_invoice_stamp' => 'Abilita timbro fattura',
            'enable_invoice_stamp_helper' => 'Aggiungi un timbro \"PAGATO\" alle fatture quando il pagamento dell\'ordine è completato.',
            'add_language_support' => 'Aggiungi supporto lingua',
            'add_language_support_helper' => 'Scegli il supporto aggiuntivo del set di caratteri per le lingue non latine nei PDF delle fatture.',
            'invoice_processing_library' => 'Libreria elaborazione fattura',
            'invoice_processing_library_helper' => 'Scegli la libreria di generazione PDF. DomPDF è più veloce ma ha funzionalità limitate. mPDF supporta più lingue e funzionalità ma può essere più lento.',
            'only_latin_languages' => 'Solo lingue latine',
            'disable_order_invoice_until_order_confirmed' => 'Disabilita fattura ordine finché l\'ordine non è confermato',
            'disable_order_invoice_until_order_confirmed_helper' => 'Quando abilitato, le fatture saranno disponibili solo dopo la conferma degli ordini, non immediatamente dopo l\'inserimento.',
            'date_format' => 'Formato data',
            'date_format_helper' => 'Scegli come verranno visualizzate le date sulle fatture (es. \"F d, Y\" mostra \"Gennaio 01, 2024\").',
            'languages' => [
                'arabic' => 'Arabo',
                'bangladesh' => 'Bengali',
                'chinese' => 'Cinese',
            ],
        ],
    ],
    'tax' => [
        'name' => 'Tassa',
        'description' => 'Impostazioni tasse',
        'enable' => 'Abilita tasse?',
        'display_product_price_including_taxes' => 'Visualizza prezzo prodotto incluse le tasse?',
        'display_tax_description' => 'Visualizza informazioni tasse sul prezzo prodotto?',
        'display_tax_description_help' => 'Mostra testo come "(Incluso X% IVA)" o "(Escluso X% IVA)" accanto ai prezzi prodotto nella pagina dettaglio prodotto.',
        'tax_included_in_products_price' => 'Tasse incluse nel prezzo prodotti',
        'tax_included_in_products_price_description' => 'Le tasse saranno incluse nel prezzo prodotti',
        'tax_setting' => 'Impostazioni tasse',
        'tax_setting_description' => 'Configura impostazioni tasse',
        'tax_management' => 'Gestione tasse',
        'tax_management_description' => 'Visualizza e gestisci le tue tasse',
        'form' => [
            'enable_tax' => 'Abilita tasse',
            'display_company_invoice_information_fields_at_checkout_page' => 'Visualizza campi informazioni fattura azienda nella pagina checkout',
            'display_company_invoice_information_fields_at_checkout_page_helper' => 'Se è abilitato, i campi informazioni fattura azienda saranno visualizzati nella pagina checkout. È obbligatorio compilare i campi informazioni fattura azienda.',
            'default_tax_rate' => 'Aliquota fiscale predefinita',
            'default_tax_rate_description' => 'Importante: sarà applicata se nessuna tassa è selezionata nel prodotto.',
            'select_tax' => '-- Seleziona --',
            'display_product_price_including_taxes' => 'Aggiungi tasse ai prezzi visualizzati',
            'display_product_price_including_taxes_helper' => 'Aggiunge automaticamente le tasse ai prezzi dei prodotti nel negozio. Es. un prodotto da $100 con il 10% di tasse viene visualizzato come $110. Non necessario se "Il prezzo include le tasse" è già abilitato sui singoli prodotti.',
            'display_checkout_tax_information' => 'Display tax information under each item at checkout',
            'display_checkout_tax_information_helper' => 'Show the tax breakdown text (e.g., "VAT 10%") next to each item on the checkout page.',
        ],
    ],
    'customer' => [
        'name' => 'Clienti',
        'description' => 'Registrazione, verifica email, opzioni di login, eliminazione account e campi profilo',
        'customer_setting' => 'Impostazioni cliente',
        'customer_setting_description' => 'Configura impostazioni cliente',
        'form' => [
            'enable_customer_registration' => 'Abilita registrazione cliente',
            'enable_customer_registration_helper' => 'Se disabilitato, i clienti non potranno registrare nuovi account. I clienti esistenti possono ancora accedere.',
            'verify_customer_email' => 'Verifica email del cliente',
            'verify_customer_email_helper' => "Quando è abilitato, un link di verifica sarà inviato all'email del cliente, i clienti devono cliccare su questo link per verificare la loro email prima di poter accedere. È necessario configurare l'email in Admin -> Impostazioni -> Email per inviare la verifica email.",
            'verification_expire_minutes' => 'Tempo di scadenza link verifica',
            'verification_expire_minutes_helper' => 'Il tempo in minuti in cui il link di verifica email sarà valido. Predefinito è 60 minuti (1 ora). Massimo è 10080 minuti (7 giorni).',
            'login_using_phone' => 'Accedi con numero di telefono invece che email',
            'login_option' => 'Opzione login',
            'login_with_email' => 'Login con email',
            'login_with_phone' => 'Login con telefono',
            'login_with_email_or_phone' => 'Login con email o telefono',
            'enabled_customer_account_deletion' => 'Abilita eliminazione account cliente',
            'enabled_customer_account_deletion_helper' => 'Quando è abilitato, i clienti possono eliminare il loro account nella dashboard cliente → Impostazioni account.',
            'enabled_customer_dob_field' => 'Abilita campo data di nascita cliente',
            'enabled_customer_dob_field_helper' => 'Quando è abilitato, i clienti possono inserire la loro data di nascita nella dashboard cliente → Impostazioni account.',
            'enabled_phone_field_in_registration_form' => 'Abilita campo telefono nel form registrazione',
            'enabled_phone_field_in_registration_form_helper' => 'Quando è abilitato, il campo telefono sarà aggiunto al form registrazione.',
            'make_customer_phone_number_required' => 'Rendi obbligatorio il numero di telefono cliente',
            'make_customer_phone_number_required_helper' => 'Quando abilitato, i clienti devono inserire il loro numero di telefono durante la registrazione. È sempre obbligatorio per i clienti che accedono con un numero di telefono.',
            'default_avatar' => 'Avatar predefinito',
            'default_avatar_helper' => 'Avatar predefinito per il cliente quando non hanno un avatar. Se non selezioni nessuna immagine, sarà generato usando il tuo logo o il primo carattere del nome cliente.',
            'keep_email_field_in_registration_form' => 'Mantieni campo email nel form registrazione',
            'keep_email_field_in_registration_form_helper' => 'Quando è disabilitato, il campo email sarà nascosto nel form registrazione quando l\'opzione login è "Login con telefono".',
        ],
    ],
    'shipping' => [
        'name' => 'Spedizione',
        'description' => 'Regole di spedizione, comportamento spedizione gratuita e ordine visualizzazione opzioni spedizione',
        'shipping_rule' => 'Regole spedizione',
        'shipping_rule_description' => 'Configura regole per calcolare la tariffa di spedizione',
        'shipping_setting' => 'Impostazioni spedizione',
        'shipping_setting_description' => 'Configura impostazioni spedizione',
        'form' => [
            'hide_other_shipping_options_if_it_has_free_shipping' => 'Nascondi altre opzioni di spedizione se ha spedizione gratuita nella lista',
            'disable_shipping_options' => 'Disabilita opzioni di spedizione',
            'disable_shipping_options_helper' => 'Le opzioni di spedizione saranno rimosse nella pagina checkout, il cliente non potrà selezionare opzioni di spedizione.',
            'sort_shipping_options_direction' => 'Direzione ordinamento opzioni spedizione',
            'sort_shipping_options_direction_helper' => 'Ordina opzioni spedizione per prezzo dal più basso al più alto o dal più alto al più basso.',
            'price_lower_to_higher' => 'Prezzo dal più basso al più alto',
            'price_higher_to_lower' => 'Prezzo dal più alto al più basso',
        ],
    ],
    'webhook' => [
        'name' => 'Webhook',
        'description' => 'Configura impostazioni webhook',
        'webhook_setting' => 'Webhook',
        'webhook_setting_description' => 'Configura URL webhook per ricevere notifiche per vari eventi ordine',
        'form' => [
            'order_placed_webhook_url' => 'URL webhook ordine effettuato (metodo: POST)',
            'order_placed_webhook_url_placeholder' => 'https://...',
            'order_placed_webhook_url_helper' => 'Per ricevere notifiche quando un ordine è effettuato, puoi configurare un URL webhook esterno. Se hai un URL webhook esterno, puoi inserire questo URL, o lasciarlo vuoto.',
            'order_updated_webhook_url' => 'URL webhook ordine aggiornato (metodo: POST)',
            'order_updated_webhook_url_placeholder' => 'https://...',
            'order_updated_webhook_url_helper' => 'Per ricevere notifiche quando un ordine è aggiornato, puoi configurare un URL webhook esterno. Questo include cambi di stato, aggiornamenti indirizzo e altre modifiche ordine.',
            'shipping_status_updated_webhook_url' => 'URL webhook stato spedizione aggiornato (metodo: POST)',
            'shipping_status_updated_webhook_url_placeholder' => 'https://...',
            'shipping_status_updated_webhook_url_helper' => 'Per ricevere notifiche quando lo stato spedizione cambia (es. spedito, consegnato, annullato), puoi configurare un URL webhook esterno.',
            'order_completed_webhook_url' => 'URL webhook ordine completato (metodo: POST)',
            'order_completed_webhook_url_placeholder' => 'https://...',
            'order_completed_webhook_url_helper' => 'Per ricevere notifiche quando un ordine è completato, puoi configurare un URL webhook esterno.',
            'order_cancelled_webhook_url' => 'URL webhook ordine annullato (metodo: POST)',
            'order_cancelled_webhook_url_placeholder' => 'https://...',
            'order_cancelled_webhook_url_helper' => 'Per ricevere notifiche quando un ordine è annullato, puoi configurare un URL webhook esterno.',
            'payment_status_updated_webhook_url' => 'URL webhook stato pagamento aggiornato (metodo: POST)',
            'payment_status_updated_webhook_url_placeholder' => 'https://...',
            'payment_status_updated_webhook_url_helper' => 'Per ricevere notifiche quando lo stato pagamento cambia (es. pagato, fallito, rimborsato), puoi configurare un URL webhook esterno.',
            'abandoned_cart_webhook_url' => 'URL webhook carrello abbandonato (metodo: POST)',
            'abandoned_cart_webhook_url_placeholder' => 'https://...',
            'abandoned_cart_webhook_url_helper' => 'Per ricevere notifiche quando i carrelli sono abbandonati e fare follow-up con i clienti, puoi configurare un URL webhook esterno. Le notifiche sono inviate dopo un periodo di tempo configurabile.',
        ],
        'test_button' => 'Testa Webhook',
        'test_success' => 'Test webhook riuscito! L\'endpoint ha risposto correttamente.',
        'test_failed' => 'Test webhook fallito. L\'endpoint non ha risposto come previsto.',
        'test_error' => 'Errore test webhook: :error',
        'please_enter_url' => 'Inserisci prima un URL webhook',
        'testing' => 'Test in corso...',
        'test_failed_title' => 'Test Fallito!',
        'test_success_title' => 'Test Riuscito!',
        'status_code' => 'Codice di Stato',
        'error_occurred' => 'Si è verificato un errore durante il test del webhook',
    ],
    'store_locator' => [
        'name' => 'Localizzatori negozi',
        'description' => 'Visualizza e aggiorna gli elenchi delle tue catene',
        'store_locator_description' => 'Tutti gli elenchi delle tue catene, negozi principali, filiali, ecc. Le posizioni possono essere utilizzate per tracciare le vendite e per aiutarci a configurare le aliquote fiscali da applicare quando si vendono prodotti.',
        'form' => [
            'change_primary_store' => 'cambia localizzatore negozio predefinito',
            'add_location' => 'Aggiungi posizione',
            'edit_location' => 'Modifica posizione',
            'delete_location' => 'Elimina posizione',
            'delete_location_confirmation' => 'Sei sicuro di voler eliminare questa posizione? Questa azione non può essere annullata.',
            'change_primary_location' => 'Cambia posizione principale',
            'save_location' => 'Salva posizione',
            'add_new' => 'Aggiungi nuovo',
        ],
        'info' => [
            'title' => 'Come funzionano i localizzatori negozi',
            'primary_store' => 'L\'indirizzo del negozio principale appare sulle fatture ed è utilizzato come indirizzo di reso predefinito per le etichette di spedizione.',
            'shipping_location' => 'I negozi contrassegnati come "punto di spedizione" possono essere selezionati come magazzino di origine durante la creazione delle spedizioni.',
            'shipment_selection' => 'Durante l\'elaborazione degli ordini, puoi scegliere da quale magazzino spedire in base all\'inventario e alla posizione del cliente.',
        ],
    ],
    'tracking' => [
        'name' => 'Tracking',
        'description' => 'Facebook Pixel, eventi Google Tag Manager e tracciamento conversioni Google Ads',
        'manage_tracking' => 'Gestisci tracking',
        'manage_tracking_description' => 'Gestisci tracking: UTM, Facebook, Google Tag Manager...',
        'form' => [
            'enable_facebook_pixel' => 'Abilita Facebook Pixel (Meta Pixel)',
            'facebook_pixel_helper' => 'Vai su https://developers.facebook.com/docs/meta-pixel per creare Facebook Pixel. Assicurati che il tuo pixel sia attivo e configurato correttamente.',
            'facebook_pixel_id' => 'ID Facebook Pixel',
            'facebook_pixel_id_placeholder' => 'Esempio: 1234567890123456',
            'facebook_pixel_debug_mode' => 'Abilita Modalità Debug Facebook Pixel',
            'facebook_pixel_debug_mode_helper' => 'Abilita modalità debug per registrare eventi Facebook Pixel nella console del browser e risolvere problemi di tracking',
            'enable_google_tag_manager_tracking_events' => 'Abilita Eventi Tracking Google Tag Manager',
            'google_tag_manager_tracking_info' => 'Quando abilitato, gli eventi e-commerce saranno tracciati tramite Google Tag Manager. Assicurati di aver configurato Google Tag Manager sopra.',
        ],
        'validation' => [
            'facebook_pixel_id_format' => 'L\'ID Facebook Pixel deve essere di 15-16 cifre (es. 1234567890123456)',
        ],
    ],
    'marketplace' => [
        'name' => 'Marketplace',
        'description' => 'Impostazioni multi-venditore, commissioni, registrazione venditori e configurazione pagamenti',
    ],
    'standard_and_format' => [
        'name' => 'Standard e Formato',
        'panel_description' => 'Formato codice ordine, unità di peso (kg/lb) e unità di dimensione (cm/pollici)',
        'description' => 'Standard e formati sono utilizzati per calcolare cose come prezzi prodotti, pesi spedizione e tempi ordine.',
        'form' => [
            'change_order_format' => 'Modifica formato codice ordine (opzionale)',
            'change_order_format_description' => 'Il codice ordine predefinito inizia con: numero. Puoi cambiare la stringa iniziale o finale per creare il codice ordine che vuoi, ad esempio "DH-: numero" o ": numero-A"',
            'start_with' => 'Inizia con',
            'end_with' => 'Finisce con',
            'order_will_be_shown' => 'Il tuo codice ordine sarà mostrato',
            'weight_unit' => 'Unità di peso',
            'height_unit' => 'Unità lunghezza / altezza',
            'weight_unit_gram' => 'Grammo (g)',
            'weight_unit_kilogram' => 'Chilogrammo (kg)',
            'weight_unit_lb' => 'Libbra (lb)',
            'weight_unit_oz' => 'Oncia (oz)',
            'height_unit_cm' => 'Centimetro (cm)',
            'height_unit_m' => 'Metro (m)',
            'height_unit_inch' => 'Pollice',
        ],
    ],
    'sale_popup' => [
        'name' => 'Popup Vendita',
        'description' => 'Personalizza le impostazioni del tuo popup vendita con facilità',
    ],
    'flash_sale' => [
        'name' => 'Vendita Flash',
        'description' => 'Configura le impostazioni vendita flash per offrire sconti promozionali a tempo limitato',
        'enable' => 'Abilita funzionalità vendita flash',
        'enable_helper' => 'Quando abilitato, puoi creare e gestire vendite flash con prezzi scontati speciali per un periodo di tempo limitato.',
        'show_sale_count_left' => 'Visualizza tracker inventario',
        'show_sale_count_left_description' => 'Mostra una barra di progresso con "X venduti su Y" per creare urgenza e incoraggiare acquisti rapidi durante le vendite flash.',
    ],
    'payment_method_cod_minimum_amount' => 'Importo minimo ordine - :currency (Opzionale)',
    'payment_method_cod_minimum_amount_helper' => 'Set the minimum order amount required to use COD payment method. Leave it as 0 or empty if you don\'t want to set a minimum.',
    'payment_method_cod_maximum_amount' => 'Maximum order amount - :currency (Optional)',
    'payment_method_cod_maximum_amount_helper' => 'Set the maximum order amount allowed for COD payment method. Leave it as 0 or empty if you don\'t want to set a maximum.',
    'payment_method_minimum_amount' => 'Importo minimo ordine - :currency (Opzionale)',
    'payment_method_minimum_amount_helper' => 'Set the minimum order amount required to use this payment method. Leave it as 0 or empty if you don\'t want to set a minimum.',
    'payment_method_maximum_amount' => 'Maximum order amount - :currency (Optional)',
    'payment_method_maximum_amount_helper' => 'Set the maximum order amount allowed for this payment method. Leave it as 0 or empty if you don\'t want to set a maximum.',
    'payment_method_maximum_amount_error' => 'Maximum order amount to use :payment_method payment method is :amount, you need to remove :more to place an order!',
    'display_bank_info_at_the_checkout_success_page' => 'Visualizza info banca nella pagina successo checkout?',
    'invoice_templates' => 'Template fatture',

    'abandoned_cart' => [
        'name' => 'Carrelli Abbandonati',
        'description' => 'Recupera le vendite perse inviando promemoria automatici ai clienti che hanno lasciato articoli nel carrello',
        'panel_description' => 'Configura promemoria automatici per i clienti che abbandonano il carrello',
        'how_it_works' => [
            'title' => 'Come Funziona',
            'step1_title' => 'Il cliente aggiunge articoli',
            'step1_description' => 'Il cliente aggiunge prodotti al carrello e fornisce la sua email.',
            'step2_title' => 'Il carrello diventa abbandonato',
            'step2_description' => 'Se non viene effettuato alcun acquisto entro il tempo stabilito, il carrello viene contrassegnato come abbandonato.',
            'step3_title' => 'Email di promemoria inviata',
            'step3_description' => 'Vengono inviate email di promemoria automatiche per incoraggiare il cliente a completare l\'acquisto.',
            'step4_title' => 'Vendita recuperata',
            'step4_description' => 'Il cliente torna per completare l\'ordine e il carrello viene contrassegnato come recuperato.',
        ],
        'form' => [
            'enable' => 'Abilita tracciamento carrelli abbandonati',
            'enable_helper' => 'Quando abilitato, il sistema traccerà i carrelli abbandonati e ti permetterà di inviare email di recupero ai clienti.',
            'timing_section' => 'Impostazioni Tempo',
            'email_section' => 'Impostazioni Email Promemoria',
            'cleanup_section' => 'Pulizia Dati',
            'time_threshold' => 'Soglia tempo (ore)',
            'time_threshold_helper' => 'Un carrello è considerato abbandonato dopo queste ore di inattività. Consigliato: 1-24 ore.',
            'send_email' => 'Invia email di recupero',
            'send_email_helper' => 'Invia automaticamente email di recupero ai clienti con carrelli abbandonati.',
            'max_reminders' => 'Numero di email promemoria',
            'max_reminders_helper' => 'Quante email promemoria inviare per carrello abbandonato. Ogni email può essere personalizzata nei Modelli Email.',
            'email_delay' => 'Invia dopo (ore)',
            'email_discount' => 'Sconto (%)',
            'email_1_title' => 'Email #1 - Promemoria Amichevole',
            'email_1_description' => 'Primo promemoria gentile per incoraggiare il cliente a tornare.',
            'email_1_delay_helper' => 'Ore dopo l\'abbandono del carrello per inviare la prima email. Consigliato: 1-2 ore.',
            'email_2_title' => 'Email #2 - Con Incentivo',
            'email_2_description' => 'Secondo promemoria con offerta sconto per motivare l\'acquisto.',
            'email_2_delay_helper' => 'Ore dopo l\'abbandono del carrello per inviare la seconda email. Consigliato: 24 ore.',
            'email_2_discount_helper' => 'Percentuale sconto da offrire in questa email. Imposta 0 per nessuno sconto.',
            'email_3_title' => 'Email #3 - Ultima Occasione',
            'email_3_description' => 'Promemoria finale con urgenza e migliore offerta per chiudere la vendita.',
            'email_3_delay_helper' => 'Ore dopo l\'abbandono del carrello per inviare l\'ultima email. Consigliato: 72 ore.',
            'email_3_discount_helper' => 'Offerta sconto finale. Solitamente superiore all\'email #2.',
            'cleanup_days' => 'Pulizia dopo (giorni)',
            'cleanup_days_helper' => 'Elimina automaticamente i record dei carrelli abbandonati più vecchi di questo numero di giorni.',
            'cronjob_not_setup' => '<strong>Cronjob non configurato!</strong> I promemoria per i carrelli abbandonati richiedono un cronjob configurato correttamente. <a href=":url">Configura cronjob ora</a>.',
            'cronjob_not_running' => '<strong>Cronjob non in esecuzione!</strong> Il cronjob sembra essersi fermato. Controlla la configurazione del server. <a href=":url">Visualizza stato cronjob</a>.',
            'cronjob_working' => '<strong>Cronjob funzionante!</strong> Ultima attività: :time. I tuoi promemoria per i carrelli abbandonati verranno elaborati automaticamente.',
            'email_setup_warning' => '<strong>Importante:</strong> Assicurati che le impostazioni email siano configurate correttamente in <a href=":url">Impostazioni → Email</a>. Invia un\'email di test per verificare che tutto funzioni prima di abilitare questa funzione.',
        ],
    ],
];
