<?php

return [
    'name' => 'Produtos',
    'description' => 'Visualizar e atualizar as configurações dos seus produtos',
    'create' => 'Novo produto',
    'create_product_type' => [
        'physical' => 'Novo produto físico',
        'digital' => 'Novo produto digital',
    ],
    'edit' => 'Editar produto - :name',
    'form' => [
        'name' => 'Nome',
        'name_placeholder' => 'Nome do produto (Máximo 120 caracteres)',
        'description' => 'Descrição',
        'description_placeholder' => 'Descrição curta do produto (Máximo 400 caracteres)',
        'categories' => 'Categorias',
        'content' => 'Conteúdo',
        'price' => 'Preço',
        'quantity' => 'Quantidade',
        'brand' => 'Marca',
        'width' => 'Largura',
        'height' => 'Altura',
        'weight' => 'Peso',
        'date' => [
            'start' => 'Data inicial',
            'end' => 'Data final',
        ],
        'image' => 'Imagens',
        'collections' => 'Coleções de produtos',
        'labels' => 'Etiquetas',
        'price_sale' => 'Preço promocional',
        'product_type' => [
            'title' => 'Tipo de produto',
        ],
        'product' => 'Produto',
        'total' => 'Total',
        'sub_total' => 'Subtotal',
        'shipping_fee' => 'Taxa de envio',
        'discount' => 'Desconto',
        'options' => 'Opções',
        'shipping' => [
            'height' => 'Altura',
            'length' => 'Comprimento',
            'title' => 'Envio',
            'weight' => 'Peso',
            'wide' => 'Largura',
        ],
        'barcode' => 'Código de barras (ISBN, UPC, GTIN, etc.) ',
        'barcode_placeholder' => 'Digite o código de barras',
        'cost_per_item' => 'Custo por item',
        'cost_per_item_placeholder' => 'Digite o custo por item',
        'cost_per_item_helper' => 'Os clientes não verão este preço.',
        'price_includes_tax' => 'O preço inclui impostos',
        'price_includes_tax_helper' => 'Marque isso se o preço inserido já inclui impostos. O sistema calculará o preço base removendo o valor do imposto.',
        'stock' => [
            'allow_order_when_out' => 'Permitir que o cliente finalize a compra quando este produto estiver fora de estoque',
            'in_stock' => 'Em estoque',
            'out_stock' => 'Fora de estoque',
            'title' => 'Status do estoque',
        ],
        'storehouse' => [
            'no_storehouse' => 'Sem gerenciamento de estoque',
            'storehouse' => 'Com gerenciamento de estoque',
            'title' => 'Estoque',
            'quantity' => 'Quantidade',
        ],
        'tax' => 'Imposto',
        'taxes' => 'Impostos',
        'taxes_helper' => 'A alíquota de imposto padrão é configurada em <a href=":url">Configurações -> Impostos</a>. Se nenhum imposto específico for selecionado para este produto, a alíquota padrão será aplicada. Para desabilitar o imposto para este produto, remova a alíquota padrão nas configurações de impostos.',
        'is_default' => 'É padrão',
        'action' => 'Ação',
        'restock_quantity' => 'Quantidade de reposição',
        'remain' => 'Remanescente',
        'choose_discount_period' => 'Escolher Período de Desconto',
        'cancel' => 'Cancelar',
        'no_results' => 'Sem resultados!',
        'value' => 'Valor',
        'attribute_name' => 'Nome do atributo',
        'add_more_attribute' => 'Adicionar mais atributos',
        'continue' => 'Continuar',
        'add_new_attributes' => 'Adicionar novos atributos',
        'add_new_attributes_description' => 'Adicionar novos atributos ajuda o produto a ter muitas opções, como tamanho ou cor.',
        'create_product_variations' => ':link para criar variações de produtos!',
        'tags' => 'Tags',
        'write_some_tags' => 'Escreva algumas tags',
        'variation_existed' => 'Esta variação já existe.',
        'no_attributes_selected' => 'Nenhum atributo selecionado!',
        'added_variation_success' => 'Variação adicionada com sucesso!',
        'updated_variation_success' => 'Variação atualizada com sucesso!',
        'created_all_variation_success' => 'Todas as variações criadas com sucesso!',
        'updated_product_attributes_success' => 'Atributos do produto atualizados com sucesso!',
        'stock_status' => 'Status do estoque',
        'auto_generate_sku' => 'Gerar SKU automaticamente?',
        'featured_image' => 'Imagem destacada (opcional)',
        'product_id' => 'ID do Produto',
        'price_sale_percent_helper' => 'Desconto de :percent do preço original.',
        'minimum_order_quantity' => 'Quantidade mínima de pedido',
        'minimum_order_quantity_helper' => 'Quantidade mínima para fazer um pedido, se o valor for 0, não há limite.',
        'maximum_order_quantity' => 'Quantidade máxima de pedido',
        'maximum_order_quantity_helper' => 'Quantidade máxima para fazer um pedido, se o valor for 0, não há limite.',
        'video' => 'Vídeo',
        'video_file' => 'Arquivo',
        'video_url' => 'Ou URL de Vídeo Externo',
        'video_url_help' => 'Digite a URL do vídeo do YouTube ou Vimeo',
        'enter_video_url' => 'Digite a URL do vídeo',
        'video_thumbnail' => 'Miniatura do vídeo',
        'video_thumbnail_help' => 'Escolha uma miniatura para o vídeo. Se não for selecionada, será obtida automaticamente da URL do vídeo, se disponível.',
        'barcode_existed' => 'Este código de barras está sendo usado por outro produto. Por favor, digite outro código de barras.',
        'barcode_helper' => 'Deve ser único para cada produto.',
        'is_new_until' => 'Novo até',
        'is_new_until_helper' => 'Defina uma data até a qual este produto será marcado como "Novo". Deixe vazio para não marcar como novo com base na data.',
    ],
    'price' => 'Preço',
    'quantity' => 'Quantidade',
    'type' => 'Tipo',
    'image' => 'Miniatura',
    'sku' => 'SKU',
    'sku_line' => 'SKU: :sku',
    'variation_sku' => 'SKU da Variação',
    'brand' => 'Marca',
    'cannot_delete' => 'O produto não pôde ser excluído',
    'product_deleted' => 'Produto excluído',
    'product_collections' => 'Coleções de produtos',
    'products' => 'Produtos',
    'menu' => 'Produtos',
    'control' => [
        'button_add_image' => 'Adicionar imagem',
    ],
    'price_sale' => 'Preço promocional',
    'price_group_title' => 'Gerenciar preço do produto',
    'store_house_group_title' => 'Gerenciar estoque',
    'shipping_group_title' => 'Gerenciar envio',
    'overview' => 'Visão geral',
    'attributes' => 'Atributos',
    'product_has_variations' => 'Produto tem variações',
    'manage_products' => 'Gerenciar produtos',
    'add_new_product' => 'Adicionar um novo produto',
    'start_by_adding_new_product' => 'Comece adicionando novos produtos.',
    'edit_this_product' => 'Editar este produto',
    'delete' => 'Excluir',
    'related_products' => 'Produtos relacionados',
    'cross_selling_products' => 'Produtos de venda cruzada',
    'up_selling_products' => 'Produtos de upselling',
    'grouped_products' => 'Produtos agrupados',
    'search_products' => 'Buscar produtos',
    'selected_products' => 'Produtos selecionados',
    'edit_variation_item' => 'Editar',
    'variations_box_description' => 'Clique em "Editar atributo" para adicionar/remover atributos de variação ou clique em "Adicionar nova variação" para adicionar variação.',
    'save_changes' => 'Salvar alterações',
    'continue' => 'Continuar',
    'edit_attribute' => 'Editar atributo',
    'select_attribute' => 'Selecionar atributo',
    'add_new_variation' => 'Adicionar nova variação',
    'edit_variation' => 'Editar variação',
    'generate_variations' => 'Gerar variações',
    'generate_variations_confirmation' => 'Tem certeza de que deseja gerar variações para este produto?',
    'delete_variation' => 'Excluir variação?',
    'delete_variation_confirmation' => 'Tem certeza de que deseja excluir esta variação? Esta ação não pode ser desfeita.',
    'delete_variations_confirmation' => 'Tem certeza de que deseja excluir essas variações? Esta ação não pode ser desfeita.',
    'product_create_validate_name_required' => 'Por favor, digite o nome do produto',
    'product_create_validate_sale_price_max' => 'O desconto deve ser menor que o preço original',
    'product_create_validate_cost_per_item_max' => 'O custo por item deve ser menor que o preço original',
    'product_create_validate_sale_price_required_if' => 'Deve inserir um desconto quando você deseja agendar uma promoção',
    'product_create_validate_end_date_after' => 'A data final deve ser posterior à data inicial',
    'product_create_validate_start_date_required_if' => 'A data de início do desconto não pode ficar em branco quando o agendamento é selecionado',
    'product_create_validate_sale_price' => 'Os descontos não podem ficar em branco quando o agendamento é selecionado',
    'stock_statuses' => [
        'in_stock' => 'Em estoque',
        'out_of_stock' => 'Fora de estoque',
        'on_backorder' => 'Em espera',
    ],
    'stock_status' => 'Status do estoque',
    'processing' => 'Processando...',
    'delete_selected_variations' => 'Excluir variações selecionadas',
    'delete_variations' => 'Excluir variações',
    'category' => 'Categoria',
    'categories' => 'Categorias',
    'tags' => 'Tags',
    'product_price_flash_sale_warning' => 'Este produto está em oferta relâmpago <strong>:name</strong>, então seu preço é <strong>:price</strong>.',
    'product_price_discount_warning' => 'Este produto está em desconto <strong>:name</strong>, então seu preço é <strong>:price</strong>.',
    'product_image' => 'Imagem do produto',
    'product_name' => 'Nome do produto',
    'product_link' => 'Link do produto',
    'types' => [
        'physical' => 'Físico',
        'digital' => 'Digital',
    ],
    'digital_attachments' => [
        'title' => 'Anexos digitais',
        'add' => 'Adicionar Anexo',
        'file_name' => 'Nome do arquivo',
        'file_size' => 'Tamanho do arquivo',
        'unsaved' => 'Não salvo',
        'add_external_link' => 'Adicionar link externo',
        'enter_file_name' => 'Digite o nome do arquivo',
        'enter_external_link_download' => 'Digite o link externo de download',
        'enter_file_size' => 'Digite o tamanho do arquivo',
        'external_link_download' => 'Link externo de download',
        'generate_license_code_after_purchasing_product' => 'Ativar atribuição de código de licença para este produto',
        'notify_attachment_updated' => 'Enviar e-mail para o cliente quando o anexo for atualizado',
    ],
    'license_codes' => [
        'title' => 'Códigos de Licença',
        'add' => 'Adicionar Código de Licença',
        'back' => 'Voltar ao Produto',
        'edit' => 'Editar Código de Licença',
        'generate' => 'Gerar Códigos',
        'manage_codes' => 'Gerenciar Códigos de Licença',
        'management' => 'Gerenciamento de Códigos de Licença',
        'variation_breadcrumb' => 'Variação: :name',
        'variation_label' => 'Variação do Produto',
        'variation_specific_note' => 'Estes códigos de licença são específicos para esta variação de produto. Os clientes que comprarem esta variação receberão códigos desta lista.',
        'main_product_note' => 'Este produto tem variações. Cada variação pode ter seus próprios códigos de licença, ou os clientes podem receber códigos desta lista de produtos principal se a variação não tiver códigos.',
        'code' => 'Código de Licença',
        'codes' => 'Códigos de Licença',
        'status' => 'Status',
        'assigned_at' => 'Atribuído em',
        'status_available' => 'Disponível',
        'status_used' => 'Usado',
        'statuses' => [
            'available' => 'Disponível',
            'used' => 'Usado',
        ],
        'no_codes' => 'Nenhum código de licença encontrado. Adicione alguns códigos ou gere-os automaticamente.',
        'no_codes_warning_title' => 'Nenhum Código de Licença Disponível!',
        'no_codes_warning_message' => 'Este produto está definido como "Escolher da Lista", mas não possui códigos de licença disponíveis. Os clientes que comprarem este produto receberão códigos gerados automaticamente. Por favor, adicione códigos de licença para garantir a funcionalidade adequada.',
        'no_codes_auto_generate' => 'Este produto está configurado para gerar códigos de licença automaticamente. Não são necessários códigos manuais.',
        'used_code_no_actions' => 'Código usado - nenhuma ação disponível',
        'created_successfully' => 'Código de licença criado com sucesso!',
        'updated_successfully' => 'Código de licença atualizado com sucesso!',
        'deleted_successfully' => 'Código de licença excluído com sucesso!',
        'generated_successfully' => ':count códigos de licença gerados com sucesso!',
        'duplicates_skipped' => ':count códigos duplicados foram ignorados.',
        'generation_incomplete' => 'Aviso: Foi possível gerar apenas :generated dos :requested códigos solicitados devido a conflitos de duplicação.',
        'cannot_edit_used_code' => 'Não é possível editar um código de licença usado.',
        'cannot_delete_used_code' => 'Não é possível excluir um código de licença usado.',
        'show_all' => 'Mostrar tudo',
        'show_less' => 'Mostrar menos',
        'more' => 'mais',
        'used_codes_hidden' => ':count código(s) de licença usado(s) está(ão) oculto(s). Você pode visualizar todos os códigos na página de Gerenciamento de Códigos de Licença.',
        'low_stock_title' => 'Estoque Baixo de Códigos de Licença',
        'low_stock_message' => 'Apenas :count códigos de licença restantes. Considere adicionar mais códigos para evitar ficar sem estoque.',
        'out_of_stock_title' => 'Sem Códigos de Licença!',
        'out_of_stock_message' => 'Nenhum código de licença disponível. Os clientes receberão códigos gerados automaticamente até que você adicione mais.',
        'type' => [
            'title' => 'Método de Atribuição de Código de Licença',
            'auto_generate' => 'Gerar Automaticamente (O sistema gera códigos automaticamente)',
            'pick_from_list' => 'Escolher da Lista (Usar códigos pré-inseridos)',
            'description' => 'Escolha como os códigos de licença devem ser atribuídos aos clientes quando eles comprarem este produto.',
        ],
        'generate_modal' => [
            'title' => 'Gerar Códigos de Licença',
            'quantity' => 'Quantidade',
            'format' => 'Formato',
            'custom_pattern' => 'Padrão Personalizado',
            'pattern_help' => 'Use # para números, A para letras maiúsculas, a para letras minúsculas',
            'generate' => 'Gerar',
        ],
        'errors' => [
            'feature_not_enabled' => 'O recurso de códigos de licença não está habilitado. Por favor, habilite-o em Configurações de E-commerce -> Produtos Digitais.',
            'digital_products_not_enabled' => 'Produtos digitais não estão habilitados. Por favor, habilite o suporte a produtos digitais primeiro.',
            'product_not_found' => 'Produto não encontrado.',
            'not_digital_product' => 'Códigos de licença estão disponíveis apenas para produtos digitais. Este produto está definido como produto físico.',
            'license_codes_not_enabled_for_product' => 'O gerenciamento de códigos de licença não está habilitado para este produto. Por favor, habilite "Gerar código de licença após comprar o produto" nas configurações do produto.',
            'cannot_add_codes_auto_generate' => 'Não é possível adicionar manualmente códigos de licença a produtos configurados para gerar automaticamente. Altere o tipo de código de licença para "Escolher da Lista" primeiro.',
            'cannot_generate_codes_auto_generate' => 'Não é possível gerar manualmente códigos de licença para produtos configurados para gerar automaticamente. Altere o tipo de código de licença para "Escolher da Lista" primeiro.',
        ],
        'copied' => 'Código de licença copiado para a área de transferência!',
    ],
    'this_action_will_reload_page' => 'Esta ação recarregará a página para atualizar os dados!',
    'select' => 'Selecionar',
    'set_this_variant_as_default' => 'Definir esta variante como padrão',
    'download' => 'Download',
    'cross_sell_price_type' => [
        'title' => 'Tipo de preço',
        'fixed' => 'Fixo',
        'percent' => 'Porcentagem',
    ],
    'cross_sell_help' => [
        'price' => 'Preço',
        'price_description' => 'Digite o valor que deseja reduzir do preço original. Exemplo: Se o preço original for R$ 100, digite 20 para reduzir o preço para R$ 80.',
        'type' => '* Campo de tipo',
        'type_description' => 'Escolha o tipo de desconto: Fixo (reduzir um valor específico) ou Porcentagem (reduzir por uma porcentagem).',
    ],
    'apply_for_all_variations' => 'Aplicar para todas as variações',
    'export' => [
        'description' => 'Exporte os dados dos seus produtos para arquivos CSV ou Excel.',
        'total_items' => 'Total de Itens',
        'total_products' => 'Total de Produtos',
        'total_variations' => 'Total de Variações',
        'advanced_options' => 'Opções Avançadas',
        'use_chunked_export' => 'Usar exportação em blocos',
        'use_chunked_export_helper' => 'Processar dados em blocos para lidar com grandes conjuntos de dados de forma eficiente',
        'include_variations' => 'Incluir variações de produtos',
        'include_variations_helper' => 'Exportar variações de produtos junto com produtos principais',
        'optimize_memory' => 'Otimizar uso de memória',
        'optimize_memory_helper' => 'Habilitar otimização de memória para exportações muito grandes',
        'chunk_size' => 'Tamanho do bloco',
        'chunk_size_helper' => 'Número de produtos a processar por vez (50-5000)',
        'use_streaming' => 'Usar exportação em streaming',
        'use_streaming_helper' => 'Habilitar streaming para conjuntos de dados muito grandes (habilitado automaticamente para >10.000 itens)',
        'large_dataset_warning_title' => 'Catálogo de Produtos Grande Detectado',
        'large_dataset_warning_message' => 'Seu catálogo contém :count itens. Devido ao tamanho grande, algumas opções de exportação foram otimizadas para melhor desempenho.',
        'large_dataset_specific_message' => 'Para seus :count produtos, use o formato CSV com streaming habilitado. O sistema agora pode lidar com seu grande catálogo de produtos de forma eficiente, sem timeouts ou problemas de memória.',
        'format_label' => 'Formato',
        'csv_recommended' => 'CSV (Obrigatório)',
        'chunk_label' => 'Processamento',
        'chunk_recommended' => '300 produtos/lote',
        'time_label' => 'Tempo Estimado',
        'time_estimate' => '1-3 minutos',
        'pro_tip' => 'Dica Profissional:',
        'pro_tip_message' => 'A exportação continuará em execução mesmo se o navegador mostrar um indicador de carregamento. Uma vez iniciado, o download começará automaticamente.',
        'large_dataset_tip_1' => 'O formato Excel foi desabilitado - use o formato CSV para exportações mais rápidas e confiáveis',
        'large_dataset_tip_2' => 'O modo de streaming foi habilitado automaticamente para evitar timeouts',
        'large_dataset_tip_3' => 'O processo de exportação pode levar de 1 a 3 minutos, dependendo do seu servidor',
        'large_dataset_recommendation' => 'Recomendado: Use o formato CSV com tamanho de bloco de 200-500 para desempenho ideal.',
        'excel_disabled_for_large_export' => 'Formato Excel não disponível para catálogos com mais de 10.000 itens',
        'streaming_auto_enabled' => 'O modo de streaming foi habilitado automaticamente para desempenho ideal com grandes conjuntos de dados.',
        'streaming_enabled_title' => 'Otimizado para Grande Exportação',
        'streaming_enabled_message' => 'O modo de streaming está ativo para garantir exportação suave sem problemas de memória.',
        'use_multi_file' => 'Usar exportação em múltiplos arquivos',
        'use_multi_file_helper' => 'Dividir exportação em múltiplos arquivos empacotados em um ZIP para conjuntos de dados muito grandes',
        'multi_file_enabled_title' => 'Exportação em Múltiplos Arquivos Habilitada',
        'multi_file_enabled_message' => 'Sua exportação será dividida em :count arquivos empacotados em um ZIP para desempenho ideal.',
        'records_per_file' => 'Registros Por Arquivo',
        'records_per_file_helper' => 'Número de registros em cada arquivo ao usar exportação em múltiplos arquivos',
        'estimated_files' => 'Arquivos Estimados',
        'recommended_range' => 'Faixa recomendada',
        'range_large_export' => '200-500 itens',
        'range_medium_export' => '300-800 itens',
        'range_small_export' => '500-1000 itens',
        'export_progress' => 'Progresso da Exportação',
        'preparing_export' => 'Preparando exportação...',
        'items_processed' => ':count itens processados',
        'estimated_time_calculating' => 'Tempo estimado: calculando...',
        'medium_dataset_detected' => 'Conjunto de Dados Médio Detectado',
        'medium_dataset_message' => 'Você está exportando :count produtos. Considere usar exportação em blocos para melhor desempenho.',
        'optimal_range' => 'Faixa ideal',
        'too_small_slow' => 'Muito pequeno - pode ser lento',
        'too_large_timeouts' => 'Muito grande - pode causar timeouts',
        'excel_disabled_warning' => 'Formato Excel desabilitado para grandes exportações (:count itens)',
        'starting_export' => 'Iniciando Exportação...',
        'processing_data' => 'Processando dados...',
        'finalizing_export' => 'Finalizando exportação...',
        'items_processed_suffix' => 'itens processados',
        'estimated_time_prefix' => 'Tempo estimado:',
        'seconds_remaining' => 's restantes',
        'export_completed' => 'Exportação concluída!',
        'download_starting' => 'Download iniciando...',
    ],
    'import' => [
        'description' => 'Importe os dados dos seus produtos de arquivos CSV ou Excel.',
        'rules' => [
            'in' => ':attribute deve ser um dos valores definidos: :values.',
            'required_string_max' => ':attribute é obrigatório e deve ser uma string com comprimento máximo de :max caracteres.',
            'nullable_string' => ':attribute pode ser deixado vazio ou deve ser uma string se fornecido.',
            'nullable_string_max' => ':attribute pode ser deixado vazio ou deve ser uma string com comprimento máximo de :max caracteres se fornecido',
            'nullable_bool' => ':attribute pode ser deixado vazio ou deve ser um valor booleano se fornecido.',
            'nullable_numeric_min' => ':attribute pode ser deixado vazio ou deve ser um número não negativo se fornecido.',
            'nullable_numeric_min_max' => ':attribute pode ser deixado em branco ou deve ser um número entre :min e :max se fornecido.',
            'nullable_array' => ':attribute pode ser deixado vazio ou deve ser fornecido como um array se especificado.',
            'nullable_date_required_if' => ':attribute pode ser deixado vazio ou deve ser uma data válida se fornecido, obrigatório se :required for especificado.',
            'nullable_date_after' => ':attribute pode ser deixado vazio ou deve ser uma data válida após :after se fornecido.',
        ],
        'updated_message' => ':count produtos atualizados com sucesso!',
    ],
    'import_products_intro' => 'Ou importe produtos de CSV/Excel',
    'select_attributes' => 'Selecione atributos para criar variações:',
    'all' => 'Todos',
    'copy' => 'Copiar',
    'product_translations' => 'Traduções de Produtos',
    'view' => 'Ver produto - :name',
    'product_information' => 'Informações do Produto',
    'total_views' => 'Visualizações Totais',
    'total_orders' => 'Pedidos Concluídos',
    'total_sold' => 'Total Vendido',
    'total_revenue' => 'Receita Total',
    'pending_orders' => 'Pedidos pendentes',
    'pending_revenue' => 'Receita pendente',
    'conversion_rate' => 'Taxa de conversão',
    'total_reviews' => 'Avaliações Totais',
    'average_rating' => 'Avaliação Média',
    'views_by_date' => 'Visualizações por Data (Últimos 30 Dias)',
    'recent_orders' => 'Pedidos Recentes',
    'no_views_data' => 'Nenhum dado de visualização disponível nos últimos 30 dias.',
    'no_orders' => 'Ainda sem pedidos.',
    'date' => 'Data',
    'views' => 'Visualizações',
    'total' => 'Total',
    'view_on_frontend' => 'Ver no site',
    'select_attribute' => 'Selecionar :name',
    'all_categories' => 'Todas as categorias',
    'brands' => 'Marcas',
    'browse_products' => 'Navegar Produtos',
    'sku_1' => 'SKU:',
    'select_products_to_return' => 'Selecionar Produtos para Devolver',
    'show_only_discounted_products' => 'Mostrar apenas produtos com desconto',
    'specification' => 'Especificação',
    'download_product_with_external_links' => 'Baixar produto ":name" com links externos',
    'number_product_available_singular' => ':number produto disponível',
    'number_products_available_plural' => ':number produtos disponíveis',
    'cart' => [
        'added_to_cart_success' => ':product foi adicionado ao seu carrinho.',
        'removed_from_cart_success' => ':product foi removido do seu carrinho.',
        'updated_cart_success' => 'Seu carrinho foi atualizado.',
        'item_not_found' => 'Este item não está mais no seu carrinho.',
        'out_of_stock' => 'Desculpe, :product está esgotado no momento.',
        'max_quantity' => 'Você só pode adicionar até :max itens.',
        'max_quantity_detail' => 'Desculpe, você só pode pedir até :quantity unidades de :product por vez.',
        'select_options' => 'Por favor, selecione as opções do produto antes de adicionar ao carrinho.',
        'product_out_of_stock' => 'Desculpe, este produto está esgotado no momento.',
        'product_not_exists' => 'Este produto está esgotado ou não existe mais.',
        'not_enough_quantity' => 'Alguns produtos não têm estoque suficiente para atualizar.',
        'empty_success' => 'Seu carrinho foi esvaziado.',
    ],
    'wishlist' => [
        'added_success' => ':product foi adicionado à sua lista de desejos.',
        'removed_success' => ':product foi removido da sua lista de desejos.',
        'product_not_found' => 'Este produto não pôde ser encontrado.',
        'product_not_in_wishlist' => 'Este produto não está na sua lista de desejos.',
        'product_not_available' => 'Este produto não está disponível.',
    ],
    'compare' => [
        'added_success' => ':product foi adicionado à sua lista de comparação.',
        'removed_success' => ':product foi removido da sua lista de comparação.',
        'product_not_found' => 'Este produto não pôde ser encontrado.',
        'product_not_in_compare' => 'Este produto não está na sua lista de comparação.',
        'already_in_list' => ':product já está na sua lista de comparação.',
    ],
];
