<?php

return [
    'save_settings' => 'Salvează setările',
    'ecommerce' => 'Ecommerce',
    'general' => [
        'name' => 'General',
        'description' => 'Numele magazinului, info companie, contact și emailuri notificare admin',
    ],
    'currency' => [
        'name' => 'Valute',
        'description' => 'Formate monedă, cursuri de schimb, detecție automată și separatori zecimali/mii',
        'currency_setting_description' => 'Vizualizați și actualizați valutele folosite pe site',
        'form' => [
            'enable_auto_detect_visitor_currency' => 'Activați detectarea automată a valutei vizitatorului',
            'enable_auto_detect_visitor_currency_helper' => 'Detectați automat și afișați prețurile în valuta locală a vizitatorului pe baza locației acestuia. Aceasta oferă o experiență de cumpărare mai personalizată.',
            'add_space_between_price_and_currency' => 'Adăugați un spațiu între preț și valută',
            'add_space_between_price_and_currency_helper' => 'Când este activat, adaugă un spațiu între valoarea prețului și simbolul valutei (ex: "100 USD" în loc de "100USD").',
            'thousands_separator' => 'Separator mii',
            'thousands_separator_helper' => 'Alegeți caracterul pentru separarea miilor în afișarea prețului (ex: 1,000 sau 1.000 sau 1 000).',
            'decimal_separator' => 'Separator zecimal',
            'decimal_separator_helper' => 'Alegeți caracterul pentru separarea valorilor zecimale în prețuri (ex: 10.99 sau 10,99).',
            'separator_period' => 'Punct (.)',
            'separator_comma' => 'Virgulă (,)',
            'separator_space' => 'Spațiu ( )',
            'api_key' => 'Cheie API cursuri de schimb',
            'api_key_helper' => 'Obțineți cheia API curs de schimb pe :link',
            'update_currency_rates' => 'Actualizați cursurile valutare',
            'use_exchange_rate_from_api' => 'Folosiți cursul de schimb de la API',
            'use_exchange_rate_from_api_helper' => 'Activați actualizările automate ale cursului de schimb valutar de la furnizorul API configurat. Aceasta asigură că prețurile sunt întotdeauna actualizate cu ratele de piață curente.',
            'clear_cache_rates' => 'Curățați cache-ul cursurilor',
            'auto_detect_visitor_currency_description' => 'Detectează valuta vizitatorului pe baza limbii browserului. Va suprascrie selecția implicită a valutei.',
            'exchange_rate' => [
                'api_provider' => 'Furnizor API',
                'select' => '-- Selectați --',
                'none' => 'Niciuna',
                'provider' => [
                    'api_layer' => 'API Layer',
                    'open_exchange_rate' => 'Open Exchange Rates',
                ],
                'open_exchange_app_id' => 'ID Aplicație Open Exchange Rates',
            ],
            'default_currency_warning' => 'Pentru valuta implicită, cursul de schimb trebuie să fie 1.',
        ],
    ],
    'product' => [
        'name' => 'Produse',
        'description' => 'Afișare stoc, generare SKU, imagini variante, produse asociate și specificații',
        'product_settings' => 'Setări produse',
        'product_settings_description' => 'Configurați reguli pentru produse',
        'form' => [
            'show_number_of_products' => 'Afișați numărul de produse în pagina de produs',
            'show_number_of_products_helper' => 'Afișați numărul total de produse pe pagina de detalii a produsului.',
            'show_out_of_stock_products' => 'Afișați produsele epuizate',
            'show_out_of_stock_products_helper' => 'Dacă este activat, produsele epuizate vor fi afișate pe pagina de listare a produselor.',
            'how_to_display_product_variation_images' => 'Cum să afișați imaginile variațiilor de produs',
            'how_to_display_product_variation_images_helper' => 'Alegeți dacă să afișați doar imaginile specifice variației sau să includeți atât imaginile variației cât și ale produsului principal.',
            'only_variation_images' => 'Doar imagini variație',
            'variation_images_and_main_product_images' => 'Imagini variație și imagini produs principal',
            'enable_product_options' => 'Activați opțiunile de produs',
            'enable_product_options_helper' => 'Permiteți produselor să aibă opțiuni personalizabile precum mărimea, culoarea, etc.',
            'is_enabled_cross_sale_products' => 'Activați produse vânzare încrucișată',
            'is_enabled_cross_sale_products_helper' => 'Afișați sugestii de produse de vânzare încrucișată pentru a încuraja achiziții suplimentare.',
            'is_enabled_related_products' => 'Activați produse conexe',
            'is_enabled_related_products_helper' => 'Afișați produse conexe pe baza categoriei, sau selectate de admin în formularul de produs.',
            'related_products_source' => 'Sursă produse conexe',
            'related_products_source_helper' => 'Când admin-ul nu selectează produse conexe în formularul de produs, afișați produse conexe pe baza acestei surse.',
            'related_products_source_category' => 'Aceeași categorie',
            'related_products_source_brand' => 'Aceeași marcă',
            'trending_products_period' => 'Perioadă produse tendință',
            'trending_products_period_helper' => 'Selectați perioada de timp de luat în considerare pentru calcularea produselor tendință pe baza numărului de vizualizări.',
            'trending_products_period_1_day' => 'Ultimele 24 ore',
            'trending_products_period_3_days' => 'Ultimele 3 zile',
            'trending_products_period_7_days' => 'Ultimele 7 zile (1 săptămână)',
            'trending_products_period_14_days' => 'Ultimele 14 zile (2 săptămâni)',
            'trending_products_period_30_days' => 'Ultimele 30 zile (1 lună)',
            'trending_products_period_60_days' => 'Ultimele 60 zile (2 luni)',
            'trending_products_period_90_days' => 'Ultimele 90 zile (3 luni)',
            'auto_generate_product_sku' => 'Generare automată SKU la crearea produsului',
            'auto_generate_product_sku_helper' => 'Generați automat SKU-uri unice pentru produse noi pe baza formatului de mai jos.',
            'product_sku_format' => 'Format SKU',
            'product_sku_format_helper' => 'Puteți folosi %s (1 caracter șir) sau %d (1 cifră) în format pentru a genera șir aleatoriu. Ex: SKU-%s%s%s-HN-%d%d%d',
            'enable_product_specification' => 'Activați specificațiile produsului',
            'enable_product_specification_help' => 'Dacă este activat, tabelul de specificații al produsului va fi afișat pe pagina de detalii a produsului.',
            'make_product_barcode_required' => 'Faceți codul de bare al produsului obligatoriu',
            'make_product_barcode_required_helper' => 'Dacă este activat, codul de bare al produsului va fi obligatoriu la crearea unui produs.',
        ],
    ],
    'product_search' => [
        'name' => 'Căutare Produs',
        'description' => 'Comportament căutare, filtre după categorie/brand/tag/atribute și filtrare interval preț',
        'product_search_settings' => 'Căutare produse',
        'product_search_settings_description' => 'Configurați reguli pentru căutarea produselor',
        'form' => [
            'search_for_an_exact_phrase' => 'Căutați o expresie exactă',
            'search_products_by' => 'Căutați produse după:',
            'enable_filter_products_by_categories' => 'Activați filtrarea produselor după categorii',
            'enable_filter_products_by_brands' => 'Activați filtrarea produselor după mărci',
            'enable_filter_products_by_tags' => 'Activați filtrarea produselor după etichete',
            'number_of_popular_tags_for_filter' => 'Număr de etichete populare pentru filtrare',
            'number_of_popular_tags_for_filter_placeholder' => 'Introduceți numărul de etichete populare de afișat',
            'number_of_popular_tags_for_filter_helper' => 'Setați numărul maxim de etichete populare de afișat în filtru. Implicit este 10.',
            'enable_filter_products_by_attributes' => 'Activați filtrarea produselor după atribute',
            'enable_filter_products_by_price' => 'Activați filtrarea produselor după preț',
            'max_product_price_for_filter' => 'Preț maxim produs pentru filtrare',
            'max_product_price_for_filter_placeholder' => 'Dacă este gol sau zero, va obține prețul maxim al produsului din produsele existente.',
            'max_product_price_for_filter_helper' => 'Puteți seta un preț fix pentru aceasta sau va obține dinamic prețul maxim al produsului din produsele existente. În prezent este :price.',
        ],
    ],
    'digital_product' => [
        'name' => 'Produse Digitale',
        'description' => 'Produse descărcabile, coduri de licență, checkout oaspeți pentru produse digitale și completare automată',
        'digital_products_settings' => 'Produse digitale',
        'digital_products_settings_description' => 'Configurați reguli pentru produse digitale',
        'form' => [
            'enable_support_digital_product' => 'Este activat suportul pentru produse digitale',
            'enable_support_digital_product_helper' => 'Când este activat, sistemul va suporta vânzarea de produse digitale precum software, cărți electronice, muzică și alt conținut descărcabil.',
            'allow_guest_checkout_for_digital_products' => 'Permiteți finalizarea comenzii pentru vizitatori pentru produse digitale',
            'allow_guest_checkout_for_digital_products_helper' => 'Când este activat, clienții pot achiziționa produse digitale fără a crea un cont. Vor primi linkuri de descărcare prin email.',
            'disable_physical_product' => 'Dezactivați produsul fizic',
            'disable_physical_product_helper' => 'Când este activat, magazinul va vinde doar produse digitale. Opțiunile pentru produse fizice vor fi ascunse din formularele de produs și finalizare comandă.',
            'enable_license_codes_for_digital_products' => 'Activați coduri de licență pentru produse digitale',
            'auto_complete_digital_orders_after_payment' => 'Finalizare automată comenzi digitale după plată',
            'auto_complete_digital_orders_after_payment_helper' => 'Când este activat, comenzile care conțin doar produse digitale vor fi marcate automat ca finalizate odată ce plata este primită.',
            'enable_license_codes_for_digital_products_helper' => 'Când este activat, puteți adăuga coduri de licență la produsele digitale. Când este dezactivat, funcționalitatea de cod de licență va fi ascunsă din formularele de produs.',
            'hide_used_license_codes_in_product_form' => 'Ascundeți codurile de licență folosite în formularul de produs',
            'hide_used_license_codes_in_product_form_helper' => 'Când este activat, codurile de licență folosite vor fi ascunse din tabelul de coduri de licență în formularul de editare produs. Aceasta ajută la menținerea interfeței curate când aveți multe coduri folosite.',
        ],
    ],
    'product_review' => [
        'name' => 'Recenzii Produse',
        'description' => 'Recenzii clienți, afișare evaluări, încărcare imagini și cerințe de aprobare',
        'form' => [
            'enable_review' => 'Activați recenziile produselor',
            'enable_review_help' => 'Permiteți clienților să lase recenzii și evaluări pentru produse. Când este dezactivat, toate funcțiile de recenzii vor fi ascunse din magazin.',
            'allow_customer_upload_image_in_review' => 'Permiteți clienților să încarce imagini în recenzii',
            'allow_customer_upload_image_in_review_help' => 'Când este dezactivat, clienții nu pot încărca imagini când trimit recenzii',
            'review' => [
                'max_file_size' => 'Mărime maximă fișier recenzie (MB)',
                'max_file_number' => 'Număr maxim fișiere recenzie',
            ],
            'only_allow_customers_purchased_to_review' => 'Doar clienții care au achiziționat produsul pot recenza produsul',
            'review_need_to_be_approved' => 'Recenzia trebuie aprobată înainte de a fi afișată pe pagina produsului',
            'show_customer_full_name' => 'Afișați numele complet al clientului',
            'show_customer_full_name_help' => 'Dacă este debifat, numele clientului care face recenzia va fi ascuns și înlocuit cu asteriscuri (***)',
            'hide_rating_when_no_reviews' => 'Ascundeți evaluarea când nu există recenzii',
            'hide_rating_when_no_reviews_help' => 'Când este activat, evaluările produselor vor fi ascunse în listele de produse și paginile de detalii ale produselor când produsul nu are recenzii',
            'display_uploaded_customer_review_images_list' => 'Afișați secțiunea "Imagini de la clienți"',
            'display_uploaded_customer_review_images_list_help' => 'Când este activat, afișează o galerie cu toate imaginile încărcate de clienți în partea de sus a secțiunii de recenzii',
        ],
    ],
    'shopping' => [
        'name' => 'Cumpărături',
        'description' => 'Coș, listă de dorințe, comparare, urmărire comenzi, buton cumpărare rapidă și încărcare dovadă plată',
        'general_setting' => 'Setări generale',
        'return_settings' => 'Setări returnare',
        'return_settings_description' => 'Configurați reguli pentru setările de returnare',
        'form' => [
            'enable_cart' => 'Activați coșul de cumpărături',
            'enable_cart_helper' => 'Dacă este dezactivat, butonul coș va fi eliminat, transformând site-ul într-o afișare doar catalog.',
            'enable_wishlist' => 'Activați lista de dorințe',
            'enable_wishlist_helper' => 'Dacă este dezactivat, butonul listă de dorințe va fi eliminat de pe site.',
            'enable_wishlist_sharing' => 'Activați partajarea listei de dorințe',
            'shared_wishlist_lifetime' => 'Durata de viață listă de dorințe partajată (zile)',
            'shared_wishlist_lifetime_helper' => 'Durata de viață a listei de dorințe partajate în zile. După acest timp, lista de dorințe partajată va fi ștearsă.',
            'enable_compare' => 'Activați compararea',
            'enable_compare_helper' => 'Dacă este dezactivat, butonul de comparare va fi eliminat de pe site.',
            'enable_order_tracking' => 'Activați urmărirea comenzii',
            'enable_order_tracking_helper' => 'Clienții pot urmări comenzile introducând codul comenzii și emailul/telefonul pe :url',
            'order_tracking_method' => 'Metodă urmărire comandă',
            'order_tracking_method_helper' => 'Alegeți cum vor urmări clienții comenzile lor: folosind ID Comandă + Email sau ID Comandă + Număr telefon.',
            'order_tracking_method_email' => 'ID Comandă + Email',
            'order_tracking_method_phone' => 'ID Comandă + Număr telefon',
            'enable_quick_buy_button' => 'Activați butonul de cumpărare rapidă',
            'enable_quick_buy_button_helper' => 'Va afișa un buton Cumpără Acum pe pagina de listare și detalii a produsului. Când clienții fac click pe acest buton, produsul va fi adăugat în coș și redirecționat la pagina coș/finalizare comandă.',
            'enable_order_auto_confirmed' => 'Confirmare automată comandă',
            'enable_order_auto_confirmed_helper' => 'Dacă este activat, comanda va fi confirmată automat după ce clientul plasează o comandă.',
            'quick_buy_target' => 'Pagină țintă cumpărare rapidă',
            'checkout_page' => 'Pagină finalizare',
            'cart_page' => 'Pagină coș',
            'cart_destroy_on_logout' => 'Distruge coșul la deconectare',
            'cart_destroy_on_logout_helper' => 'Coșul va fi distrus când clientul se deconectează.',
            'hide_product_price' => 'Ascunde prețul produsului',
            'hide_product_price_helper' => 'Această opțiune funcționează doar dacă dezactivați coșul de cumpărături, transformând site-ul într-o afișare doar catalog. Dacă este activat, prețul produsului va fi ascuns. Este util când doriți să ascundeți prețul și să cereți clienților să vă contacteze pentru preț.',
            'hide_product_price_when_zero' => 'Ascunde prețul produsului când este zero',
            'hide_product_price_when_zero_helper' => 'Dacă este activat, produsele cu preț 0 nu vor afișa un preț în magazin.',
            'enable_payment_proof' => 'Activați încărcarea dovezii de plată',
            'enable_payment_proof_helper' => 'Permiteți clienților să încarce dovada plății pentru comenzile lor. Aceasta este utilă pentru metodele de plată manuale.',
            'enable_guest_payment_proof' => 'Permiteți clienților vizitatori să încarce dovada plății',
            'enable_guest_payment_proof_helper' => 'Când este activat, clienții vizitatori pot încărca dovada plății folosind tokenul comenzii lor fără a se autentifica. Vor primi linkul de încărcare în emailul de confirmare a comenzii.',
            'payment_proof_payment_methods' => 'Metode de plată care necesită dovada plății',
            'payment_proof_payment_methods_helper' => 'Selectați ce metode de plată ar trebui să permită clienților să încarce dovada plății. De obicei folosit pentru metode de plată manuale precum plata la livrare și transferul bancar.',
        ],
    ],
    'checkout' => [
        'name' => 'Finalizare',
        'panel_description' => 'Checkout oaspeți, câmpuri obligatorii, limite comenzi, acceptare termeni și restricții țări',
        'description' => 'Configurați reguli pentru setările de finalizare',
        'form' => [
            'display_bank_info_at_the_checkout_success_page' => 'Afișați informațiile bancare pe pagina de succes finalizare',
            'mandatory_form_fields_at_checkout' => 'Câmpuri obligatorii pe pagina de finalizare:',
            'mandatory_form_fields_at_checkout_helper' => 'Selectați ce câmpuri sunt obligatorii în timpul finalizării. Clienții trebuie să completeze aceste câmpuri pentru a finaliza comanda.',
            'hide_form_fields_at_checkout' => 'Ascundeți câmpurile clienților la pagina de finalizare:',
            'hide_form_fields_at_checkout_helper' => 'Selectați ce câmpuri ar trebui ascunse pe pagina de finalizare. Aceste câmpuri nu vor fi vizibile pentru clienți.',
            'load_countries_states_cities_from_location_plugin' => 'Încărcați țări, județe, orașe din plugin-ul de locație',
            'load_countries_states_cities_from_location_plugin_placeholder' => 'După modificarea acestei opțiuni, trebuie să actualizați din nou toate adresele. Ar trebui să setați acest lucru o singură dată.',
            'load_countries_states_cities_from_location_plugin_placeholder_2' => 'Apoi trebuie să mergeți la Instrumente -> Import/Export Date pentru a importa datele de locație.',
            'minimum_order_amount' => 'Suma minimă a comenzii pentru a plasa o comandă (:currency).',
            'minimum_order_amount_helper' => 'Setați suma totală minimă necesară pentru ca o comandă să fie procesată. Comenzile sub această sumă nu vor fi acceptate.',
            'zip_code_enabled' => 'Activați codul poștal',
            'zip_code_enabled_helper' => 'Activați sau dezactivați câmpul cod poștal în formularul de adresă de livrare.',
            'billing_address_enabled' => 'Activați adresa de facturare',
            'billing_address_enabled_helper' => 'Permiteți clienților să introducă o adresă de facturare separată care diferă de adresa de livrare.',
            'display_tax_fields_at_checkout_page' => 'Afișați câmpurile informațiilor fiscale la pagina de finalizare',
            'display_tax_fields_at_checkout_page_helper' => 'Dacă este activat, câmpurile de informații fiscale vor fi afișate pentru introducerea detaliilor fiscale ale companiei pentru a primi o factură.',
            'use_city_field_as_field_text' => 'Folosiți câmpul oraș ca câmp text liber',
            'available_countries' => 'Țări disponibile',
            'all' => 'Toate',
            'all_helper_text' => 'Dacă debifați toate țările, se va aplica pentru toate țările.',
            'enable_guest_checkout' => 'Activați finalizarea pentru vizitatori',
            'enable_guest_checkout_helper' => 'Dacă este activat, clienții pot plasa o comandă fără a crea un cont.',
            'recently_viewed' => [
                'enable' => 'Activați produsele vizualizate recent de client',
                'enable_helper' => 'Urmăriți și afișați produsele pe care clienții le-au văzut recent. Aceasta îi ajută pe clienți să găsească cu ușurință produsele care i-au interesat.',
                'max' => 'Număr maxim de produse vizualizate recent de client',
                'max_helper_text' => 'Dacă este setat la 0, nu va exista limită.',
            ],
            'minimum_order_quantity' => 'Cantitate minimă comandă',
            'minimum_order_quantity_helper' => 'Cantitate minimă pentru plasarea unei comenzi. Lăsați-o la 0 dacă nu doriți să o setați.',
            'maximum_order_quantity' => 'Cantitate maximă comandă',
            'maximum_order_quantity_helper' => 'Cantitate maximă pentru plasarea unei comenzi. Lăsați-o la 0 dacă nu doriți să o setați.',
            'default_country_at_checkout_page' => 'Țară implicită la pagina de finalizare',
            'default_country_at_checkout_page_placeholder' => 'Selectați o țară',
            'default_country_at_checkout_page_help' => 'Dacă selectați o țară, țara va fi selectată implicit la pagina de finalizare.',
            'checkout_product_quantity_editable' => 'Permiteți clienților să modifice cantitatea produsului la pagina de finalizare',
            'checkout_product_quantity_editable_helper' => 'Când este activat, clienții pot modifica cantitatea produselor direct pe pagina de finalizare fără a reveni la coș.',
            'show_terms_and_policy_checkbox' => 'Afișați caseta de termeni și politici',
            'show_terms_and_policy_checkbox_helper' => 'Dacă este activat, clienții trebuie să fie de acord cu termenii și politicile înainte de a plasa o comandă. Vă rugăm configurați URL-ul Termeni și Politica de Confidențialitate în Aspect -> Opțiuni temă mai întâi.',
            'terms_and_policy_checkbox_checked_by_default' => 'Caseta de termeni și politici bifată implicit',
            'terms_and_policy_checkbox_checked_by_default_helper' => 'Dacă este activat, caseta de termeni și politici va fi pre-bifată când formularul de finalizare se încarcă.',
            'checkout_acceptance_message_enabled' => 'Afișați mesajul de acceptare la finalizare',
            'checkout_acceptance_message_enabled_helper' => 'Afișați un mesaj informativ care informează clienții despre termenii cu care sunt de acord plasând o comandă.',
            'hide_customer_info_at_checkout' => 'Ascundeți informațiile clientului la finalizare',
            'hide_customer_info_at_checkout_helper' => 'Ascundeți informațiile contului de client și butonul de deconectare de pe pagina de finalizare. Când este activat, clienții autentificați nu vor vedea detaliile contului afișate.',
        ],
    ],
    'return' => [
        'name' => 'Returnare',
        'description' => 'Configurați reguli pentru setările de returnare',
        'panel_description' => 'Retururi comenzi, retururi parțiale și limite de timp pentru retururi',
        'form' => [
            'is_enabled_order_return' => 'Este activată returnarea comenzii',
            'allow_partial_return' => 'Permiteți returnarea parțială',
            'allow_partial_return_description' => 'Clientul poate returna câteva produse, nu trebuie să returneze toate produsele dintr-o comandă.',
            'returnable_days' => 'Zile returnabile',
            'return_settings_helper' => 'Număr de zile în care un client poate solicita o returnare după ce comanda este finalizată.',
        ],
    ],
    'invoice' => [
        'name' => 'Facturi',
        'description' => 'Detalii companie pe facturi, numerotare facturi, fonturi PDF și setări ștampilă',
        'company_settings' => 'Setări companie',
        'company_settings_description' => 'Setări Informații companie pentru facturare',
        'form' => [
            'company_name' => 'Nume companie',
            'company_address' => 'Adresă companie',
            'company_zipcode' => 'Cod poștal companie',
            'company_email' => 'Email companie',
            'company_phone' => 'Telefon companie',
            'company_logo' => 'Logo companie',
            'company_tax_id' => 'Cod fiscal companie',
            'invoice_code_prefix' => 'Prefix cod factură',
            'using_custom_font_for_invoice' => 'Folosind font personalizat pentru factură',
            'invoice_font_family' => 'Familie fonturi factură (Funcționează doar pentru limba latină)',
            'enable_invoice_stamp' => 'Activați ștampila facturii',
            'add_language_support' => 'Adăugați suport lingvistic',
            'invoice_processing_library' => 'Bibliotecă procesare factură',
            'only_latin_languages' => 'Doar limbi latine',
            'disable_order_invoice_until_order_confirmed' => 'Dezactivați factura comenzii până când comanda este confirmată',
            'date_format' => 'Format dată',
            'languages' => [
                'arabic' => 'Arabă',
                'bangladesh' => 'Bengaleză',
                'chinese' => 'Chineză',
            ],
        ],
    ],
    'tax' => [
        'name' => 'Taxă',
        'description' => 'Setări taxe',
        'enable' => 'Activați taxele?',
        'display_product_price_including_taxes' => 'Afișați prețul produsului incluzând taxele?',
        'display_tax_description' => 'Afișați informațiile despre taxe la prețul produsului?',
        'display_tax_description_help' => 'Afișați text precum "(Include X% TVA)" sau "(Exclude X% TVA)" lângă prețurile produselor pe pagina de detalii a produsului.',
        'tax_included_in_products_price' => 'Taxa inclusă în prețul produselor',
        'tax_included_in_products_price_description' => 'Taxa va fi inclusă în prețul produselor',
        'tax_setting' => 'Setări taxe',
        'tax_setting_description' => 'Configurați setările de taxe',
        'tax_management' => 'Gestionare taxe',
        'tax_management_description' => 'Vizualizați și gestionați taxele',
        'form' => [
            'enable_tax' => 'Activați taxele',
            'display_company_invoice_information_fields_at_checkout_page' => 'Afișați câmpurile informațiilor facturii companiei la pagina de finalizare',
            'display_company_invoice_information_fields_at_checkout_page_helper' => 'Dacă este activat, câmpurile de informații ale facturii companiei vor fi afișate la pagina de finalizare. Este necesar să completați câmpurile de informații ale facturii companiei.',
            'default_tax_rate' => 'Rată implicită de taxe',
            'default_tax_rate_description' => 'Important: se va aplica dacă nu este selectată nicio taxă în produs.',
            'select_tax' => '-- Selectați --',
            'display_product_price_including_taxes' => 'Adăugați taxa la prețurile afișate',
            'display_product_price_including_taxes_helper' => 'Adaugă automat taxa la prețurile produselor din magazin. Ex.: un produs de $100 cu 10% taxă este afișat ca $110. Nu este necesar dacă "Prețul include taxa" este deja activat pe produsele individuale.',
            'display_checkout_tax_information' => 'Display tax information under each item at checkout',
            'display_checkout_tax_information_helper' => 'Show the tax breakdown text (e.g., "VAT 10%") next to each item on the checkout page.',
        ],
    ],
    'customer' => [
        'name' => 'Clienți',
        'description' => 'Înregistrare, verificare email, opțiuni autentificare, ștergere cont și câmpuri profil',
        'customer_setting' => 'Setări clienți',
        'customer_setting_description' => 'Configurați setările clienților',
        'form' => [
            'enable_customer_registration' => 'Activați înregistrarea clienților',
            'enable_customer_registration_helper' => 'Dacă este dezactivat, clienții nu vor putea înregistra conturi noi. Clienții existenți pot totuși să se autentifice.',
            'verify_customer_email' => 'Verificați emailul clientului',
            'verify_customer_email_helper' => 'Când este activat, un link de verificare va fi trimis la emailul clientului, clienții trebuie să facă click pe acest link pentru a-și verifica emailul înainte de a se putea autentifica. Este necesar să configurați emailul în Admin -> Setări -> Email pentru a trimite emailul de verificare.',
            'verification_expire_minutes' => 'Timpul de expirare al linkului de verificare',
            'verification_expire_minutes_helper' => 'Timpul în minute în care linkul de verificare email va fi valid. Implicit este 60 minute (1 oră). Maxim este 10080 minute (7 zile).',
            'login_using_phone' => 'Autentificați-vă cu numărul de telefon în loc de email',
            'login_option' => 'Opțiune autentificare',
            'login_with_email' => 'Autentificare cu email',
            'login_with_phone' => 'Autentificare cu telefon',
            'login_with_email_or_phone' => 'Autentificare cu email sau telefon',
            'enabled_customer_account_deletion' => 'Activați ștergerea contului de client',
            'enabled_customer_account_deletion_helper' => 'Când este activat, clienții pot șterge contul în tabloul de bord al clientului → Setări cont.',
            'enabled_customer_dob_field' => 'Activați câmpul data nașterii clientului',
            'enabled_customer_dob_field_helper' => 'Când este activat, clienții pot introduce data nașterii în tabloul de bord al clientului → Setări cont.',
            'enabled_phone_field_in_registration_form' => 'Activați câmpul telefon în formularul de înregistrare',
            'enabled_phone_field_in_registration_form_helper' => 'Când este activat, câmpul telefon va fi adăugat la formularul de înregistrare.',
            'make_customer_phone_number_required' => 'Faceți numărul de telefon al clientului obligatoriu',
            'make_customer_phone_number_required_helper' => 'Când este activat, clienții trebuie să introducă numărul de telefon în timpul înregistrării. Este întotdeauna necesar pentru clienții care se autentifică cu un număr de telefon.',
            'default_avatar' => 'Avatar implicit',
            'default_avatar_helper' => 'Avatar implicit pentru client când nu au un avatar. Dacă nu selectați nicio imagine, va fi generat folosind logo-ul sau primul caracter al numelui clientului.',
            'keep_email_field_in_registration_form' => 'Păstrați câmpul email în formularul de înregistrare',
            'keep_email_field_in_registration_form_helper' => 'Când este dezactivat, câmpul email va fi ascuns în formularul de înregistrare când opțiunea de autentificare este "Autentificare cu telefon".',
        ],
    ],
    'shipping' => [
        'name' => 'Transport',
        'description' => 'Reguli livrare, comportament livrare gratuită și ordine afișare opțiuni livrare',
        'shipping_rule' => 'Reguli transport',
        'shipping_rule_description' => 'Configurați reguli pentru calcularea taxei de transport',
        'shipping_setting' => 'Setări transport',
        'shipping_setting_description' => 'Configurați setările de transport',
        'form' => [
            'hide_other_shipping_options_if_it_has_free_shipping' => 'Ascundeți alte opțiuni de transport dacă există transport gratuit în listă',
            'disable_shipping_options' => 'Dezactivați opțiunile de transport',
            'disable_shipping_options_helper' => 'Opțiunile de transport vor fi eliminate la pagina de finalizare, clientul nu va putea selecta opțiuni de transport.',
            'sort_shipping_options_direction' => 'Direcție sortare opțiuni transport',
            'sort_shipping_options_direction_helper' => 'Sortați opțiunile de transport după preț de la mic la mare sau de la mare la mic.',
            'price_lower_to_higher' => 'Preț de la mic la mare',
            'price_higher_to_lower' => 'Preț de la mare la mic',
        ],
    ],
    'webhook' => [
        'name' => 'Webhook',
        'description' => 'Configurați setările webhook',
        'webhook_setting' => 'Webhook',
        'webhook_setting_description' => 'Configurați URL-uri webhook pentru a primi notificări pentru diverse evenimente de comandă',
        'form' => [
            'order_placed_webhook_url' => 'URL webhook comandă plasată (metodă: POST)',
            'order_placed_webhook_url_placeholder' => 'https://...',
            'order_placed_webhook_url_helper' => 'Pentru a primi notificări când o comandă este plasată, puteți configura un URL webhook extern. Dacă aveți un URL webhook extern, puteți introduce acest URL, sau lăsați-l gol.',
            'order_updated_webhook_url' => 'URL webhook comandă actualizată (metodă: POST)',
            'order_updated_webhook_url_placeholder' => 'https://...',
            'order_updated_webhook_url_helper' => 'Pentru a primi notificări când o comandă este actualizată, puteți configura un URL webhook extern. Aceasta include schimbări de status, actualizări de adrese și alte modificări ale comenzii.',
            'shipping_status_updated_webhook_url' => 'URL webhook status livrare actualizat (metodă: POST)',
            'shipping_status_updated_webhook_url_placeholder' => 'https://...',
            'shipping_status_updated_webhook_url_helper' => 'Pentru a primi notificări când statusul livrării se schimbă (ex: expediat, livrat, anulat), puteți configura un URL webhook extern.',
            'order_completed_webhook_url' => 'URL webhook comandă finalizată (metodă: POST)',
            'order_completed_webhook_url_placeholder' => 'https://...',
            'order_completed_webhook_url_helper' => 'Pentru a primi notificări când o comandă este finalizată, puteți configura un URL webhook extern.',
            'order_cancelled_webhook_url' => 'URL webhook comandă anulată (metodă: POST)',
            'order_cancelled_webhook_url_placeholder' => 'https://...',
            'order_cancelled_webhook_url_helper' => 'Pentru a primi notificări când o comandă este anulată, puteți configura un URL webhook extern.',
            'payment_status_updated_webhook_url' => 'URL webhook status plată actualizat (metodă: POST)',
            'payment_status_updated_webhook_url_placeholder' => 'https://...',
            'payment_status_updated_webhook_url_helper' => 'Pentru a primi notificări când statusul plății se schimbă (ex: plătit, eșuat, rambursat), puteți configura un URL webhook extern.',
            'abandoned_cart_webhook_url' => 'URL webhook coș abandonat (metodă: POST)',
            'abandoned_cart_webhook_url_placeholder' => 'https://...',
            'abandoned_cart_webhook_url_helper' => 'Pentru a primi notificări când coșurile sunt abandonate și pentru a urmări clienții, puteți configura un URL webhook extern. Notificările sunt trimise după o perioadă de timp configurabilă.',
        ],
        'test_button' => 'Testați Webhook',
        'test_success' => 'Test webhook reușit! Endpoint-ul a răspuns corect.',
        'test_failed' => 'Testul webhook a eșuat. Endpoint-ul nu a răspuns conform așteptărilor.',
        'test_error' => 'Eroare test webhook: :error',
        'please_enter_url' => 'Vă rugăm introduceți mai întâi un URL webhook',
        'testing' => 'Se testează...',
        'test_failed_title' => 'Testul a eșuat!',
        'test_success_title' => 'Test Reușit!',
        'status_code' => 'Cod Status',
        'error_occurred' => 'A apărut o eroare la testarea webhook-ului',
    ],
    'store_locator' => [
        'name' => 'Localizatoare magazin',
        'description' => 'Vizualizați și actualizați listele lanțurilor dumneavoastră',
        'store_locator_description' => 'Toate listele lanțurilor, magazinelor principale, sucursalelor, etc. Locațiile pot fi folosite pentru urmărirea vânzărilor și pentru a ne ajuta să configurăm ratele de taxe de aplicat la vânzarea produselor.',
        'form' => [
            'change_primary_store' => 'schimbați localizatorul magazinului implicit',
            'add_location' => 'Adaugă locație',
            'edit_location' => 'Editează locația',
            'delete_location' => 'Șterge locația',
            'delete_location_confirmation' => 'Sigur doriți să ștergeți această locație? Această acțiune nu poate fi anulată.',
            'change_primary_location' => 'Schimbați locația principală',
            'save_location' => 'Salvați locația',
            'add_new' => 'Adaugă nou',
        ],
            'info' => [
            'title' => 'Cum funcționează localizatoarele de magazine',
            'primary_store' => 'Adresa magazinului principal apare pe facturi și este utilizată ca adresă de returnare implicită pentru etichetele de expediere.',
            'shipping_location' => 'Magazinele marcate ca "locație de expediere" pot fi selectate ca depozit de origine la crearea livrărilor.',
            'shipment_selection' => 'La procesarea comenzilor, puteți alege din ce depozit să expediați pe baza stocului și a locației clientului.',
        ],
    ],
    'tracking' => [
        'name' => 'Urmărire',
        'description' => 'Facebook Pixel, evenimente Google Tag Manager și urmărire conversii Google Ads',
        'manage_tracking' => 'Gestionare urmărire',
        'manage_tracking_description' => 'Gestionare urmărire: UTM, Facebook, Google Tag Manager...',
        'form' => [
            'enable_facebook_pixel' => 'Activați Facebook Pixel (Meta Pixel)',
            'facebook_pixel_helper' => 'Mergeți la https://developers.facebook.com/docs/meta-pixel pentru a crea Facebook Pixel. Asigurați-vă că pixelul dumneavoastră este activ și configurat corect.',
            'facebook_pixel_id' => 'ID Facebook Pixel',
            'facebook_pixel_id_placeholder' => 'Exemplu: 1234567890123456',
            'facebook_pixel_debug_mode' => 'Activați Modul Debug Facebook Pixel',
            'facebook_pixel_debug_mode_helper' => 'Activați modul debug pentru a înregistra evenimentele Facebook Pixel în consola browserului și pentru a depana problemele de urmărire',
            'enable_google_tag_manager_tracking_events' => 'Activați Evenimente de Urmărire Google Tag Manager',
            'google_tag_manager_tracking_info' => 'Când este activat, evenimentele de e-commerce vor fi urmărite prin Google Tag Manager. Asigurați-vă că ați configurat Google Tag Manager mai sus.',
            'google_ads_conversion_id' => 'ID Conversie Google Ads',
            'google_ads_conversion_id_helper' => 'Introduceți ID-ul de conversie Google Ads (format: AW-123456789/AbC-D_efG-h1_ijk-lmN) pentru a urmări conversiile de achiziție pe pagina de mulțumire.',
        ],
        'validation' => [
            'facebook_pixel_id_format' => 'ID-ul Facebook Pixel trebuie să fie 15-16 cifre (ex: 1234567890123456)',
        ],
    ],
    'marketplace' => [
        'name' => 'Marketplace',
        'description' => 'Setări multi-vendor, comisioane, înregistrare vânzători și configurare plăți',
    ],
    'standard_and_format' => [
        'name' => 'Standard & Format',
        'panel_description' => 'Format cod comandă, unități greutate (kg/lb) și unități dimensiune (cm/inch)',
        'description' => 'Standardele și formatele sunt folosite pentru a calcula lucruri precum prețurile produselor, greutățile de transport și timpii de comandă.',
        'form' => [
            'change_order_format' => 'Editați formatul codului comenzii (opțional)',
            'change_order_format_description' => 'Codul implicit al comenzii începe la: număr. Puteți schimba șirul de început sau sfârșit pentru a crea codul de comandă dorit, de exemplu "DH-: număr" sau ": număr-A"',
            'start_with' => 'Începe cu',
            'end_with' => 'Se termină cu',
            'order_will_be_shown' => 'Codul comenzii va fi afișat',
            'weight_unit' => 'Unitate de greutate',
            'height_unit' => 'Unitate lungime / înălțime',
            'weight_unit_gram' => 'Gram (g)',
            'weight_unit_kilogram' => 'Kilogram (kg)',
            'weight_unit_lb' => 'Liră (lb)',
            'weight_unit_oz' => 'Uncie (oz)',
            'height_unit_cm' => 'Centimetru (cm)',
            'height_unit_m' => 'Metru (m)',
            'height_unit_inch' => 'Inch',
        ],
    ],
    'sale_popup' => [
        'name' => 'Popup Vânzare',
        'description' => 'Personalizați setările popup-ului de vânzare cu ușurință',
    ],
    'flash_sale' => [
        'name' => 'Vânzare Flash',
        'description' => 'Configurați setările de vânzare flash pentru a oferi reduceri promoționale limitate în timp',
        'enable' => 'Activați funcționalitatea de vânzare flash',
        'enable_helper' => 'Când este activat, puteți crea și gestiona vânzări flash cu prețuri speciale reduse pentru o perioadă limitată de timp.',
        'show_sale_count_left' => 'Afișați urmărirea stocului',
        'show_sale_count_left_description' => 'Afișați o bară de progres cu "X vândute din Y" pentru a crea urgență și a încuraja achiziții rapide în timpul vânzărilor flash.',
    ],
    'payment_method_cod_minimum_amount' => 'Suma minimă a comenzii - :currency (Opțional)',
    'payment_method_cod_minimum_amount_helper' => 'Set the minimum order amount required to use COD payment method. Leave it as 0 or empty if you don\'t want to set a minimum.',
    'payment_method_cod_maximum_amount' => 'Maximum order amount - :currency (Optional)',
    'payment_method_cod_maximum_amount_helper' => 'Set the maximum order amount allowed for COD payment method. Leave it as 0 or empty if you don\'t want to set a maximum.',
    'payment_method_minimum_amount' => 'Suma minimă a comenzii - :currency (Opțional)',
    'payment_method_minimum_amount_helper' => 'Set the minimum order amount required to use this payment method. Leave it as 0 or empty if you don\'t want to set a minimum.',
    'payment_method_maximum_amount' => 'Maximum order amount - :currency (Optional)',
    'payment_method_maximum_amount_helper' => 'Set the maximum order amount allowed for this payment method. Leave it as 0 or empty if you don\'t want to set a maximum.',
    'payment_method_maximum_amount_error' => 'Maximum order amount to use :payment_method payment method is :amount, you need to remove :more to place an order!',
    'display_bank_info_at_the_checkout_success_page' => 'Afișați informațiile bancare pe pagina de succes finalizare?',
    'invoice_templates' => 'Șabloane facturi',

    'abandoned_cart' => [
        'name' => 'Giỏ hàng bị bỏ rơi',
        'description' => 'Khôi phục doanh số bị mất bằng cách gửi lời nhắc tự động cho khách hàng để lại sản phẩm trong giỏ',
        'panel_description' => 'Thiết lập lời nhắc tự động cho khách hàng bỏ rơi giỏ hàng',
        'how_it_works' => [
            'title' => 'Cách hoạt động',
            'step1_title' => 'Khách hàng thêm sản phẩm',
            'step1_description' => 'Khách hàng thêm sản phẩm vào giỏ hàng và cung cấp địa chỉ email.',
            'step2_title' => 'Giỏ hàng bị bỏ rơi',
            'step2_description' => 'Nếu không có giao dịch mua trong ngưỡng thời gian đã đặt, giỏ hàng được đánh dấu là bị bỏ rơi.',
            'step3_title' => 'Gửi email nhắc nhở',
            'step3_description' => 'Email nhắc nhở tự động được gửi để khuyến khích khách hàng hoàn tất việc mua hàng.',
            'step4_title' => 'Khôi phục doanh số',
            'step4_description' => 'Khách hàng quay lại hoàn tất đơn hàng và giỏ hàng được đánh dấu là đã khôi phục.',
        ],
        'form' => [
            'enable' => 'Bật theo dõi giỏ hàng bị bỏ rơi',
            'enable_helper' => 'Khi được bật, hệ thống sẽ theo dõi giỏ hàng bị bỏ rơi và cho phép bạn gửi email khôi phục cho khách hàng.',
            'timing_section' => 'Cài đặt thời gian',
            'email_section' => 'Cài đặt email nhắc nhở',
            'cleanup_section' => 'Dọn dẹp dữ liệu',
            'time_threshold' => 'Ngưỡng thời gian (giờ)',
            'time_threshold_helper' => 'Giỏ hàng được coi là bị bỏ rơi sau số giờ không hoạt động này. Khuyến nghị: 1-24 giờ.',
            'send_email' => 'Gửi email khôi phục',
            'send_email_helper' => 'Tự động gửi email khôi phục cho khách hàng có giỏ hàng bị bỏ rơi.',
            'max_reminders' => 'Số lượng email nhắc nhở',
            'max_reminders_helper' => 'Số lượng email nhắc nhở gửi cho mỗi giỏ hàng bị bỏ rơi. Mỗi email có thể được tùy chỉnh trong Mẫu Email.',
            'email_delay' => 'Gửi sau (giờ)',
            'email_discount' => 'Giảm giá (%)',
            'email_1_title' => 'Email #1 - Nhắc nhở thân thiện',
            'email_1_description' => 'Lời nhắc nhẹ nhàng đầu tiên để khuyến khích khách hàng quay lại.',
            'email_1_delay_helper' => 'Số giờ sau khi giỏ hàng bị bỏ rơi để gửi email đầu tiên. Khuyến nghị: 1-2 giờ.',
            'email_2_title' => 'Email #2 - Kèm ưu đãi',
            'email_2_description' => 'Lời nhắc thứ hai với ưu đãi giảm giá để thúc đẩy mua hàng.',
            'email_2_delay_helper' => 'Số giờ sau khi giỏ hàng bị bỏ rơi để gửi email thứ hai. Khuyến nghị: 24 giờ.',
            'email_2_discount_helper' => 'Phần trăm giảm giá để cung cấp trong email này. Đặt 0 nếu không giảm giá.',
            'email_3_title' => 'Email #3 - Cơ hội cuối',
            'email_3_description' => 'Lời nhắc cuối cùng với tính cấp bách và ưu đãi tốt nhất để chốt đơn.',
            'email_3_delay_helper' => 'Số giờ sau khi giỏ hàng bị bỏ rơi để gửi email cuối cùng. Khuyến nghị: 72 giờ.',
            'email_3_discount_helper' => 'Phần trăm giảm giá cuối cùng. Thường cao hơn email #2.',
            'cleanup_days' => 'Dọn dẹp sau (ngày)',
            'cleanup_days_helper' => 'Tự động xóa bản ghi giỏ hàng bị bỏ rơi cũ hơn số ngày này.',
            'cronjob_not_setup' => '<strong>Cronjob chưa được cấu hình!</strong> Nhắc nhở giỏ hàng bị bỏ rơi yêu cầu cronjob được cấu hình đúng để hoạt động. <a href=":url">Thiết lập cronjob ngay</a>.',
            'cronjob_not_running' => '<strong>Cronjob không chạy!</strong> Cronjob dường như đã dừng. Vui lòng kiểm tra cấu hình máy chủ của bạn. <a href=":url">Xem trạng thái cronjob</a>.',
            'cronjob_working' => '<strong>Cronjob đang chạy đúng!</strong> Hoạt động cuối: :time. Nhắc nhở giỏ hàng bị bỏ rơi của bạn sẽ được xử lý tự động.',
            'email_setup_warning' => '<strong>Quan trọng:</strong> Đảm bảo cài đặt email của bạn được cấu hình đúng trong <a href=":url">Cài đặt → Email</a>. Gửi email test để xác minh mọi thứ hoạt động trước khi bật tính năng này.',
        ],
    ],
];
