<?php

return [
    'name' => 'Standorte',
    'all_states' => 'Alle Staaten',
    'abbreviation' => 'Abkürzung',
    'abbreviation_placeholder' => 'Z.: Ca',
    'import_type' => [
        'country' => 'Land',
        'state' => 'Bundesland',
        'city' => 'Stadt',
    ],
    'enums' => [
        'import_type' => [
            'country' => 'Land',
            'state' => 'Zustand',
            'city' => 'Stadt',
        ],
    ],
    'export' => [
        'total' => 'Gesamtstandorte',
        'total_countries' => 'Gesamtländer',
        'total_states' => 'Gesamtbundesländer',
        'total_cities' => 'Gesamtstädte',
        'description' => 'Exportieren Sie Ihre Standortdaten wie Länder, Bundesländer und Städte.',
        'import_type' => 'Standorttyp',
        'all_types' => 'Alle Typen',
        'all_status' => 'Alle Status',
        'use_chunked_export' => 'Chunked-Export verwenden',
        'use_chunked_export_helper' => 'Daten in kleineren Stapeln verarbeiten, um Speicherprobleme bei großen Datensätzen zu vermeiden.',
        'optimize_memory' => 'Speichernutzung optimieren',
        'optimize_memory_helper' => 'Nur notwendige Spalten laden und Speicher während des Exports regelmäßig freigeben.',
        'use_streaming' => 'Streaming-Modus verwenden',
        'use_streaming_helper' => 'Daten direkt in Datei streamen, ohne alles in den Speicher zu laden. Empfohlen für sehr große Datensätze.',
        'streaming_enabled_title' => 'Streaming-Modus aktiviert',
        'streaming_enabled_message' => 'Daten werden zur optimalen Speichernutzung direkt in die Datei gestreamt.',
        'chunk_size' => 'Chunk-Größe',
        'chunk_size_helper' => 'Anzahl der Datensätze, die in jedem Stapel verarbeitet werden sollen. Niedrigere Werte verwenden weniger Speicher, dauern aber länger.',
        'recommended_range' => 'Empfohlener Bereich',
        'optimal_range' => 'Optimal',
        'too_small_slow' => 'Zu klein (langsamer)',
        'too_large_timeouts' => 'Zu groß (kann Zeitüberschreitung verursachen)',
        'range_large_export' => '150-300 Datensätze',
        'range_medium_export' => '200-500 Datensätze',
        'range_small_export' => '300-700 Datensätze',
        'large_dataset_title' => 'Großer Datensatz erkannt',
        'large_dataset_message' => 'Optimierter Exportmodus wurde automatisch für bessere Leistung aktiviert.',
        'large_dataset_warning_title' => 'Empfehlungen für Export großer Datensätze',
        'large_dataset_specific_message' => 'Sie exportieren :count Standorte. Für optimale Leistung empfehlen wir die Verwendung des CSV-Formats mit Chunked-Export.',
        'format_label' => 'Format',
        'csv_recommended' => 'CSV (Empfohlen)',
        'chunk_label' => 'Chunk-Größe',
        'chunk_recommended' => '150-300 Datensätze',
        'time_label' => 'Geschätzte Zeit',
        'time_estimate' => '2-5 Minuten',
        'pro_tip' => 'Profi-Tipp:',
        'pro_tip_message' => 'Sie können nach Standorttyp (Land/Bundesland/Stadt) filtern, um spezifische Daten zu exportieren.',
        'medium_dataset_detected' => 'Mittlerer Datensatz erkannt',
        'medium_dataset_message' => 'Exportiere :count Standorte. Der Export sollte innerhalb von 1-2 Minuten abgeschlossen sein.',
        'excel_disabled_warning' => 'Excel-Format wird für große Datensätze (:count+ Datensätze) nicht empfohlen. Verwenden Sie stattdessen CSV.',
    ],
    'import' => [
        'description' => 'Importieren Sie Standortdaten einfach aus verfügbaren Daten oder durch Hochladen einer CSV/Excel -Datei.',
        'rules' => [
            'name' => 'Der Name des Standorts ist obligatorisch und sollte 120 Zeichen nicht überschreiten.',
            'slug' => 'Die Schnecke des Standorts sollte, falls vorgesehen, 120 Zeichen nicht überschreiten.',
            'import_type' => 'Die Art des Imports ist obligatorisch und sollte einer der vordefinierten Werte sein.',
            'order' => 'Die Reihenfolge des Standorts sollte, falls vorgesehen, eine positive Ganzzahl zwischen 0 und 127 sein.',
            'abbreviation' => 'Die Abkürzung des Standorts sollte, falls vorgesehen, 10 Zeichen nicht überschreiten.',
            'status' => 'Der Status des Standorts ist obligatorisch und sollte einer der vordefinierten Werte sein.',
            'country' => 'Das Landfeld ist obligatorisch, wenn der Importtyp staatlich oder Stadt ist.',
            'state' => 'Das staatliche Feld ist obligatorisch, wenn der Importtyp Stadt ist.',
            'nationality' => 'Die Nationalität des Standorts sollte, falls vorgesehen, 120 Zeichen nicht überschreiten.',
        ],
    ],
];
