<?php

return [
    'name' => 'Lokasjoner',
    'all_states' => 'Alle stater',
    'abbreviation' => 'Forkortelse',
    'abbreviation_placeholder' => 'E.g: CA',
    'import_type' => [
        'country' => 'Land',
        'state' => 'Stat',
        'city' => 'By',
    ],
    'enums' => [
        'import_type' => [
            'country' => 'Land',
            'state' => 'Stat',
            'city' => 'By',
        ],
    ],
    'export' => [
        'total' => 'Totalt antall lokasjoner',
        'total_countries' => 'Totalt antall land',
        'total_states' => 'Totalt antall stater',
        'total_cities' => 'Totalt antall byer',
        'description' => 'Eksporter dine lokasjonsdata som land, stater og byer.',
        'import_type' => 'Lokasjonstype',
        'all_types' => 'Alle typer',
        'all_status' => 'Alle statuser',
        'use_chunked_export' => 'Bruk chunked eksport',
        'use_chunked_export_helper' => 'Behandle data i mindre grupper for å unngå minneproblemer med store datasett.',
        'optimize_memory' => 'Optimaliser minnebruk',
        'optimize_memory_helper' => 'Last kun nødvendige kolonner og frigjør minne periodisk under eksport.',
        'use_streaming' => 'Bruk streaming-modus',
        'use_streaming_helper' => 'Stream data direkte til fil uten å laste alt inn i minnet. Anbefalt for svært store datasett.',
        'streaming_enabled_title' => 'Streaming-modus aktivert',
        'streaming_enabled_message' => 'Data vil bli strømmet direkte til filen for optimal minnebruk.',
        'chunk_size' => 'Batchstørrelse',
        'chunk_size_helper' => 'Antall poster som skal behandles i hver batch. Lavere verdier bruker mindre minne men tar lengre tid.',
        'recommended_range' => 'Anbefalt område',
        'optimal_range' => 'Optimal',
        'too_small_slow' => 'For liten (tregere)',
        'too_large_timeouts' => 'For stor (kan time ut)',
        'range_large_export' => '150-300 poster',
        'range_medium_export' => '200-500 poster',
        'range_small_export' => '300-700 poster',
        'large_dataset_title' => 'Stort datasett oppdaget',
        'large_dataset_message' => 'Optimalisert eksportmodus automatisk aktivert for bedre ytelse.',
        'large_dataset_warning_title' => 'Anbefalinger for Stort Datasett Eksport',
        'large_dataset_specific_message' => 'Du eksporterer :count lokasjoner. For optimal ytelse anbefaler vi å bruke CSV-format med chunked eksport.',
        'format_label' => 'Format',
        'csv_recommended' => 'CSV (Anbefalt)',
        'chunk_label' => 'Batchstørrelse',
        'chunk_recommended' => '150-300 poster',
        'time_label' => 'Estimert Tid',
        'time_estimate' => '2-5 minutter',
        'pro_tip' => 'Pro Tips:',
        'pro_tip_message' => 'Du kan filtrere etter lokasjonstype (land/stat/by) for å eksportere spesifikke data.',
        'medium_dataset_detected' => 'Middels datasett oppdaget',
        'medium_dataset_message' => 'Eksporterer :count lokasjoner. Eksporten bør fullføres innen 1-2 minutter.',
        'excel_disabled_warning' => 'Excel-format anbefales ikke for store datasett (:count+ poster). Bruk CSV i stedet.',
    ],
    'import' => [
        'description' => 'Importer lokasjonsdata enkelt fra tilgjengelige data eller ved å laste opp en CSV/Excel-fil.',
        'rules' => [
            'name' => 'Navnet på lokasjonen er obligatorisk og bør ikke overskride 120 tegn.',
            'slug' => 'Sluggen til lokasjonen, hvis oppgitt, bør ikke overskride 120 tegn.',
            'import_type' => 'Importtypen er obligatorisk og bør være en av de forhåndsdefinerte verdiene.',
            'order' => 'Rekkefølgen til lokasjonen, hvis oppgitt, bør være et positivt heltall mellom 0 og 127.',
            'abbreviation' => 'Forkortelsen til lokasjonen, hvis oppgitt, bør ikke overskride 10 tegn.',
            'status' => 'Statusen til lokasjonen er obligatorisk og bør være en av de forhåndsdefinerte verdiene.',
            'country' => 'Landfeltet er obligatorisk hvis importtypen er stat eller by.',
            'state' => 'Statfeltet er obligatorisk hvis importtypen er by.',
            'nationality' => 'Nasjonaliteten til lokasjonen, hvis oppgitt, bør ikke overskride 120 tegn.',
        ],
    ],
];
