<?php

return [
    'name' => 'Месторасположение',
    'all_states' => 'Все штаты',
    'abbreviation' => 'Аббревиатура',
    'abbreviation_placeholder' => 'Например: CA',
    'import_type' => [
        'country' => 'Страна',
        'state' => 'Штат',
        'city' => 'Город',
    ],
    'enums' => [
        'import_type' => [
            'country' => 'Страна',
            'state' => 'Штат',
            'city' => 'Город',
        ],
    ],
    'export' => [
        'total' => 'Всего местоположений',
        'total_countries' => 'Всего стран',
        'total_states' => 'Всего регионов',
        'total_cities' => 'Всего городов',
        'description' => 'Экспортируйте данные о местоположении, такие как страны, штаты и города.',
        'import_type' => 'Тип местоположения',
        'all_types' => 'Все типы',
        'all_status' => 'Все статусы',
        'use_chunked_export' => 'Использовать фрагментированный экспорт',
        'use_chunked_export_helper' => 'Обрабатывайте данные небольшими партиями, чтобы избежать проблем с памятью при больших наборах данных.',
        'optimize_memory' => 'Оптимизировать использование памяти',
        'optimize_memory_helper' => 'Загружайте только необходимые столбцы и периодически освобождайте память во время экспорта.',
        'use_streaming' => 'Использовать режим потоковой передачи',
        'use_streaming_helper' => 'Передавайте данные непосредственно в файл без загрузки всего в память. Рекомендуется для очень больших наборов данных.',
        'streaming_enabled_title' => 'Режим потоковой передачи включен',
        'streaming_enabled_message' => 'Данные будут передаваться непосредственно в файл для оптимального использования памяти.',
        'chunk_size' => 'Размер партии',
        'chunk_size_helper' => 'Количество записей для обработки в каждой партии. Более низкие значения используют меньше памяти, но занимают больше времени.',
        'recommended_range' => 'Рекомендуемый диапазон',
        'optimal_range' => 'Оптимальный',
        'too_small_slow' => 'Слишком мало (медленнее)',
        'too_large_timeouts' => 'Слишком много (может истечь время ожидания)',
        'range_large_export' => '150-300 записей',
        'range_medium_export' => '200-500 записей',
        'range_small_export' => '300-700 записей',
        'large_dataset_title' => 'Обнаружен большой набор данных',
        'large_dataset_message' => 'Оптимизированный режим экспорта автоматически включен для лучшей производительности.',
        'large_dataset_warning_title' => 'Рекомендации по экспорту большого набора данных',
        'large_dataset_specific_message' => 'Вы экспортируете :count местоположений. Для оптимальной производительности мы рекомендуем использовать формат CSV с фрагментированным экспортом.',
        'format_label' => 'Формат',
        'csv_recommended' => 'CSV (Рекомендуется)',
        'chunk_label' => 'Размер партии',
        'chunk_recommended' => '150-300 записей',
        'time_label' => 'Приблизительное время',
        'time_estimate' => '2-5 минут',
        'pro_tip' => 'Совет профессионала:',
        'pro_tip_message' => 'Вы можете фильтровать по типу местоположения (страна/штат/город) для экспорта конкретных данных.',
        'medium_dataset_detected' => 'Обнаружен средний набор данных',
        'medium_dataset_message' => 'Экспорт :count местоположений. Экспорт должен завершиться в течение 1-2 минут.',
        'excel_disabled_warning' => 'Формат Excel не рекомендуется для больших наборов данных (:count+ записей). Используйте CSV вместо этого.',
    ],
    'import' => [
        'description' => 'Легко импортируйте данные о местоположении из доступных данных или загрузив файл CSV/Excel.',
        'rules' => [
            'name' => 'Название местоположения обязательно и не должно превышать 120 символов.',
            'slug' => 'Slug местоположения, если указан, не должен превышать 120 символов.',
            'import_type' => 'Тип импорта обязателен и должен быть одним из предопределенных значений.',
            'order' => 'Порядок местоположения, если указан, должен быть положительным целым числом от 0 до 127.',
            'abbreviation' => 'Аббревиатура местоположения, если указана, не должна превышать 10 символов.',
            'status' => 'Статус местоположения обязателен и должен быть одним из предопределенных значений.',
            'country' => 'Поле страны обязательно, если тип импорта - штат или город.',
            'state' => 'Поле штата обязательно, если тип импорта - город.',
            'nationality' => 'Национальность местоположения, если указана, не должна превышать 120 символов.',
        ],
    ],
];
