<?php

return [
    'name' => 'Platser',
    'all_states' => 'Alla delstater',
    'abbreviation' => 'Förkortning',
    'abbreviation_placeholder' => 'E.g: CA',
    'enums' => [
        'import_type' => [
            'country' => 'Land',
            'state' => 'Delstat',
            'city' => 'Stad',
        ],
    ],
    'export' => [
        'total' => 'Totalt antal platser',
        'total_countries' => 'Totalt antal länder',
        'total_states' => 'Totalt antal delstater',
        'total_cities' => 'Totalt antal städer',
        'description' => 'Exportera dina platsdata som länder, delstater och städer.',
        'import_type' => 'Importtyp',
        'all_types' => 'Alla typer',
        'all_status' => 'Alla statusar',
        'use_chunked_export' => 'Använd segmenterad export',
        'use_chunked_export_helper' => 'Bearbetar data i bitar för större exportfiler. Rekommenderas för datamängder som överstiger 1 000 poster.',
        'optimize_memory' => 'Optimera minnesanvändning',
        'optimize_memory_helper' => 'Minskar minnesanvändningen genom bearbetning i steg. Rekommenderas för begränsad serverminne.',
        'use_streaming' => 'Använd streaming',
        'use_streaming_helper' => 'Skriver data direkt till fil istället för att lagra i minnet. Bäst för mycket stora exporter.',
        'streaming_enabled_title' => 'Streaming aktiverad',
        'streaming_enabled_message' => 'Data kommer att streamas direkt till filen för optimal effektivitet.',
        'chunk_size' => 'Bitstorlek',
        'chunk_size_helper' => 'Antal rader som bearbetas åt gången. Mindre värden använder mindre minne men kan göra exporten långsammare.',
        'recommended_range' => 'Rekommenderat intervall',
        'optimal_range' => 'Optimalt intervall',
        'too_small_slow' => 'För små värden kan göra bearbetningen långsammare',
        'too_large_timeouts' => 'För stora värden kan orsaka timeout',
        'range_large_export' => '500-2000 för stora exporter',
        'range_medium_export' => '200-1000 för medelstora exporter',
        'range_small_export' => '100-500 för små exporter',
        'large_dataset_title' => 'Stor datamängd upptäckt',
        'large_dataset_message' => 'På grund av dina datas storlek kan exporten ta en stund. Detta är en normal process och säkerställer stabilitet.',
        'large_dataset_warning_title' => 'Stor export',
        'large_dataset_specific_message' => 'Du exporterar mer än :count poster. Denna operation kan ta några minuter.',
        'format_label' => 'Format',
        'csv_recommended' => 'CSV (rekommenderas för stora datamängder)',
        'chunk_label' => 'Bitstorlek',
        'chunk_recommended' => ':size rader (rekommenderat)',
        'time_label' => 'Uppskattad tid',
        'time_estimate' => '~:minutes minuter',
        'pro_tip' => 'Proffstips',
        'pro_tip_message' => 'CSV-format erbjuder bättre prestanda och kompatibilitet för stora exporter. Du kan importera det i Excel eller Google Sheets.',
        'medium_dataset_detected' => 'Medelstör datamängd upptäckt',
        'medium_dataset_message' => 'Denna export kan ta några sekunder. För optimal prestanda rekommenderar vi inställningar för segmenterad export.',
        'excel_disabled_warning' => 'Excel-export är inte tillgänglig för datamängder som överstiger :count poster. Vänligen använd CSV-format.',
    ],
    'import' => [
        'description' => 'Importera platsdata enkelt från tillgängliga data eller genom att ladda upp en CSV/Excel-fil.',
        'rules' => [
            'name' => 'Namnet på platsen är obligatoriskt och får inte överstiga 120 tecken.',
            'slug' => 'Slug för platsen, om det anges, får inte överstiga 120 tecken.',
            'import_type' => 'Importtypen är obligatorisk och måste vara ett av de fördefinierade värdena.',
            'order' => 'Ordningen för platsen, om den anges, måste vara ett positivt heltal mellan 0 och 127.',
            'abbreviation' => 'Förkortningen av platsen, om den anges, får inte överstiga 10 tecken.',
            'status' => 'Status för platsen är obligatorisk och måste vara ett av de fördefinierade värdena.',
            'country' => 'Landfältet är obligatoriskt om importtypen är delstat eller stad.',
            'state' => 'Delstatsfältet är obligatoriskt om importtypen är stad.',
            'nationality' => 'Nationaliteten för platsen, om den anges, får inte överstiga 120 tecken.',
        ],
    ],
];
