<?php

return [
    'name' => 'Markkinapaikka',
    'email' => [
        'title' => 'Markkinapaikka',
        'description' => 'Määritä sähköpostimallit markkinapaikalle',
        'store_new_order_title' => 'Ilmoitus uudesta tilauksesta',
        'store_new_order_description' => 'Lähetä sähköposti kaupan omistajalle, kun tilaus tehdään',
        'verify_vendor_title' => 'Vahvista myyjä',
        'verify_vendor_description' => 'Lähetä sähköposti ylläpitäjälle, kun myyjä rekisteröityy',
        'pending_product_approval_title' => 'Odottaa tuotteen hyväksyntää',
        'pending_product_approval_description' => 'Lähetä sähköposti ylläpitäjälle, kun myyjä julkaisee tuotteitaan',
        'vendor_account_approved_title' => 'Myyjätili hyväksytty',
        'vendor_account_approved_description' => 'Lähetä sähköposti myyjälle, kun heidän tilinsä on hyväksytty',
        'product_approved_title' => 'Tuote hyväksytty',
        'product_approved_description' => 'Lähetä sähköposti myyjälle, kun heidän tuotteensa on hyväksytty',
        'withdrawal_approved_title' => 'Nosto hyväksytty',
        'withdrawal_approved_description' => 'Lähetä sähköposti myyjälle, kun heidän nostopyyntönsä on hyväksytty',
        'vendor_account_rejected_title' => 'Myyjätili hylätty',
        'vendor_account_rejected_description' => 'Lähetä sähköposti myyjälle, kun heidän tilinsä on hylätty',
        'vendor_account_unblocked_title' => 'Myyjätilin esto poistettu',
        'vendor_account_unblocked_description' => 'Lähetä sähköposti myyjälle, kun heidän tilinsä esto on poistettu',
        'vendor_account_blocked_title' => 'Myyjätili estetty',
        'vendor_account_blocked_description' => 'Lähetä sähköposti myyjälle, kun heidän tilinsä on estetty',
        'store_new_order_subject' => 'Uusi tilaus sivustolla {{ site_title }}',
        'verify_vendor_subject' => 'Uusi myyjä sivustolla {{ site_title }} odottaa vahvistusta',
        'vendor_account_approved_subject' => 'Tilisi on hyväksytty myyntiin sivustolla {{ site_title }}',
        'vendor_account_rejected_subject' => 'Tilisi on hylätty myyntiin sivustolla {{ site_title }}',
        'pending_product_approval_subject' => 'Uusi tuote odottaa myyntihyväksyntää sivustolla {{ site_title }}',
        'product_approved_subject' => 'Tuotteesi on hyväksytty myyntiin sivustolla {{ site_title }}',
        'withdrawal_approved_subject' => 'Nostopyyntösi on hyväksytty',
        'welcome_vendor_title' => 'Tervetuloa myyjäksi',
        'welcome_vendor_description' => 'Lähetä sähköposti myyjälle rekisteröitymisen jälkeen',
        'welcome_vendor_subject' => 'Tervetuloa sivustolle {{ site_title }}!',
        'contact_store_title' => 'Ota yhteyttä kauppaan',
        'contact_store_description' => 'Lähetä sähköposti kaupan omistajalle, kun asiakas ottaa yhteyttä kauppaan',
        'contact_store_subject' => 'Uusi asiakasyhteydenotto',
        'vendor_account_blocked_subject' => 'Myyjätilisi sivustolla {{ site_title }} on estetty',
        'vendor_account_unblocked_subject' => 'Myyjätilisi sivustolla {{ site_title }} esto on poistettu',
        'order_cancellation_to_vendor_title' => 'Tilauksen peruutus (lähetetään myyjälle)',
        'order_cancellation_to_vendor_description' => 'Lähetä myyjälle, kun asiakas peruuttaa tilauksen',
        'order_cancellation_to_vendor_subject' => 'Asiakas on peruuttanut tilauksen :order_id',
        'store_verified_title' => 'Kaupan vahvistus hyväksytty',
        'store_verified_description' => 'Lähetä ilmoitus, kun kauppa on vahvistettu',
        'store_verified_subject' => 'Kauppasi {{ store_name }} on vahvistettu',
        'store_unverified_title' => 'Kaupan vahvistus poistettu',
        'store_unverified_description' => 'Lähetä ilmoitus, kun kaupan vahvistus poistetaan',
        'store_unverified_subject' => 'Vahvistustila muuttunut kaupalle {{ store_name }}',
        'verified_by' => 'Vahvistanut',
        'verified_at' => 'Vahvistettu',
        'unverified_by' => 'Vahvistuksen poistanut',
        'unverified_at' => 'Vahvistus poistettu',
        'verification_note' => 'Vahvistushuomautus',
        'store' => 'Kauppa',
        'order' => 'Tilaus',
        'shipment' => 'Toimitustiedot',
        'address' => 'Toimitusosoite',
        'products' => 'Tilatut tuotteet',
        'customer_message' => 'Asiakkaan viesti',
        'customer_name' => 'Asiakkaan nimi',
        'customer_email' => 'Asiakkaan sähköposti',
        'block_reason' => 'Eston syy',
        'block_date' => 'Eston päivämäärä',
        'unblock_date' => 'Eston poiston päivämäärä',
    ],
    'email_templates' => [
        'dear_vendor' => 'Hyvä :vendor_name,',
        'dear_admin' => 'Hyvä ylläpitäjä,',
        'hello' => 'Hei,',
        'happy_selling' => 'Onnellisia myyntejä!',
        'email_sent_by_team' => 'Tämän sähköpostin lähetti {{ site_title }} -tiimi.',

        // Contact Store
        'contact_store_sent_from' => 'Tämän sähköpostin lähetti :customer_name (:customer_email) profiilisi yhteydenottolomakkeen kautta sivustolla :site_title.',
        'contact_store_reply_instruction' => 'Voit vastata suoraan tähän sähköpostiin vastataksesi käyttäjälle :customer_name (:customer_email).',

        // Vendor Account Status
        'vendor_account_blocked_message' => 'Myyjätilisi sivustolla {{ site_title }} on <strong>estetty</strong> alkaen :block_date.',
        'vendor_account_blocked_reason' => 'Eston syy: :block_reason',
        'vendor_account_blocked_contact_support' => 'Jos uskot tämän olevan virhe tai sinulla on kysymyksiä, ota yhteyttä tukitiimiimme.',
        'vendor_account_unblocked_message' => 'Ilmoitamme iloksemme, että myyjätilisi sivustolla {{ site_title }} esto on <strong>poistettu</strong> alkaen :unblock_date.',
        'vendor_account_unblocked_resume' => 'Voit nyt käyttää tiliäsi ja jatkaa toimintaasi.',
        'vendor_account_unblocked_questions' => 'Jos sinulla on kysymyksiä, ota rohkeasti yhteyttä tukitiimiimme.',
        'vendor_account_approved_title' => 'Myyjätili hyväksytty',
        'vendor_account_approved_message' => 'Tilisi on hyväksytty myyntiin sivustollamme <a href=":site_url">:site_url</a>.',
        'vendor_account_rejected_title' => 'Myyjätili hylätty',
        'vendor_account_rejected_message' => 'Valitettavasti ilmoitamme, että tiliäsi ei ole hyväksytty myyntiin sivustollamme <a href=":site_url">:site_url</a>.',

        // Store New Order
        'store_new_order_title' => 'Tilaus onnistui!',
        'store_new_order_message' => 'Sait uuden tilauksen sivustolla :site_title!',
        'customer_information' => 'Asiakastiedot',
        'field_name' => 'Nimi',
        'field_phone' => 'Puhelin',
        'field_email' => 'Sähköposti',
        'field_address' => 'Osoite',
        'field_note' => 'Huomautus',
        'order_number' => 'Tilausnumero',
        'order_date' => 'Tilauspäivä',
        'shipping_method' => 'Toimitusmenetelmä',
        'payment_method' => 'Maksutapa',

        // Product Approval
        'product_approved_title' => 'Tuote hyväksytty',
        'product_approved_message' => 'Tuotteesi on hyväksytty myyntiin sivustollamme <a href=":site_url">:site_url</a>.',
        'pending_product_approval_title' => 'Odottaa tuotteen hyväksyntää',
        'pending_product_approval_message' => 'Kaupan :store_name luoma uusi tuote <a href=":product_url">:product_name</a> odottaa hyväksyntää.',

        // Verify Vendor
        'verify_vendor_title' => 'Vahvista myyjä',
        'verify_vendor_message' => 'Sinulla on uusi myyjä, joka odottaa vahvistusta sivustolla :site_title!',
        'vendor_information' => 'Myyjän tiedot',
        'shop_information' => 'Kaupan tiedot',
        'field_store_name' => 'Kaupan nimi',
        'field_store_phone' => 'Kaupan puhelinnumero',
        'visit_store_button' => 'Vieraile kaupassa',

        // Withdrawal
        'withdrawal_approved_title' => 'Nosto hyväksytty',
        'withdrawal_approved_message' => 'Nostopyyntösi on hyväksytty, lähetämme <strong>:withdrawal_amount</strong> pankkitiedoillesi pian.',

        // Order Cancellation
        'order_cancellation_title' => 'Asiakas on peruuttanut tilauksen :order_id',
        'order_cancellation_message' => 'Asiakas :customer_name on peruuttanut tilauksen <strong>:order_id</strong> syystä :cancellation_reason.',
        'order_items_header' => 'Tässä mitä tilattiin:',

        // Welcome Vendor
        'welcome_vendor_title' => 'Tervetuloa myyjäksi',
        'welcome_vendor_greeting' => 'Toivotamme sinut tervetulleeksi kauppaan :store_name!',
        'welcome_vendor_registration_complete' => 'Myyjärekisteröintisi on suoritettu onnistuneesti, ja olet nyt osa eloisan myyjäyhteisömme.',
        'welcome_vendor_next_steps' => 'Seuraavaksi voit tehdä näin:',
        'welcome_vendor_step_login' => 'Kirjaudu myyjätilillesi käyttäjätunnuksillasi.',
        'welcome_vendor_step_add_products' => 'Lisää tuotteesi/palvelusi kauppaasi. Muista antaa yksityiskohtaiset kuvaukset ja houkuttelevat kuvat houkutellaksesi potentiaalisia ostajia.',
        'welcome_vendor_support' => 'Jos sinulla on kysymyksiä tai tarvitset apua, tukitiimimme on täällä auttamassa sinua. Ota rohkeasti yhteyttä!',
        'login_vendor_account_button' => 'Kirjaudu myyjätilille',
        'welcome_vendor_closing' => 'Olemme innoissamme nähdessämme kauppasi kukoistavan sivustolla :site_title!',

        // Store Verification
        'store_verified_title' => 'Kaupan vahvistus hyväksytty',
        'store_verified_message' => 'Onnittelut! Kauppasi on vahvistettu onnistuneesti sivustolla <strong>:site_title</strong>. Tämä vahvistusmerkki auttaa rakentamaan luottamusta asiakkaidesi kanssa.',
        'dear_store_owner' => 'Hyvä kaupan :store_name omistaja,',
        'verification_details' => 'Vahvistuksen tiedot',
        'store_verified_benefits' => 'Vahvistuksen edut',
        'verified_badge_benefit' => 'Vahvistusmerkki näkyy kauppassasi',
        'increased_trust_benefit' => 'Lisääntynyt asiakkaiden luottamus',
        'higher_visibility_benefit' => 'Parempi näkyvyys hakutuloksissa',
        'visit_your_store' => 'Vieraile kaupassasi',
        'congratulations_verified' => 'Onnittelut vahvistuksesta!',

        // Store Unverification
        'store_unverified_title' => 'Kaupan vahvistustila muuttunut',
        'store_unverified_message' => 'Valitettavasti ilmoitamme, että kauppasi vahvistustila sivustolla <strong>:site_title</strong> on muuttunut.',
        'unverification_details' => 'Tilamuutoksen tiedot',
        'store_unverified_impacts' => 'Mitä tämä tarkoittaa',
        'verified_badge_removed' => 'Vahvistusmerkki on poistettu kaupastasi',
        'verification_benefits_lost' => 'Vahvistuksen edut eivät ole enää aktiivisia',
        'store_unverified_next_steps' => 'Jos sinulla on kysymyksiä tästä päätöksestä tai haluaisit keskustella uudelleenvahvistuksesta, <strong>ota yhteyttä tukitiimiimme</strong>.',
        'contact_support' => 'Ota yhteyttä tukeen',
        'thank_you_understanding' => 'Kiitos ymmärryksestäsi.',
    ],
    'current_balance' => 'Nykyinen saldo',
    'settings' => [
        'title' => 'Asetukset',
        'description' => 'Markkinapaikan asetukset',
        'fee_per_order' => 'Maksu per tilaus (%), suositus: 2 tai 3',
        'default_commission_fee' => 'Oletuspalkkio (%), suositus: 2 tai 3',
        'enable_commission_fee_for_each_category' => 'Ota käyttöön palkkio jokaiselle kategorialle?',
        'categories' => 'Kategoriat',
        'select_categories' => 'Valitse kategoriat..',
        'commission_fee' => 'Palkkio (%)',
        'commission_fee_by_category' => 'Palkkio kategorian mukaan (%)',
        'fee_withdrawal_amount' => 'Nostomaksu',
        'withdrawal_fee_type' => 'Nostomaksun tyyppi',
        'withdrawal_fee_types' => [
            'fixed' => 'Kiinteä summa',
            'percentage' => 'Prosenttiosuus',
        ],
        'check_valid_signature' => 'Tarkista kelvollinen allekirjoitus myyjän tuloissa',
        'verify_vendor' => 'Myyjän vahvistus (Myyjä voi julkaista tuotteensa vasta vahvistuksen jälkeen)',
        'verify_vendor_helper' => 'Jos käytössä, ylläpitäjän on vahvistettava myyjä ennen kuin he voivat julkaista tuotteensa.',
        'requires_vendor_documentations_verification' => 'Vaatii myyjän dokumenttien vahvistuksen',
        'requires_vendor_documentations_verification_helper' => 'Jos käytössä, myyjien on ladattava dokumenttinsa hakiessaan myyjäksi.',
        'hide_become_vendor_menu_in_customer_dashboard' => 'Piilota "Ryhdy myyjäksi" -valikko asiakaspaneelissa',
        'hide_become_vendor_menu_in_customer_dashboard_description' => 'Jos käytössä, "Ryhdy myyjäksi" -valikko piilotetaan asiakaspaneelissa.',
        'enable_product_approval' => 'Ota käyttöön tuotteen hyväksyntä',
        'enable_product_approval_description' => 'Jos käytössä, ylläpitäjän on hyväksyttävä tuote ennen sen julkaisua.',
        'hide_store_phone_number' => 'Piilota kaupan puhelinnumero?',
        'hide_store_email' => 'Piilota kaupan sähköposti?',
        'hide_store_address' => 'Piilota kaupan osoite?',
        'hide_store_social_links' => 'Piilota kaupan sosiaalisen median linkit?',
        'enable_vendor_categories_filter' => 'Ota käyttöön myyjän kategoriasuodatin',
        'enable_vendor_categories_filter_description' => 'Näytä kategoriasuodatin myyjän kauppasivulla. Vain kategoriat, joissa on myyjän tuotteita, näytetään.',
        'allow_vendor_manage_shipping' => 'Salli myyjän hallita toimitusta?',
        'allow_vendor_manage_shipping_description' => 'Jos käytössä, myyjä voi muuttaa tilauksen toimitustilaa "toimitetaan", "toimitettu", jne.',
        'charge_shipping_per_vendor' => 'Veloita toimitus myyjäkohtaisesti?',
        'charge_shipping_per_vendor_description' => 'Jos käytössä, toimitus veloitetaan erikseen jokaiselta myyjältä. Jos pois käytöstä, toimitus veloitetaan kerran koko tilauksesta.',
        'commission_fee_each_category_fee_name' => 'Palkkioasetusten :key palkkio',
        'commission_fee_each_category_name' => 'Palkkioasetusten :key kategoriat',
        'add_new' => 'Lisää uusi',
        'payout_methods' => 'Maksutavat',
        'max_upload_filesize' => 'Maksimi tiedostokoko (MB)',
        'max_upload_filesize_placeholder' => 'Oletus: 10',
        'max_product_images_upload_by_vendor' => 'Maksimimäärä kuvia per tuote',
        'enable_vendor_registration' => 'Ota käyttöön myyjärekisteröinti',
        'enable_vendor_registration_helper' => 'Jos käytössä, myyjät voivat rekisteröidä tilin sivustolle ja julkaista tuotteitaan.',
        'minimum_withdrawal_amount' => 'Vähimmäisnostosumma (kiinteä)',
        'minimum_withdrawal_amount_helper' => 'Määritä vähimmäissumma, jonka myyjä voi nostaa. Oletus on 0.',
        'allow_vendor_delete_their_orders' => 'Salli myyjien poistaa tilauksiaan',
        'allow_vendor_delete_their_orders_description' => 'Kun käytössä, myyjät voivat hallita tilausluetteloaan poistamalla ei-toivottuja merkintöjä. Käytä varoen, sillä poistetut tilaukset voivat vaikuttaa tapahtumatietoihin.',
        'enable_messaging_system' => 'Ota käyttöön viestintäjärjestelmä',
        'enable_messaging_system_description' => 'Jos käytössä, myyjät ja asiakkaat voivat kommunikoida keskenään viestintäjärjestelmän kautta.',
        'term_and_privacy_policy_url' => 'Käyttöehdot ja tietosuojakäytäntö -URL',
        'show_vendor_registration_form_at_registration_page' => 'Näytä myyjärekisteröintilomake rekisteröintisivulla',
        'show_vendor_registration_form_at_registration_page_description' => 'Jos käytössä, myyjärekisteröintilomake näytetään rekisteröintisivulla.',
        'single_vendor_checkout' => 'Rajoita yksi myyjä per tilaus',
        'single_vendor_checkout_help' => 'Jos käytössä, asiakkaat voivat ostaa tuotteita vain yhdeltä myyjältä per tilaus.',
        'display_order_total_info_for_each_store' => 'Näytä tilauksen kokonaistiedot jokaiselle kaupalle',
        'display_order_total_info_for_each_store_helper' => 'Jos käytössä, tilauksen kokonaistiedot näytetään jokaiselle kaupalle tilausyhteenvedossa.',
        'show_vendor_info_at_checkout' => 'Näytä myyjän tiedot kassalla',
        'show_vendor_info_at_checkout_helper' => 'Jos käytössä, myyjän tiedot (nimi, logo, arvostelut) näytetään kassasivulla.',
        'media_file_types_can_be_uploaded_by_vendor' => 'Mediatiedostotyypit, jotka myyjä voi ladata',
        'media_file_types_can_be_uploaded_by_vendor_helper' => 'Määritä mediatiedostotyypit, jotka myyjät voivat ladata. Valitse ne yllä olevasta luettelosta.',
    ],
    'theme_options' => [
        'name' => 'Markkinapaikka',
        'description' => 'Teema-asetukset markkinapaikalle',
        'logo_vendor_dashboard' => 'Logo myyjän paneelissa (oletus on päälogo)',
    ],
    'store_name' => 'Kaupan nimi',
    'store_email' => 'Kaupan sähköposti',
    'store_phone' => 'Kaupan puhelin',
    'store_address' => 'Kaupan osoite',
    'store_url' => 'Kaupan URL',
    'product_name' => 'Tuotteen nimi',
    'product_url' => 'Tuotteen URL',
    'withdrawal_amount' => 'Nostosumma',
    'helpers' => [
        'store_status' => 'Jos muutat tilan joksikin muuksi kuin ":status", myös tämän kaupan tili muuttuu tilaan ":customer"',
    ],
    'tables' => [
        'earnings' => 'Tulot',
        'products_count' => 'Tuotteiden määrä',
    ],
    'vendors' => 'Myyjät',
    'payout_payment_methods' => [
        'bank_transfer' => 'Pankkisiirto',
        'paypal' => 'PayPal',
        'cash' => 'Käteinen',
    ],
    'reports' => [
        'name' => 'Raportit',
        'total_fee_earnings' => 'Maksutulot yhteensä: :value',
        'total_fee' => 'Maksu yhteensä',
        'total_amount' => 'Summa yhteensä',
        'store_revenues' => 'Kauppojen tulot',
        'sale_commissions' => 'Myyntipalkkiot',
        'fee' => 'Maksu (:symbol)',
        'amount' => 'Summa (:symbol)',
        'top_performing_stores' => 'Parhaiten menestyvät kaupat',
        'store_growth' => 'Kauppojen kasvu',
        'withdrawal_status_chart' => 'Nostotilanne',
        'product_distribution' => 'Tuotteiden jakautuminen kaupan mukaan',
        'average_commission' => 'Keskimääräinen palkkioprosentti',
        'recent_withdrawals' => 'Viimeisimmät nostot',
        'number_of_stores' => 'Kauppojen määrä',
        'number_of_products' => 'Tuotteiden määrä',
        'orders' => 'Tilaukset',
        'revenue' => 'Tulot',
        'increase' => ':count kasvu',
        'decrease' => ':count lasku',
    ],
    'vendor' => 'Myyjä',
    'vendor_name' => 'Myyjän nimi',
    'contact_store' => [
        'form_name' => 'Ota yhteyttä kauppaan -lomake',
    ],
    'store_statuses' => [
        'pending' => 'Odottaa',
        'published' => 'Hyväksytty',
        'blocked' => 'Estetty',
    ],
    'view_vendor' => 'Näytä myyjä :name',
    'vendor_information' => 'Myyjän tiedot',
    'vendor_verified' => 'Myyjä vahvistettu',
    'vendor_not_verified' => 'Myyjää ei ole vahvistettu',
    'vendor_verified_at' => 'Myyjä vahvistettu',
    'view_certificate' => 'Näytä sertifikaatti',
    'view_government_id' => 'Näytä henkilötodistus',
    'documents' => 'Dokumentit',
    'store_products' => 'Kaupan tuotteet',
    'store_orders' => 'Kaupan tilaukset',
    'total_revenue' => 'Kokonaistulot',
    'total_earnings' => 'Kokonaistulot',
    'pending_withdrawals' => 'Odottavat nostot',
    'balance' => 'Saldo',
    'recent_products' => 'Viimeisimmät tuotteet',
    'products_count' => 'Tuotteet',
    'store_status' => 'Kaupan tila',
    'verified' => 'Vahvistettu',
    'dashboard' => 'Kojelauta',
    'products' => 'Tuotteet',
    'orders' => 'Tilaukset',
    'coupons' => 'Kupongit',
    'withdrawals' => 'Nostot',
    'revenues' => 'Tulot',
    'messages' => 'Viestit',
    'reviews' => 'Arvostelut',
    'order_returns' => 'Tilausten palautukset',
    'shipments' => 'Lähetykset',
    'vendor_dashboard' => 'Myyjän kojelauta',
    'become_a_vendor' => 'Ryhdy myyjäksi',
    'become_vendor' => 'Ryhdy myyjäksi',
    'product_specification' => 'Tuotteen tekniset tiedot',
    'specification_groups' => 'Tekniset tiedot -ryhmät',
    'specification_attributes' => 'Tekniset tiedot -attribuutit',
    'specification_tables' => 'Tekniset tiedot -taulukot',
    'register_as' => 'Rekisteröidy',
    'register' => 'Rekisteröidy',
    'i_am_customer' => 'Olen asiakas',
    'i_am_vendor' => 'Olen myyjä',
    'i_agree_to_terms' => 'Hyväksyn :link',
    'i_agree_to_terms_simple' => 'Hyväksyn ehdot',
    'terms_and_privacy_policy' => 'Ehdot ja tietosuojakäytäntö',
    'send_message_successfully' => 'Viesti lähetetty onnistuneesti!',
    'cannot_send_message_to_own_store' => 'Et voi lähettää viestiä omaan kauppaasi.',
    'vendor_account_not_verified' => 'Myyjätiliä ei ole vahvistettu.',
    'invalid_signature' => 'Virheellinen myyjätiedon allekirjoitus',
    'file_not_found' => 'Tiedostoa ei löytynyt!',
    'update_successfully' => 'Päivitetty onnistuneesti!',
    'shop_url_exists' => 'Kaupan URL on jo olemassa. Valitse toinen!',
    'insufficient_balance' => 'Riittämätön saldo tai pankkitiedot puuttuvat',
    'total_amount_exceeds_balance' => 'Kokonaissumma (mukaan lukien maksu) ylittää nykyisen saldon',
    'registered_successfully' => 'Rekisteröity onnistuneesti!',
    'updated_registration_successfully' => 'Rekisteröintitiedot päivitetty onnistuneesti!',
    'missing_documentations' => 'Dokumentit puuttuvat! Lataa yhtiöjärjestyksesi ja henkilöllisyystodistuksesi jatkaaksesi.',
    'only_add_products_from_same_store' => 'Voit lisätä ostoskoriin vain saman kaupan tuotteita.',
    'checkout_only_one_store' => 'Kassa on käytettävissä vain yhden kaupan tuotteille kerrallaan. Poista muiden kauppojen tuotteet ennen jatkamista.',
    'coupon_code_invalid' => 'Kuponkikoodi ei kelpaa tai ei koske tuotteita',
    'recovered_from_previous_orders' => 'Olet palautunut aiemmista tilauksista!',
    'not_available' => 'Ei saatavilla',
    'available' => 'Saatavilla',
    'stores_seo_title' => 'Kauppaluettelon sivun SEO-otsikko',
    'stores_seo_description' => 'Kauppaluettelon sivun SEO-kuvaus',
    'leave_empty_for_default' => 'Jätä tyhjäksi käyttääksesi oletuskuvausta.',
    'stores' => 'Kaupat',
    'total_products_found' => ':total tuotetta löytyi',
    'language' => 'Kieli',
    'save_settings' => 'Tallenna asetukset',
    'payout_info' => 'Maksutiedot',
    'payment_method' => 'Maksutapa',
    'bank_name' => 'Pankin nimi',
    'bank_code_ifsc' => 'Pankkikoodi/IFSC',
    'account_holder_name' => 'Tilinomistajan nimi',
    'account_number' => 'Tilinumero',
    'upi_id' => 'UPI ID',
    'upi_id_helper' => 'Se on valinnainen. Jos sinulla on UPI ID, voit antaa sen tähän. Lisätietoja: https://support.google.com/pay/india/answer/10331134?hl=en',
    'description' => 'Kuvaus',
    'paypal_id' => 'PayPal ID',
    'pickup_location' => 'Noutopaikka',
    'pickup_location_helper' => 'Mistä haluat noutaa käteismaksusi?',
    'contact_name' => 'Yhteyshenkilön nimi',
    'contact_phone' => 'Yhteystiedot puhelin',
    'business_name' => 'Yrityksen nimi',
    'tax_id' => 'Y-tunnus',
    'address' => 'Osoite',
    'earnings' => 'Tulot',
    'our_stores' => 'Meidän kaupat',
    'quick_actions' => 'Pikatoiminnot',
    'add_product' => 'Lisää tuote',
    'product' => 'Tuote',
    'create_discount' => 'Luo alennus',
    'store_settings' => 'Kaupan asetukset',
    'withdraw' => 'Nosta',
    'store_performance' => 'Kaupan suorituskyky',
    'conversion_rate' => 'Konversioaste',
    'avg_order_value' => 'Keskimääräinen tilausarvo',
    'fulfillment_rate' => 'Toimitusaste',
    'store_visibility' => 'Kaupan näkyvyys',
    'active' => 'Aktiivinen',
    'sales_reports' => 'Myyntiraportit',
    'revenues_in_label' => 'Tulot :label',
    'earnings_in_label' => 'Tulot :label',
    'fees' => 'Maksut',
    'congratulations_vendor' => 'Onnittelut myyjäksi :site_title',
    'attract_customers_message' => 'Houkuttele asiakkaita parhaimilla tuotteilla.',
    'create_new_product_here' => 'Luo uusi tuote <a href=":url">tästä</a>',
    'no_orders_yet_message' => 'Sinulla on :total tuote(tta), mutta ei vielä tilauksia',
    'view_your_store_here' => 'Katso kauppaasi <a href=":url">täältä</a>',
    'includes_order_statuses' => 'Sisältää tilat Valmis, Odottaa ja Käsittelyssä',
    'wait_for_approval' => 'Odota järjestelmänvalvojan tarkistusta ja hyväksyntää!',
    'uploaded_certificate' => 'Ladattu todistus',
    'uploaded_government_id' => 'Ladattu henkilöllisyystodistus',
    'store' => 'Kauppa',
    'tax_info' => 'Verotiedot',
    'joined_on_date' => 'Liittyi :date',
    'view_your_store' => 'Katso kauppaasi',
    'go_to_homepage' => 'Siirry kotisivulle',
    'recent_orders' => 'Viimeisimmät tilaukset',
    'no_orders' => 'Ei tilauksia!',
    'view_full_orders' => 'Näytä kaikki tilaukset',
    'customer_reviews' => 'Asiakasarvostelut',
    'no_reviews_yet' => 'Ei vielä arvosteluja',
    'reviews_require_ecommerce' => 'Arvosteluominaisuus vaatii Ecommerce-lisäosan',
    'view_all_products' => 'Näytä kaikki tuotteet',
    'top_selling_products' => 'Myydyimmät tuotteet',
    'no_products' => 'Ei tuotteita!',
    'view_full_products' => 'Näytä kaikki tuotteet',
    'inventory_status' => 'Varastotila',
    'in_stock' => 'Varastossa',
    'low_stock' => 'Vähän varastossa',
    'out_of_stock' => 'Loppu varastosta',
    'add_new_product' => 'Lisää uusi tuote',
];
