<?php

return [
    'name' => 'Marktplaats',
    'email' => [
        'title' => 'Marktplaats',
        'description' => 'Configureer e-mail sjablonen voor Marktplaats',
        'store_new_order_title' => 'Melding nieuwe bestelling',
        'store_new_order_description' => 'Stuur e-mail naar winkeleigenaar wanneer een bestelling wordt geplaatst',
        'verify_vendor_title' => 'Verkoper verifiëren',
        'verify_vendor_description' => 'Stuur e-mail naar beheerder wanneer een verkoper zich registreert',
        'pending_product_approval_title' => 'Product goedkeuring in behandeling',
        'pending_product_approval_description' => 'Stuur e-mail naar beheerder wanneer een verkoper hun producten plaatst',
        'vendor_account_approved_title' => 'Verkoper account goedgekeurd',
        'vendor_account_approved_description' => 'Stuur e-mail naar verkoper wanneer hun account wordt goedgekeurd',
        'product_approved_title' => 'Product goedgekeurd',
        'product_approved_description' => 'Stuur e-mail naar verkoper wanneer hun product wordt goedgekeurd',
        'withdrawal_approved_title' => 'Opname goedgekeurd',
        'withdrawal_approved_description' => 'Stuur e-mail naar verkoper wanneer hun opnameverzoek wordt goedgekeurd',
        'vendor_account_rejected_title' => 'Verkoper account afgewezen',
        'vendor_account_rejected_description' => 'Stuur e-mail naar verkoper wanneer hun account wordt afgewezen',
        'vendor_account_unblocked_title' => 'Verkoper account gedeblokkeerd',
        'vendor_account_unblocked_description' => 'Stuur e-mail naar verkoper wanneer hun account wordt gedeblokkeerd',
        'vendor_account_blocked_title' => 'Verkoper account geblokkeerd',
        'vendor_account_blocked_description' => 'Stuur e-mail naar verkoper wanneer hun account wordt geblokkeerd',
        'store_new_order_subject' => 'Nieuwe bestelling(en) op {{ site_title }}',
        'verify_vendor_subject' => 'Nieuwe verkoper op {{ site_title }} moet worden geverifieerd',
        'vendor_account_approved_subject' => 'Uw account is goedgekeurd voor verkoop op {{ site_title }}',
        'vendor_account_rejected_subject' => 'Uw account is afgewezen voor verkoop op {{ site_title }}',
        'pending_product_approval_subject' => 'Nieuw product moet worden goedgekeurd voor verkoop op {{ site_title }}',
        'product_approved_subject' => 'Uw product is goedgekeurd voor verkoop op {{ site_title }}',
        'withdrawal_approved_subject' => 'Uw opnameverzoek is goedgekeurd',
        'welcome_vendor_title' => 'Welkom verkoper',
        'welcome_vendor_description' => 'Stuur e-mail naar verkoper na registratie',
        'welcome_vendor_subject' => 'Welkom bij {{ site_title }}!',
        'contact_store_title' => 'Contact Winkel',
        'contact_store_description' => 'Stuur e-mail naar winkeleigenaar wanneer een klant contact opneemt met de winkel',
        'contact_store_subject' => 'Nieuw Klant Contact Bericht',
        'vendor_account_blocked_subject' => 'Uw verkoper account op {{ site_title }} is geblokkeerd',
        'vendor_account_unblocked_subject' => 'Uw verkoper account op {{ site_title }} is gedeblokkeerd',
        'order_cancellation_to_vendor_title' => 'Bestelling annulering (wordt naar verkoper gestuurd)',
        'order_cancellation_to_vendor_description' => 'Stuur naar verkoper wanneer klant een bestelling annuleert',
        'order_cancellation_to_vendor_subject' => 'Bestelling :order_id is geannuleerd door klant',
        'store_verified_title' => 'Winkel Verificatie Goedgekeurd',
        'store_verified_description' => 'Stuur melding wanneer winkel wordt geverifieerd',
        'store_verified_subject' => 'Uw winkel {{ store_name }} is geverifieerd',
        'store_unverified_title' => 'Winkel Verificatie Verwijderd',
        'store_unverified_description' => 'Stuur melding wanneer winkel verificatie wordt verwijderd',
        'store_unverified_subject' => 'Verificatiestatus gewijzigd voor {{ store_name }}',
        'verified_by' => 'Geverifieerd door',
        'verified_at' => 'Geverifieerd op',
        'unverified_by' => 'Niet geverifieerd door',
        'unverified_at' => 'Niet geverifieerd op',
        'verification_note' => 'Verificatie notitie',
        'store' => 'Winkel',
        'order' => 'Bestelling',
        'shipment' => 'Verzendinfo',
        'address' => 'Verzendadres',
        'products' => 'Bestelling producten',
        'customer_message' => 'Klant bericht',
        'customer_name' => 'Klantnaam',
        'customer_email' => 'Klant e-mail',
        'block_reason' => 'Reden voor blokkering',
        'block_date' => 'Datum van blokkering',
        'unblock_date' => 'Datum van deblokkering',
    ],
    'email_templates' => [
        'dear_vendor' => 'Beste :vendor_name,',
        'dear_admin' => 'Beste Beheerder,',
        'hello' => 'Hallo,',
        'happy_selling' => 'Veel verkoopplezier!',
        'email_sent_by_team' => 'Deze e-mail is verzonden door het {{ site_title }} team.',

        // Contact Store
        'contact_store_sent_from' => 'Deze e-mail is verzonden van :customer_name (:customer_email) via uw profiel contactformulier op :site_title.',
        'contact_store_reply_instruction' => 'U kunt direct op deze e-mail antwoorden om te reageren op :customer_name (:customer_email).',

        // Vendor Account Status
        'vendor_account_blocked_message' => 'Uw verkoper account op {{ site_title }} is <strong>geblokkeerd</strong> vanaf :block_date.',
        'vendor_account_blocked_reason' => 'Reden voor blokkering: :block_reason',
        'vendor_account_blocked_contact_support' => 'Als u denkt dat dit een vergissing is of vragen heeft, neem dan contact op met ons ondersteuningsteam.',
        'vendor_account_unblocked_message' => 'We zijn blij u te informeren dat uw verkoper account op {{ site_title }} is <strong>gedeblokkeerd</strong> vanaf :unblock_date.',
        'vendor_account_unblocked_resume' => 'U kunt nu toegang krijgen tot uw account en uw activiteiten hervatten.',
        'vendor_account_unblocked_questions' => 'Als u vragen heeft, aarzel dan niet om contact op te nemen met ons ondersteuningsteam.',
        'vendor_account_approved_title' => 'Verkoper Account Goedgekeurd',
        'vendor_account_approved_message' => 'Uw account is goedgekeurd voor verkoop op onze site <a href=":site_url">:site_url</a>.',
        'vendor_account_rejected_title' => 'Verkoper Account Afgewezen',
        'vendor_account_rejected_message' => 'Het spijt ons u te moeten meedelen dat uw account niet is goedgekeurd voor verkoop op onze site <a href=":site_url">:site_url</a>.',

        // Store New Order
        'store_new_order_title' => 'Bestelling succesvol!',
        'store_new_order_message' => 'U heeft een nieuwe bestelling ontvangen op :site_title!',
        'customer_information' => 'Klant Informatie',
        'field_name' => 'Naam',
        'field_phone' => 'Telefoon',
        'field_email' => 'E-mail',
        'field_address' => 'Adres',
        'field_note' => 'Notitie',
        'order_number' => 'Bestelnummer',
        'order_date' => 'Besteldatum',
        'shipping_method' => 'Verzendmethode',
        'payment_method' => 'Betaalmethode',

        // Product Approval
        'product_approved_title' => 'Product Goedgekeurd',
        'product_approved_message' => 'Uw product is goedgekeurd voor verkoop op onze site <a href=":site_url">:site_url</a>.',
        'pending_product_approval_title' => 'Product goedkeuring in behandeling',
        'pending_product_approval_message' => 'Nieuw product is gemaakt door :store_name <a href=":product_url">:product_name</a> wacht op goedkeuring.',

        // Verify Vendor
        'verify_vendor_title' => 'Verkoper Verifiëren',
        'verify_vendor_message' => 'U heeft een nieuwe verkoper die moet worden geverifieerd op :site_title!',
        'vendor_information' => 'Verkoper Informatie',
        'shop_information' => 'Winkel informatie',
        'field_store_name' => 'Winkelnaam',
        'field_store_phone' => 'Winkel Telefoonnummer',
        'visit_store_button' => 'Bezoek winkel',

        // Withdrawal
        'withdrawal_approved_title' => 'Opname Goedgekeurd',
        'withdrawal_approved_message' => 'Uw uitbetalingsverzoek is goedgekeurd, we zullen <strong>:withdrawal_amount</strong> binnenkort naar uw bankinformatie sturen.',

        // Order Cancellation
        'order_cancellation_title' => 'Klant heeft bestelling :order_id geannuleerd',
        'order_cancellation_message' => 'Klant :customer_name heeft bestelling <strong>:order_id</strong> geannuleerd vanwege reden :cancellation_reason.',
        'order_items_header' => 'Hier is wat u bestelde:',

        // Welcome Vendor
        'welcome_vendor_title' => 'Welkom verkoper',
        'welcome_vendor_greeting' => 'We zijn verheugd u te verwelkomen op :store_name!',
        'welcome_vendor_registration_complete' => 'Uw verkoper registratie is succesvol voltooid en u bent nu onderdeel van onze levendige gemeenschap van verkopers.',
        'welcome_vendor_next_steps' => 'Dit kunt u nu doen:',
        'welcome_vendor_step_login' => 'Log in op uw verkoper account met uw inloggegevens.',
        'welcome_vendor_step_add_products' => 'Voeg uw producten/diensten toe aan uw winkel. Zorg ervoor dat u gedetailleerde beschrijvingen en aantrekkelijke afbeeldingen verstrekt om potentiële kopers aan te trekken.',
        'welcome_vendor_support' => 'Als u vragen heeft of hulp nodig heeft onderweg, staat ons ondersteuningsteam klaar om u te helpen. Aarzel niet om contact op te nemen!',
        'login_vendor_account_button' => 'Log in op uw verkoper account',
        'welcome_vendor_closing' => 'We zijn enthousiast om uw winkel te zien bloeien op :site_title!',

        // Store Verification
        'store_verified_title' => 'Winkel Verificatie Goedgekeurd',
        'store_verified_message' => 'Gefeliciteerd! Uw winkel is succesvol geverifieerd op <strong>:site_title</strong>. Deze verificatie badge zal helpen vertrouwen op te bouwen met uw klanten.',
        'dear_store_owner' => 'Beste :store_name Eigenaar,',
        'verification_details' => 'Verificatie Details',
        'store_verified_benefits' => 'Voordelen van geverifieerd zijn',
        'verified_badge_benefit' => 'Een geverifieerde badge weergegeven op uw winkel',
        'increased_trust_benefit' => 'Verhoogd klantvertrouwen en vertrouwen',
        'higher_visibility_benefit' => 'Hogere zichtbaarheid in zoekresultaten',
        'visit_your_store' => 'Bezoek Uw Winkel',
        'congratulations_verified' => 'Gefeliciteerd met uw verificatie!',

        // Store Unverification
        'store_unverified_title' => 'Winkel Verificatiestatus Gewijzigd',
        'store_unverified_message' => 'Het spijt ons u te moeten meedelen dat de verificatiestatus van uw winkel op <strong>:site_title</strong> is gewijzigd.',
        'unverification_details' => 'Status Wijziging Details',
        'store_unverified_impacts' => 'Wat dit betekent',
        'verified_badge_removed' => 'De geverifieerde badge is verwijderd van uw winkel',
        'verification_benefits_lost' => 'Verificatievoordelen zijn niet langer actief',
        'store_unverified_next_steps' => 'Als u vragen heeft over deze beslissing of herverificatie wilt bespreken, neem dan <strong>contact op met ons ondersteuningsteam</strong>.',
        'contact_support' => 'Contact Ondersteuning',
        'thank_you_understanding' => 'Bedankt voor uw begrip.',
    ],
    'current_balance' => 'Huidig saldo',
    'settings' => [
        'title' => 'Instellingen',
        'description' => 'Instellingen voor marktplaats',
        'fee_per_order' => 'Kosten per bestelling (%), suggestie: 2 of 3',
        'default_commission_fee' => 'Standaard commissie (%), suggestie: 2 of 3',
        'enable_commission_fee_for_each_category' => 'Commissie per categorie inschakelen?',
        'categories' => 'Categorieën',
        'select_categories' => 'Selecteer categorieën..',
        'commission_fee' => 'Commissie (%)',
        'commission_fee_by_category' => 'Commissie per categorie (%)',
        'fee_withdrawal_amount' => 'Opname kosten',
        'withdrawal_fee_type' => 'Opname kosten type',
        'withdrawal_fee_types' => [
            'fixed' => 'Vast bedrag',
            'percentage' => 'Percentage',
        ],
        'check_valid_signature' => 'Controleer geldige handtekening in verkoper verdiensten',
        'verify_vendor' => 'Verkoper verificatie (Verkoper kan alleen producten plaatsen na verificatie)',
        'verify_vendor_helper' => 'Indien ingeschakeld, moet de beheerder de verkoper verifiëren voordat ze hun productlijst kunnen plaatsen.',
        'requires_vendor_documentations_verification' => 'Vereist verkoper documentatie verificatie',
        'requires_vendor_documentations_verification_helper' => 'Indien ingeschakeld, moeten verkopers hun documentatiebestanden uploaden bij het aanvragen om verkoper te worden.',
        'hide_become_vendor_menu_in_customer_dashboard' => 'Verberg word verkoper menu in klant dashboard',
        'hide_become_vendor_menu_in_customer_dashboard_description' => 'Indien ingeschakeld, wordt het "Word verkoper" menu verborgen in het klant dashboard.',
        'enable_product_approval' => 'Product goedkeuring inschakelen',
        'enable_product_approval_description' => 'Indien ingeschakeld, moet de beheerder het product goedkeuren voordat het wordt gepubliceerd.',
        'hide_store_phone_number' => 'Winkel telefoonnummer verbergen?',
        'hide_store_email' => 'Winkel e-mail verbergen?',
        'hide_store_address' => 'Winkel adres verbergen?',
        'hide_store_social_links' => 'Winkel sociale links verbergen?',
        'enable_vendor_categories_filter' => 'Verkoper categorieën filter inschakelen',
        'enable_vendor_categories_filter_description' => 'Toon categorieën filter op verkoper winkel pagina. Alleen categorieën die verkoper producten hebben worden weergegeven.',
        'allow_vendor_manage_shipping' => 'Verkoper verzending laten beheren?',
        'allow_vendor_manage_shipping_description' => 'Indien ingeschakeld, kan de verkoper de verzendstatus van bestelling wijzigen naar "bezorgen", "bezorgd", ...',
        'charge_shipping_per_vendor' => 'Verzendkosten per verkoper rekenen?',
        'charge_shipping_per_vendor_description' => 'Indien ingeschakeld, worden verzendkosten apart gerekend voor elke verkoper. Indien uitgeschakeld, worden verzendkosten eenmaal gerekend voor de hele bestelling.',
        'commission_fee_each_category_fee_name' => 'Commissie van commissie instelling :key',
        'commission_fee_each_category_name' => 'Categorieën van commissie instelling :key',
        'add_new' => 'Nieuwe toevoegen',
        'payout_methods' => 'Uitbetalingsmethoden',
        'max_upload_filesize' => 'Max upload bestandsgrootte (MB)',
        'max_upload_filesize_placeholder' => 'Standaard: 10',
        'max_product_images_upload_by_vendor' => 'Max aantal afbeeldingen per product',
        'enable_vendor_registration' => 'Verkoper registratie inschakelen',
        'enable_vendor_registration_helper' => 'Indien ingeschakeld, kunnen verkopers een account registreren op de site en hun producten plaatsen.',
        'minimum_withdrawal_amount' => 'Minimum opname bedrag (Vast)',
        'minimum_withdrawal_amount_helper' => 'Specificeer het minimum bedrag dat een verkoper kan opnemen. Standaard is 0.',
        'allow_vendor_delete_their_orders' => 'Verkopers toestaan hun bestellingen te verwijderen',
        'allow_vendor_delete_their_orders_description' => 'Wanneer ingeschakeld, kunnen verkopers hun bestellingslijst beheren door ongewenste items te verwijderen. Gebruik voorzichtig omdat verwijderde bestellingen transactierecords kunnen beïnvloeden.',
        'enable_messaging_system' => 'Berichtensysteem inschakelen',
        'enable_messaging_system_description' => 'Indien ingeschakeld, kunnen verkopers en klanten met elkaar communiceren via het berichtensysteem.',
        'term_and_privacy_policy_url' => 'Voorwaarden en privacybeleid URL',
        'show_vendor_registration_form_at_registration_page' => 'Verkoper registratieformulier tonen op registratiepagina',
        'show_vendor_registration_form_at_registration_page_description' => 'Indien ingeschakeld, wordt het verkoper registratieformulier weergegeven op de registratiepagina.',
        'single_vendor_checkout' => 'Beperk tot Eén Verkoper per Bestelling',
        'single_vendor_checkout_help' => 'Indien ingeschakeld, kunnen klanten alleen producten van één verkoper per bestelling kopen.',
        'display_order_total_info_for_each_store' => 'Bestel totaal info voor elke winkel weergeven',
        'display_order_total_info_for_each_store_helper' => 'Indien ingeschakeld, wordt de bestel totaal informatie weergegeven voor elke winkel in de besteloverzicht.',
        'show_vendor_info_at_checkout' => 'Verkoper informatie tonen bij afrekenen',
        'show_vendor_info_at_checkout_helper' => 'Indien ingeschakeld, wordt verkoper informatie (naam, logo, reviews) weergegeven op de afrekenpagin.',
        'media_file_types_can_be_uploaded_by_vendor' => 'Media bestandstypes die door verkoper kunnen worden geüpload',
        'media_file_types_can_be_uploaded_by_vendor_helper' => 'Specificeer de media bestandstypes die verkopers kunnen uploaden. Selecteer ze in de lijst hierboven.',
    ],
    'theme_options' => [
        'name' => 'Marktplaats',
        'description' => 'Thema opties voor Marktplaats',
        'logo_vendor_dashboard' => 'Logo in het verkoper dashboard (Standaard is het hoofdlogo)',
    ],
    'store_name' => 'Winkelnaam',
    'store_email' => 'Winkel e-mail',
    'store_phone' => 'Winkel telefoon',
    'store_address' => 'Winkel adres',
    'store_url' => 'Winkel URL',
    'product_name' => 'Productnaam',
    'product_url' => 'Product URL',
    'withdrawal_amount' => 'Opname bedrag',
    'helpers' => [
        'store_status' => 'Als u de status wijzigt anders dan ":status" zal dit winkel account ook veranderen naar ":customer"',
    ],
    'tables' => [
        'earnings' => 'Verdiensten',
        'products_count' => 'Producten Aantal',
    ],
    'vendors' => 'Verkopers',
    'payout_payment_methods' => [
        'bank_transfer' => 'Bankoverschrijving',
        'paypal' => 'PayPal',
        'cash' => 'Contant',
    ],
    'reports' => [
        'name' => 'Rapporten',
        'total_fee_earnings' => 'Totale kosten verdiensten: :value',
        'total_fee' => 'Totale kosten',
        'total_amount' => 'Totaal bedrag',
        'store_revenues' => 'Winkel inkomsten',
        'sale_commissions' => 'Verkoop commissies',
        'fee' => 'Kosten (:symbol)',
        'amount' => 'Bedrag (:symbol)',
        'top_performing_stores' => 'Best Presterende Winkels',
        'store_growth' => 'Winkel Groei',
        'withdrawal_status_chart' => 'Opname Status',
        'product_distribution' => 'Product Distributie per Winkel',
        'average_commission' => 'Gemiddelde Commissie Tarief',
        'recent_withdrawals' => 'Recente Opnames',
        'number_of_stores' => 'Aantal Winkels',
        'number_of_products' => 'Aantal Producten',
        'orders' => 'Bestellingen',
        'revenue' => 'Inkomsten',
        'increase' => ':count toename',
        'decrease' => ':count afname',
    ],
    'vendor' => 'Verkoper',
    'vendor_name' => 'Verkoper naam',
    'contact_store' => [
        'form_name' => 'Contact Winkel formulier',
    ],
    'store_statuses' => [
        'pending' => 'In behandeling',
        'published' => 'Goedgekeurd',
        'blocked' => 'Geblokkeerd',
    ],
    'view_vendor' => 'Bekijk verkoper :name',
    'vendor_information' => 'Verkoper Informatie',
    'vendor_verified' => 'Verkoper Geverifieerd',
    'vendor_not_verified' => 'Verkoper Niet Geverifieerd',
    'vendor_verified_at' => 'Verkoper Geverifieerd Op',
    'view_certificate' => 'Bekijk Certificaat',
    'view_government_id' => 'Bekijk Identiteitsbewijs',
    'documents' => 'Documenten',
    'store_products' => 'Winkel Producten',
    'store_orders' => 'Winkel Bestellingen',
    'total_revenue' => 'Totale Inkomsten',
    'total_earnings' => 'Totale Verdiensten',
    'pending_withdrawals' => 'Opnames in Behandeling',
    'balance' => 'Saldo',
    'recent_products' => 'Recente Producten',
    'products_count' => 'Producten',
    'store_status' => 'Winkel Status',
    'verified' => 'Geverifieerd',
    'dashboard' => 'Dashboard',
    'products' => 'Producten',
    'orders' => 'Bestellingen',
    'coupons' => 'Kortingsbonnen',
    'withdrawals' => 'Opnames',
    'revenues' => 'Inkomsten',
    'messages' => 'Berichten',
    'reviews' => 'Beoordelingen',
    'order_returns' => 'Retourzendingen',
    'shipments' => 'Verzendingen',
    'vendor_dashboard' => 'Leverancier Dashboard',
    'become_a_vendor' => 'Word Leverancier',
    'become_vendor' => 'Word Leverancier',
    'product_specification' => 'Productspecificaties',
    'specification_groups' => 'Specificatiegroepen',
    'specification_attributes' => 'Specificatiekenmerken',
    'specification_tables' => 'Specificatietabellen',
    'register_as' => 'Registreer als',
    'register' => 'Registreren',
    'i_am_customer' => 'Ik ben een klant',
    'i_am_vendor' => 'Ik ben een leverancier',
    'i_agree_to_terms' => 'Ik ga akkoord met :link',
    'i_agree_to_terms_simple' => 'Ik ga akkoord met de voorwaarden',
    'terms_and_privacy_policy' => 'Voorwaarden en privacybeleid',
    'send_message_successfully' => 'Bericht succesvol verzonden',
    'cannot_send_message_to_own_store' => 'U kunt geen bericht naar uw eigen winkel sturen',
    'vendor_account_not_verified' => 'Leveranciersaccount niet geverifieerd',
    'invalid_signature' => 'Ongeldige handtekening',
    'file_not_found' => 'Bestand niet gevonden',
    'update_successfully' => 'Succesvol bijgewerkt',
    'shop_url_exists' => 'Winkel URL bestaat al',
    'insufficient_balance' => 'Onvoldoende saldo',
    'total_amount_exceeds_balance' => 'Totaalbedrag overschrijdt saldo',
    'registered_successfully' => 'Succesvol geregistreerd',
    'updated_registration_successfully' => 'Registratie succesvol bijgewerkt',
    'missing_documentations' => 'Ontbrekende documentatie',
    'only_add_products_from_same_store' => 'U kunt alleen producten uit dezelfde winkel toevoegen',
    'checkout_only_one_store' => 'U kunt alleen producten uit één winkel afrekenen',
    'coupon_code_invalid' => 'Kortingscode is ongeldig',
    'recovered_from_previous_orders' => 'Hersteld uit eerdere bestellingen',
    'not_available' => 'Niet beschikbaar',
    'available' => 'Beschikbaar',
    'stores_seo_title' => 'Winkels',
    'stores_seo_description' => 'Ontdek onze winkels',
    'leave_empty_for_default' => 'Laat leeg voor standaardwaarde',
    'stores' => 'Winkels',
    'total_products_found' => 'Totaal :total producten gevonden',
    'language' => 'Taal',
    'save_settings' => 'Instellingen opslaan',
    'payout_info' => 'Uitbetalingsinfo',
    'payment_method' => 'Betaalmethode',
    'bank_name' => 'Banknaam',
    'bank_code_ifsc' => 'Bankcode / IFSC',
    'account_holder_name' => 'Naam Rekeninghouder',
    'account_number' => 'Rekeningnummer',
    'upi_id' => 'UPI ID',
    'upi_id_helper' => 'Bijvoorbeeld: 123456789@paytm',
    'description' => 'Beschrijving',
    'paypal_id' => 'PayPal ID',
    'pickup_location' => 'Ophaallocatie',
    'pickup_location_helper' => 'Volledig adres voor ophalen van producten',
    'contact_name' => 'Contactnaam',
    'contact_phone' => 'Contact Telefoon',
    'business_name' => 'Bedrijfsnaam',
    'tax_id' => 'Belasting ID',
    'address' => 'Adres',
    'earnings' => 'Verdiensten',
    'our_stores' => 'Onze Winkels',
    'quick_actions' => 'Snelle Acties',
    'add_product' => 'Product Toevoegen',
    'product' => 'Product',
    'create_discount' => 'Korting Aanmaken',
    'store_settings' => 'Winkelinstellingen',
    'withdraw' => 'Opnemen',
    'store_performance' => 'Winkelprestaties',
    'conversion_rate' => 'Conversieratio',
    'avg_order_value' => 'Gemiddelde Bestelwaarde',
    'fulfillment_rate' => 'Afhandelingspercentage',
    'store_visibility' => 'Winkel Zichtbaarheid',
    'active' => 'Actief',
    'sales_reports' => 'Verkooprapporten',
    'revenues_in_label' => 'Inkomsten in :label',
    'earnings_in_label' => 'Verdiensten in :label',
    'fees' => 'Kosten',
    'congratulations_vendor' => 'Gefeliciteerd! Uw leveranciersregistratie is succesvol!',
    'attract_customers_message' => 'Laten we klanten aantrekken door uw eerste product toe te voegen.',
    'create_new_product_here' => 'Maak hier een nieuw product aan',
    'no_orders_yet_message' => 'Nog geen bestellingen. Bekijk uw winkel om ervoor te zorgen dat deze er geweldig uitziet voor klanten.',
    'view_your_store_here' => 'Bekijk uw winkel hier',
    'includes_order_statuses' => 'Inclusief bestellingen met statussen: :statuses.',
    'wait_for_approval' => 'Wacht op goedkeuring',
    'uploaded_certificate' => 'Certificaat geüpload',
    'uploaded_government_id' => 'Identiteitsbewijs geüpload',
    'store' => 'Winkel',
    'tax_info' => 'Belastinginfo',
    'joined_on_date' => 'Aangesloten op :date',
    'view_your_store' => 'Bekijk uw winkel',
    'go_to_homepage' => 'Ga naar startpagina',
    'recent_orders' => 'Recente Bestellingen',
    'no_orders' => 'Geen bestellingen',
    'view_full_orders' => 'Bekijk alle bestellingen',
    'customer_reviews' => 'Klantbeoordelingen',
    'no_reviews_yet' => 'Nog geen beoordelingen',
    'reviews_require_ecommerce' => 'Om beoordelingen te bekijken, activeert u de Reviews-plugin in de Ecommerce-plugin.',
    'view_all_products' => 'Bekijk alle producten',
    'top_selling_products' => 'Best Verkochte Producten',
    'no_products' => 'Geen producten',
    'view_full_products' => 'Bekijk alle producten',
    'inventory_status' => 'Voorraadstatus',
    'in_stock' => 'Op voorraad',
    'low_stock' => 'Lage voorraad',
    'out_of_stock' => 'Niet op voorraad',
    'add_new_product' => 'Nieuw product toevoegen',
];
