<?php

return [
    'settings' => [
        'title' => 'Social Login settings',
        'description' => 'Configure social login options',
        'facebook' => [
            'enable' => 'Enable Facebook login',
            'app_id' => 'App ID',
            'app_secret' => 'App Secret',
            'helper' => 'Please go to https://developers.facebook.com to create new app update App ID, App Secret. Callback URL is :callback',
            'data_deletion_request_callback_url' => 'Set this URL :url as the Data Deletion Request URL in your Facebook app settings to allow users to request deletion of their data.',
        ],
        'google' => [
            'enable' => 'Enable Google login',
            'app_id' => 'App ID',
            'app_secret' => 'App Secret',
            'helper' => 'Please go to https://console.developers.google.com/apis/dashboard to create new app update App ID, App Secret. Callback URL is :callback',
            'use_google_button' => 'Use Google button',
            'use_google_button_helper' => 'If you enable this option, the Google button will be used instead of the default button.',
        ],
        'github' => [
            'enable' => 'Enable GitHub login',
            'app_id' => 'App ID',
            'app_secret' => 'App Secret',
            'helper' => 'Please go to https://github.com/settings/developers to create new app update App ID, App Secret. Callback URL is :callback',
        ],
        'linkedin' => [
            'enable' => 'Enable Linkedin login',
            'app_id' => 'App ID',
            'app_secret' => 'App Secret',
            'helper' => 'Please go to https://www.linkedin.com/developers/apps/new to create new app update App ID, App Secret. Callback URL is :callback',
        ],
        'linkedin-openid' => [
            'enable' => 'Enable Linkedin using OpenID Connect login',
            'app_id' => 'App ID',
            'app_secret' => 'App Secret',
            'helper' => 'Please go to https://www.linkedin.com/developers/apps/new to create new app update App ID, App Secret. Callback URL is :callback',
        ],
        'x' => [
            'enable' => 'Enable X (Twitter) login',
            'app_id' => 'Client ID',
            'app_secret' => 'Client Secret',
            'helper' => 'Please go to https://developer.x.com/en/portal/dashboard to create new app update Client ID, Client Secret. Callback URL is :callback',
        ],
        'enable' => 'Enable Social login?',
        'style' => 'Style',
        'minimal' => 'Minimal',
        'default' => 'Default',
        'basic' => 'Basic',
    ],
    'socials' => [
        'facebook' => 'Facebook',
        'google' => 'Google',
        'github' => 'GitHub',
        'linkedin' => 'Linkedin',
        'linkedin-openid' => 'Linkedin OpenID Connect',
        'x' => 'X (Twitter)',
    ],
    'menu' => 'Social Login',
    'description' => 'View and update your social login settings',
    'sign_in_with' => 'Sign in with :provider',
    'demo_mode_disabled' => 'This feature is temporary disabled in demo mode. Please use another login option. Such as Google.',
    'login_error' => 'An error occurred while trying to login',
    'invalid_state_exception' => 'InvalidStateException occurred while trying to login',
    'no_email_provided' => 'Cannot login, no email provided!',
    'login_with_social_networks' => 'Login with social networks',
    'google_not_configured' => 'Google authentication is not properly configured',
    'invalid_google_token' => 'Invalid Google token',
    'no_email_or_google_id' => 'Cannot login, no email or Google ID provided!',
    'invalid_guard_configuration' => 'Invalid guard configuration',
    'login_successful' => 'Login successful',
    'google_token_invalid' => 'Google token invalid',
    'facebook_not_configured' => 'Facebook authentication is not properly configured',
    'invalid_facebook_token' => 'Invalid Facebook token',
    'no_email_or_facebook_id' => 'Cannot login, no email or Facebook ID provided!',
    'facebook_token_invalid' => 'Facebook token invalid',
    'invalid_apple_token' => 'Invalid Apple token',
    'no_email_or_apple_id' => 'Cannot login, no email or Apple ID provided!',
    'apple_token_invalid' => 'Apple token invalid',
    'x_not_configured' => 'X (Twitter) authentication is not properly configured',
    'invalid_x_token' => 'Invalid X (Twitter) token',
    'no_email_or_x_id' => 'Cannot login, no email or X ID provided!',
    'x_token_invalid' => 'X (Twitter) token invalid',
];
